//////////////////////////////////////////////////////////////////////////
//                                perfect.c                             //
//                                                                      //
// Purpose                                                              //
// =======                                                              //
// A program that generates defective, perfect, excessive and prime     //
// numbers within a specified range.                                    //
//                                                                      //
// Author               Creation Date                                   //
// ======               =============                                   //
// C. Phillips/P.A.Lee  9 September 1998                                //
//                                                                      //
// Input/Output                                                         //
// ============                                                         //
// Input   An integer that specifies the upper limit of the range.      //
// Output  A classification of defective, perfect, excessive and prime  //
//         numbers, and for each block of 100 numbers, cumulative sums  //
//         and a histogram of those sums.                               //
//         A '.' is output every 1000 numbers to indicate progress.     //
//                                                                      //
//////////////////////////////////////////////////////////////////////////

#include <iostream>
using namespace std;

#include "Text.h"
#include "Canvas.h"

bool isDivisor(int number, int possible);
Text intToText(int i);
void drawHistogram(int finish,    int defective, int perfect,
                                  int excessive, int prime);

int main()
{
  int stopAt;
  int defective = 0;
  int perfect   = 0;
  int excessive = 0;
  int prime     = 0;

  cout << "Number to stop at: ";
  cin  >> stopAt;

  for (int number = 2; number <= stopAt; number += 1)
  {
    int sum       = 1;  // Since 1 is always a divisor

    for (int possible = 2; possible < number; possible += 1)
    {
      if (isDivisor(number, possible))
      {
        sum += possible;
      }
    } // end for int possible

    if (sum < number)
    {
      defective += 1;
      if (sum == 1)    // Identifies prime numbers
      {
      	//cout << number << " is prime" << endl;
      	prime += 1;
      }
    }
    else if (sum == number)
    {
      cout << endl << number << " is perfect" << endl;
      perfect += 1;
    }
    else // sum must be > number
    {
      excessive += 1;
    }
    if ((number % 1000) == 0)
    {
      // Output a . to show the program is still running.
      cout << '.';
      cout.flush();
    }
  } // end for (int number ...

  cout << endl 
       <<"SUMMARY: upto " << stopAt << ": "
       << "defective: "    << defective
       << "; perfect: "    << perfect
       << "; excessive: "  << excessive
       << "; prime: "      << prime << endl;
  
  // Draw the frequency histogram
  drawHistogram(stopAt, defective, perfect, excessive, prime);

  return 0;

} // end main()

bool isDivisor(int number, int possible)
{
  return ((number % possible) == 0);

} // end isDivisor()

Text intToText(int i)
{
  // Convert an integer to a string of characters
  Text message = "";

  // Take the digits one-by-one, starting with the least significant
  do
  {
    message = Text(char((i % 10) + int('0'))) + message;
    i /= 10;
  } while (i > 0);
  return message;
} // end intToText()

void drawHistogram(int finish,    int defective, int perfect,
                                  int excessive, int prime)
{
  const int HISTOGRAM_WIDTH  = 300;
	const int HISTOGRAM_HEIGHT = 200;
	const int NUMBER_BARS      = 4;
	const int MAX_BAR_HEIGHT   = HISTOGRAM_HEIGHT / 2;
	const int MARGIN           = 5;
	const int LABEL_INCREMENT  = 20;
	
	const Text TITLE   = "Percentage histogram for numbers in the range";
	const Text RANGE   = "2 - " + intToText(finish);

  Canvas histogram;
  histogram.setSize(HISTOGRAM_WIDTH + MARGIN, HISTOGRAM_HEIGHT + MARGIN);

  int barWidth;
  int characterWidth;
  int characterHeight;
  int textWidth;

  double yScale = double(MAX_BAR_HEIGHT) / double(finish);
  
  // Find out the size of the font being used
  histogram.textBoundingBox("0", characterHeight, characterWidth);
  
  // Annotate the histogram
  
  // Position titles in the middle of the canvas
  histogram.penUp();
  histogram.textBoundingBox(TITLE, characterHeight, textWidth);  
  histogram.moveTo((HISTOGRAM_WIDTH + MARGIN - textWidth)/2, 
                    HISTOGRAM_HEIGHT - MARGIN - characterHeight);
  histogram.displayText(TITLE);
  
  histogram.textBoundingBox(RANGE, characterHeight, textWidth);  
  histogram.moveTo((HISTOGRAM_WIDTH + MARGIN - textWidth)/2, 
                    HISTOGRAM_HEIGHT - MARGIN - (2 * characterHeight));
  histogram.displayText(RANGE);
  
  // Label the columns of the histogram
  // Find the size of the maximum y-axis label
  histogram.textBoundingBox("100%", characterHeight, textWidth);
  
  // Also add in the width of the Y axis line (2 pixels)
  textWidth += 2;
  
  // Calculate how wide each bar can be
  barWidth = (HISTOGRAM_WIDTH - textWidth) / 4; 

  histogram.moveTo(textWidth, MAX_BAR_HEIGHT + (2 * characterHeight));
  histogram.displayText("Defective");
  histogram.moveRelative(barWidth, 0);
  histogram.displayText("Perfect");
  histogram.moveRelative(barWidth, 0);
  histogram.displayText("Excessive");
  histogram.moveRelative(barWidth, 0);
  histogram.displayText("Prime");

  // Draw the Y axis line
  histogram.moveTo(textWidth, 0);
  histogram.penDown();
  histogram.moveRelative(0, MAX_BAR_HEIGHT + characterHeight);
  histogram.penUp();
  
  // Label the left-hand axis
  for (int i = 0; i <= 100; i += LABEL_INCREMENT)
  {
    // Draw the characters at the appropriate height
    histogram.moveTo(0, (MAX_BAR_HEIGHT * i) / 100);
    histogram.displayText(intToText(i) + "%");
    
    // Add the tick marks to the Y axis
    histogram.penDown();
    histogram.moveRelative(textWidth, 0);
    histogram.penUp();
  }

  // Draw the histogram
  
  // Scale the actual values of defective etc. to be pixel numbers
  defective = int((yScale * defective) + 0.5);
  perfect   = int((yScale * perfect)   + 0.5);
  excessive = int((yScale * excessive) + 0.5);
  prime     = int((yScale * prime)     + 0.5);
  
  histogram.moveTo(textWidth, 0);
  histogram.penDown();
  histogram.moveRelative(0, defective);
  histogram.moveRelative(barWidth - 1, 0);
  histogram.moveRelative(0, perfect - defective);
  histogram.moveRelative(barWidth - 1, 0);
  histogram.moveRelative(0, excessive - perfect);
  histogram.moveRelative(barWidth - 1, 0);
  histogram.moveRelative(0, prime - excessive);
  histogram.moveRelative(barWidth - 1, 0);
  histogram.moveRelative(0, -prime);
  histogram.penUp();

  return;
} // end drawHistogram()

