//////////////////////////////////////////////////////////////////////////
//                              scopevis.c                              //
//                                                                      //
// Purpose                                                              //
// =======                                                              //
// This program provides examples of the workings of the C++ scope and  //
// visibility rules. It is a non-sensical program, in that it isn't     //
// producing any real results, and indeed the multiple use of the same  //
// identifier like this is not good software engineering practice.      //
//                                                                      //
// Author              Creation Date                                    //
// ======              =============                                    //
// P.A. Lee            12 December 1995                                 //
//                                                                      //
// Input/Output                                                         //
// ============                                                         //
// No input is required.                                                //
//                                                                      //
// Before running the program, try to predict what output it will       //
// produce - if your predictions are correct, you clearly have some     //
// understanding of the C++ scope and visibility rules.                 //
// Try the following:                                                   //
// 1. Comment out different declaration statements and predict the      //
//    result of running (or compiling) your program.                    //
// 2. With the program in its original form can you get the contents    //
//    of the Text variable which contains "Global variable" printed     //
//    more than once by adding cout statements?                         //
// 3. Starting from the original program, which declaration statements  //
//    have to be deleted so that the content of the global Text         //
//    variable are printed by the various cout statements? You may      //
//    wish to delete some of the assignment statements as well as some  //
//    declaration statements to help make this clear.                   //
//                                                                      //
//////////////////////////////////////////////////////////////////////////

#include <iostream>
using namespace std;

#include "Text.h"

Text aString;      // A global variable, for illustrative purposes only.
                  // Remember, global variables are NOT recommended.
int main()
{
  aString = "Global variable";
  cout << aString << endl;
  
  Text aString;    // Also try the program commenting out this declaration
  
  aString = "Variable in main";
  cout << aString << endl;
  {
    cout << aString << endl;
    
    Text aString;  // Also try the program commenting out this declaration
    
    aString = "Another variable declaration";
    cout << aString << endl;
  }
  // which message will the following cout produce?
  cout << aString << endl;

  return 0;
} // end main()
