//////////////////////////////////////////////////////////////////////////
//                                playcd.c                              //
//                                                                      //
// Purpose                                                              //
// =======                                                              //
// To demonstrate the use of the CDPlayer PDT.                          //
//                                                                      //
// Author            Creation Date                                      //
// ======            =============                                      //
// P.A.Lee           12 December 1995                                   //
//                                                                      //
// Input/Output                                                         //
// ============                                                         //
// No input required. CDPlayer graphics displayed on the screen.        //
//                                                                      //
//////////////////////////////////////////////////////////////////////////

#include "CDPlayer.h"
#include "CDisc.h"
#include "CSDiscSet.h"

int main()
{
  CDPlayer  myPlayer;     // Declare the objects
  CDisc     aDisc;
  CSDiscSet someDiscs;
 
  aDisc = someDiscs.selectDisc("The 1812 Overture");
  
  myPlayer.on();          // Power on player
                          // Play the disc
                               // Put disc into player
  myPlayer.open();                   // Open drawer
  myPlayer.load(aDisc);              // Load disc
  myPlayer.close();                  // Close drawer
                               // Instruct player to play
  myPlayer.play();                   // Press "Play" button
                               // Remove disc from player
  myPlayer.open();                   // Open drawer
  aDisc = myPlayer.unload();         // Unload disc
  myPlayer.close();                  // Close drawer

  myPlayer.off();         // Power off player

  return 0;  
} // end main()

