//////////////////////////////////////////////////////////////////////////
//                              State.c                                 //
// Purpose                                                              //
// =======                                                              //
// This file is the implementation for the I/O operators for PDT State. //
//                                                                      //
// Author            Creation Date                                      //
// ======            =============                                      //
// P.A. Lee          12 December 1995                                   //
//                                                                      //
//////////////////////////////////////////////////////////////////////////

#include <iostream>
using namespace std;

#include "Text.h"
#include "State.h"

ostream& operator<<(ostream& outstream, State value)
{
  switch (value)
  {
    case OPEN:
      {
        outstream << "Open";
      }
      break;
    case CLOSED:
      {
        outstream << "Closed";
      }
      break;
    case OVERDRAWN:
      {
        outstream << "Overdrawn";
      }
      break;
    case STOPPED:
      {
        outstream << "Stopped";
      }
      break;
    case SPECIAL:
      {
        outstream << "Special";
      }
      break;
    default:
      {
        outstream << "Unexpected State value";
      }
      break;
  } // end switch (value)
  
  return outstream;
} // end operator<<()

istream& operator>>(istream& inStream, State&  forInput)
{
  Text input;
  bool gotValue = false;
  
  while (!gotValue)   // while we've not got a value
  {
    inStream >> input;
    gotValue = true;  // Set it false below if the input is illegal
    if (input == "OPEN")
    {
      forInput = OPEN;
    }
    else if (input == "CLOSED")
    {
      forInput = CLOSED;
    }
    else if (input == "OVERDRAWN")
    {
      forInput = OVERDRAWN;
    }
    else if (input == "STOPPED")
    {
      forInput = STOPPED;
    }
    else if (input == "SPECIAL")
    {
      forInput = SPECIAL;
    }
    else
    {
      cout << "Error. Got '" << input << "'" << " try again" << endl;
      gotValue = false;   // Go around while loop again
    }
  } // end while (!gotValue)
  
  return inStream;
} // end operator>>()

