//////////////////////////////////////////////////////////////////////////
//                              Enumex.c                                //
//                                                                      //
// Purpose                                                              //
// =======                                                              //
// A program to illustrate the implementation of overloaded operators   //
// for the input and output operators for an enum type.                 //
// The input operator has been defined to look for a text string as     //
// input that matches the identifier used in the enum type definition.  //
// The input operator has been defined to loop continuously until       //
// an acceptable input has been received, printing out an error         //
// message for unacceptable inputs. This isn't the normal               //
// behavior of a C++ input operator, but returning an error status      //
// is tricky and hasn't been covered yet (see Chapter 15).              //
//                                                                      //
// Author            Creation Date                                      //
// ======            =============                                      //
// P.A. Lee          12 December 1995                                   //
//                                                                      //
// Input/Output                                                         //
// ============                                                         //
// An infinite while loop is used to request input values and to print  //
// out the input that is received. You'll have to stop the execution    //
// of the program by interrupting it from the keyboard.                 //
//                                                                      //
//////////////////////////////////////////////////////////////////////////

#include <iostream>
using namespace std;

#include "Text.h"

enum CompassPoint {NORTH, SOUTH, WEST, EAST};

//////////////////////////////////////////////////////////////////////////
//                        I/O Operator Interfaces                       //
//////////////////////////////////////////////////////////////////////////

istream& operator>>(istream& instream,  CompassPoint& forInput);
ostream& operator<<(ostream& outstream, CompassPoint value);

int main()
{
  CompassPoint direction;
  
  cout << "Input CompassPoint Values as a Text string"
       << " (NORTH SOUTH WEST EAST)" << endl;
       
  while (true)           // Infinite loop. Interrupt to terminate.
  {
    cout << "CompassPoint Value: ";
    cin  >> direction;
    cout << "Got value: " << direction << endl;
  } 
  return 0;
} // end main()

//////////////////////////////////////////////////////////////////////////
//                       I/O Operator Definitions                       //
//////////////////////////////////////////////////////////////////////////

istream& operator>>(istream& instream,  CompassPoint& forInput)
{
  Text input;
  bool gotValue = false;
  
  while (!gotValue)       // While we've not got a value
  {
    instream >> input;
    gotValue = true;      // Reset to false if necessary later in the code
    if (input == "NORTH")
    {
      forInput = NORTH;
    }
    else if (input == "SOUTH")
    {
      forInput = SOUTH;
    }
    else if (input == "WEST")
    {
      forInput = WEST;
    }
    else if (input == "EAST")
    {
      forInput = EAST;
    }
    else
    {
      cout << "Error. Got '" << input << "'" << " try again" << endl;
      gotValue = false;
    }
  } // end while (!gotValue)
  
  return instream;
} // end operator>>()

ostream& operator<<(ostream& outstream, CompassPoint value)
{
  switch(value)
  {
    case NORTH:
      {
        outstream << "NORTH";
      }
      break;
    case SOUTH:
      {
        outstream << "SOUTH";
      }
      break;
    case WEST:
      {
        outstream << "WEST";
      }
      break;
    case EAST:
      {
        outstream << "EAST";
      }
      break;
    default:
      {
        outstream << "Unexpected CompassPoint value";
      }
      break;
  } // end switch(value)
  
  return outstream;
} // end operator<<()

