//////////////////////////////////////////////////////////////////////////
//                              Duration.c                              //
//                                                                      //
// Purpose                                                              //
// =======                                                              //
// Implementation file for class Duration                               //
//                                                                      //
// Author            Creation Date                                      //
// ======            =============                                      //
// P.A.Lee           12 December 1995                                   //
//////////////////////////////////////////////////////////////////////////

#include <iostream>
#include "Duration.h"

const int SECS_MIN  = 60;
const int MINS_HOUR = 60;
const int SECS_HOUR = SECS_MIN * MINS_HOUR;

                        /////////////////////////////
                        // Constructor definitions //
                        /////////////////////////////
Duration::Duration()
{
  totalSecs = 0;
  return;
} // end Duration()

Duration::Duration(int secs)
{
  totalSecs = secs;
  return;
} // end Duration(int secs)

Duration::Duration(int mins, int secs)
{
  totalSecs = (mins * SECS_MIN) + secs;
  return;
} // end Duration(int mins, int secs)

Duration::Duration(int hours, int mins, int secs)
{
  totalSecs = (hours * SECS_HOUR) + (mins * SECS_MIN) + secs;
  return;
} // end Duration(int hours, int mins, int secs)

                        /////////////////////////////////
                        // Member function definitions //
                        /////////////////////////////////
int Duration::hours()
{
  return totalSecs / SECS_HOUR;
} // end hours()

int Duration::minutes()
{
  return (totalSecs - (hours() * SECS_HOUR)) / SECS_MIN;
} // end minutes()

int Duration::seconds()
{
  return totalSecs % SECS_MIN;
} // end seconds()

                        /////////////////////////////////
                        // Member operator definitions //
                        /////////////////////////////////

                      /////////////////////////////////////
                      // Arithmetic operator definitions //
                      /////////////////////////////////////
Duration Duration::operator+(Duration rhs)
{
  return Duration(totalSecs + rhs.totalSecs);
} // end operator+()

Duration Duration::operator-(Duration rhs)
{
  return Duration(totalSecs - rhs.totalSecs);
} // end operator-()

Duration Duration::operator*(int rhs)
{
  return Duration(totalSecs * rhs);
} // end operator*()

int  Duration::operator/(Duration rhs)
{
  return (totalSecs / rhs.totalSecs);
} // end operator/(Duration)

Duration Duration::operator/(int rhs)
{
  return Duration(totalSecs / rhs);
} // end operator/(int)

Duration Duration::operator%(Duration rhs)
{
  return Duration(totalSecs % rhs.totalSecs);
} // end operator%()

                      /////////////////////////////////////
                      //   Update Operator Definitions   //
                      ///////////////////////////////////// 
                                                  
Duration& Duration::operator+=(Duration rhs)
{
  totalSecs += rhs.totalSecs;
  return *this;
} // end operator+=()

Duration& Duration::operator-=(Duration rhs)
{
  totalSecs -= rhs.totalSecs;
  return *this;
} // end operator-=()

Duration& Duration::operator*=(int rhs)
{
  totalSecs *= rhs;
  return *this;
} // end operator*=()

Duration& Duration::operator/=(int rhs)
{
  totalSecs /= rhs;
  return *this;
} // end operator/=(int)

Duration& Duration::operator%=(Duration rhs)
{
  totalSecs %= rhs.totalSecs;
  return *this;
} // end operator%=()

                      /////////////////////////////////////
                      // Comparison Operator Definitions //
                      ///////////////////////////////////// 
                                                  
bool Duration::operator==(Duration rhs)
{
  return (totalSecs == rhs.totalSecs);
} // end operator==()

bool Duration::operator!=(Duration rhs)
{
  return (totalSecs != rhs.totalSecs);
} // end operator!=()

bool Duration::operator<(Duration rhs)
{
  return (totalSecs < rhs.totalSecs);
} // end operator<()

bool Duration::operator<=(Duration rhs)
{
  return (totalSecs <= rhs.totalSecs);
} // end operator<=()

bool Duration::operator>=(Duration rhs)
{
  return (totalSecs >= rhs.totalSecs);
} // end operator>=()

bool Duration::operator>(Duration rhs)
{
  return (totalSecs > rhs.totalSecs);
} // end operator>()

                        //////////////////////////////
                        // I/O operator definitions //
                        //////////////////////////////
                        
const char IO_SEPARATOR     = ':';

istream& operator>>(istream& inStream, Duration& duration)
{
  int  hours;
  int  minutes;
  int  seconds;
  char separator;
  
  inStream >> hours   >> separator
           >> minutes >> separator
           >> seconds;
  duration = Duration(hours, minutes, seconds);
  return inStream;
} // end operator>>()

ostream& operator<<(ostream& outStream, Duration value)
{
  outStream << value.hours()   << IO_SEPARATOR
            << value.minutes() << IO_SEPARATOR
            << value.seconds();
  return outStream;
} // end operator<<()
