//////////////////////////////////////////////////////////////////////////
//                            testDuration.c                            //
//                                                                      //
// Purpose                                                              //
// =======                                                              //
// A test program for class Duration.The program contains the five      //
// test functions that wer developed to sets the class in stages.       //
// These are test1() ... test5();                                       //
// Change the commented-out function calls in main() to invoke tests.   //
//                                                                      //
// Author            Creation Date                                      //
// ======            =============                                      //
// P.A.Lee           12 December 1995                                   //
//////////////////////////////////////////////////////////////////////////

#include <iostream>
#include "Duration.h"
#include "error.h"

void test1();        // First test function written for class Duration.
void test2();        // Second test function for Duration
void test3();        // Third test function for Duration
void test4();        // Fourth test program for Duration
void test5();        // Comprehensive test function for Duration

void checkDuration(Duration duration, Duration oldDuration,
                   int hours, int mins, int secs, int totalSecs);

int main()
{
 test1();                // Commented out as the later tests were developed.
 test2();
 test3();
 test4();
 test5();
 
 cout << "End of test programs." << endl;
 
 return 0;
} // end main()

void test1()
{
  // First test function - test constructors only
  
  Duration unInit;
  Duration initSecs          = Duration(35);
  Duration initMinsSecs      = Duration(15, 40);
  Duration initHoursMinsSecs = Duration(23, 59, 58);
    
  cout << "End of Duration test 1" << endl << endl;
  return;
} // end test1()

void test2()
{
  // Second test function - testing assignment, output operation
  
  Duration unInit;
  Duration initSecs          = Duration(35);
  Duration initMinsSecs      = Duration(15, 40);
  Duration initHoursMinsSecs = Duration(23, 59, 58);
  Duration aTime;
      
  cout << "Uninitialised variable:         " << unInit            << endl
       << "35 Seconds:                     " << initSecs          << endl
       << "15 mins, 40 secs:               " << initMinsSecs      << endl
       << "23 hours, 59 mins, 58 secs:     " << initHoursMinsSecs << endl;
  
  aTime = initHoursMinsSecs;        // See if assignment works
  cout << "Assignment should give 23:59:58 " << aTime             << endl;
       
  cout << "End of Duration test 2" << endl << endl;
  return;
} // end test2()

void test3()
{
  // Third test function - testing assignment, output operation as in
  // test2, extended with some simple tests of operators
  
  Duration unInit;
  Duration initSecs          = Duration(35);
  Duration initMinsSecs      = Duration(15, 40);
  Duration initHoursMinsSecs = Duration(23, 59, 58);
  Duration aTime;
      
  cout << "Uninitialised variable:         " << unInit            << endl
       << "35 Seconds:                     " << initSecs          << endl
       << "15 mins, 40 secs:               " << initMinsSecs      << endl
       << "23 hours, 59 mins, 58 secs:     " << initHoursMinsSecs << endl;
  
  aTime = initHoursMinsSecs;        // See if assignment works
  cout << "Assignment should give 23:59:58 " << aTime             << endl;
  
  aTime = aTime + Duration(2);                // Should get to 24 hours
  cout << "Add 2 secs should give 24:0:0   " << aTime    << endl;
  
  initSecs = initSecs + Duration(3);
  cout << "After add, should be 38 secs:   " << initSecs << endl;
  if (initSecs != Duration(38))
  {
    cout << "Inequality comparison failed: should not get here" << endl;
  }
  aTime = initMinsSecs * 2;
  if ((aTime/2) != initMinsSecs)
  {
    cout << "Multiply/divide error?" << endl;
  }
  if ((aTime/initMinsSecs) != 2)
  {
    cout << "Error in divide by Duration? Expecting 2 but got " 
         << aTime/initMinsSecs << endl;
  }
  
  aTime  = initHoursMinsSecs;                // Some tests of update operators
  aTime += initSecs;
  if (aTime != (initHoursMinsSecs + initSecs))
  {
    cout << "Update-by-add failed. The variable has the value: " << aTime
         << " but expected: " << (initHoursMinsSecs + initSecs)  << endl;
  }
  aTime  = initMinsSecs; 
  aTime *= 2;
  if (aTime != (initMinsSecs * 2))
  {
    cout << "Update-by-multiply failed. The variable has the value: " << aTime
         << " but expected: " << (initMinsSecs * 2)                   << endl;
  }
  aTime /= 2;
  if (aTime != initMinsSecs)
  {
    cout << "Update-by-divide failed. The variable has the value: "  << aTime
         << " but expected: " << initMinsSecs                        << endl;
  }
  
  
  cout << "End of Duration test 3"    << endl << endl;

  return;
} // end test3()

void test4()                               // Simple test of input operator
{
  Duration inputTime = Duration(0);
 
  cout << "Testing the input operator. Type 99:0:0 to terminate." << endl;
  
  while (inputTime != Duration(99, 0, 0)) // Special value to terminate
                                          //   the loop
  {
    cout << "Duration (h:m:s): ";
    cin  >> inputTime;
    cout << " Got value: " << inputTime << endl;
  }
  cout << "End of Duration test 4" << endl << endl;
  return;
} // end test4()

const Duration ZERO = Duration(0);                    
const Duration ONE  = Duration(1);

void test5()
{
  // A comprehensive test program for Duration
  // Adapted from Robert Stroud's test program
  
  Duration defaultDuration;
  Duration oldDuration = Duration(-1);
  int totalSecs = 0;
        
  if (defaultDuration != ZERO )
  {
    error("Default Duration value should be zero");
  }
        
  for (int hours = 0 ; hours < 25; hours += 1)
  {
    for (int mins = 0; mins < 60; mins += 1)
    {
      for (int secs = 0; secs < 60; secs += 1)
      {
        Duration duration = Duration(hours, mins, secs);
        
        checkDuration(duration, oldDuration, hours, mins, secs, totalSecs);
                
        if (hours == 0 )
        {
          Duration duration = Duration(mins, secs );
          checkDuration(duration, oldDuration, hours, mins, secs, totalSecs);
                          
          if (mins == 0 )
          {
            Duration duration = Duration(secs);
                                    
            checkDuration(duration, oldDuration, hours, mins, secs, totalSecs);
           } // end if (mins == 0)
        } // end if (hours == 0)
        
        oldDuration = duration;
        totalSecs = totalSecs + 1;
      } // end for (int secs = 0; ...)
    } // end for (int mins = 0; ...)
  } // end for (int hours = 0; ...)
  
  cout << "End of Duration test 5" << endl << endl;
  return;
} // end test5()
        
void checkDuration(Duration duration, Duration oldDuration, 
                   int hours, int mins, int secs, int totalSecs)
{
  // Print out occasional values - every 15 minutes of duration;
  if ((totalSecs % (15 * 60)) == 0)
  {
    cout << duration << endl;
  }
  
  if (duration.hours() != hours)
  {
    error("hours wrong");
  }
  if (duration.minutes() != mins)
  {
    error("minutes wrong");
  }
  if (duration.seconds() != secs)
  {
    error("seconds wrong");
  }                                  
  if (duration != duration)
  {
    error("duration not equal to duration");
  }
  else if ( !(duration == duration))
  {
    error("duration should be equal to duration");
  }
  if (duration > duration)
  {
    error("duration greater than duration");
  }
  else if ( !(duration <= duration))
  {
    error("duration should be less than or equal to duration");
  }
  if (duration < duration)
  {
    error("duration less than duration");
  }
  else if ( !(duration >= duration))
  {
    error("duration should be greater than or equal to duration");
  }
        
  if (duration - duration != ZERO)
  {
    error("duration - duration should be zero");
  }
  else if (duration - oldDuration != ONE )
  {
    error("duration - oldDuration should be one");
  }
  
  if (duration == oldDuration)
  {
    error("duration equal to oldDuration");
  }
  else if ( !(duration != oldDuration))
  {
    error("duration not not equal to oldDuration");
  }
  
  if (duration <= oldDuration)
  {
    error("duration less than or equal to oldDuration");
  }
  else if ( !(duration > oldDuration))
  {
    error("duration not greater than oldDuration");
  }
  if (duration < oldDuration)
  {
    error("duration less than oldDuration");
  }
  else if ( !(duration >= oldDuration))
  {
    error("duration not greater than or equal to oldDuration");
  }
  
  Duration twiceDuration = duration * 2;

  if (twiceDuration != (duration + duration))
  {
    error("twiceDuration not equal to duration plus duration");
  }
  if (twiceDuration - duration != duration)
  {
    error("twiceDuration - duration should equal duration");
  }
  if ( (twiceDuration / 2) != duration )
  {
    error("twiceDuration / 2 should equal duration");
  }
  if ( ((twiceDuration + ONE) / 2) != duration)
  {
    error("(twiceDuration + 1) / 2 should equal duration");
  }
  if ( ((twiceDuration + ONE) % 2) != ONE)
  {
    error("(twiceDuration + 1) % 2 should equal one");
  }
  
  if (twiceDuration.seconds() != ((duration.seconds() * 2) % 60) )
  {
    error("seconds wrong for twiceDuration");
  }
  if (twiceDuration.minutes() != ((duration.minutes() * 2  + (duration.seconds() * 2) / 60 ) % 60) )
  {
    error("minutes wrong for twiceDuration");
  }
  if (twiceDuration.hours() != ((duration.hours() * 2 + (duration.minutes() * 2 + (duration.seconds() * 2) / 60) / 60)) )
  {
    error("hours wrong for twiceDuration");
  }
  
  // Now some tests on the update operators
  Duration updateDur = Duration(0);
  
  updateDur += duration;
  if (updateDur != duration)
  {
    error("duration += duration incorrect");
  }
  updateDur -= duration;
  if (updateDur != ZERO)
  {
    error("duration -= duration should be zero");
  }
  
  updateDur = duration;
  updateDur *= 2;
  if (twiceDuration != updateDur)
  {
    error("twiceDuration not equal to duration *= 2");
  }
  updateDur /= 2;
  if ( updateDur != duration )
  {
    error("updateDur /= 2 should equal duration");
  }

  return;
} // end checkDuration()
