//////////////////////////////////////////////////////////////////////////
//                                Square.c                              //
//                                                                      //
// Purpose                                                              //
// =======                                                              //
// Implementation for class Square                                      //
//                                                                      //
// Author            Creation Date                                      //
// ======            =============                                      //
// P.A.Lee           12 December 1995                                   //
//                    2 December 1998 - Updated for Standard C++.       //
//                                                                      //
//////////////////////////////////////////////////////////////////////////

//#include <iostream>  // Only needed if debugging output is used.
#include <cmath>
using namespace std;

#include "Canvas.h"
#include "Square.h"

double degreesToRadians(double);
 
Square::Square()
{
  xCenter = 0;
  yCenter = 0;
  angle = 45.0;
  setSize(0);
  return;
} // end Square();

Square::Square(int xBottomLeft, int yBottomLeft, int size)
{
  xCenter  = double(xBottomLeft) + double(size)/2.0;
  yCenter  = double(yBottomLeft) + double(size)/2.0;
  setSize(size);
  angle    = 45.0;
  return;
} // end Square(...)

void Square::drawYourself(Canvas& picture)
{
  int xCoord;
  int yCoord;
  
  picture.penUp();
  
  // Convert from concrete representation (radius, theta) to x,y coordinates
  // of the bottom left-hand corner of the square
  
  giveCoordinates(xCoord, yCoord, angle);
  picture.moveTo(xCoord, yCoord);
  picture.penDown();
  
  // Draw the four sides, each which is 90 degrees around from the start corner
  for (double addAngle = 90.0; addAngle < 361; addAngle += 90.0)
  {
    giveCoordinates(xCoord, yCoord, angle + addAngle);
    picture.moveTo(xCoord, yCoord);
  }
  picture.penUp();
  return;
} // end drawYourself()

void Square::rotateClockwise(double angleDegrees)
{
  angle += angleDegrees;
  return;
} // end rotateClockwise()

void Square::setSize(int size)
{
  radius = double(size) / sqrt(2.0);
  return;
} // end setSize()

void Square::moveRelative(int xIncrement, int yIncrement)
{
  xCenter += xIncrement;
  yCenter += yIncrement;
  return;
} // end moveRelative()

void Square::moveCenter(int xCoord, int yCoord)
{
  xCenter = xCoord;
  yCenter = yCoord;
  return;
} // end moveCenter()

// Private functions and private member functions

const double DEG_TO_RAD_FACTOR = atan(1.0) / 45.0; // atan(1.0) = PI/4

 double degreesToRadians(double angle)  // 2*PI*radians = 360 degrees
 { 
   return angle * DEG_TO_RAD_FACTOR; 
 } // end degreesToRadians()

void Square::giveCoordinates(int& x, int& y, double angleDegrees)
{
  double angleRads = degreesToRadians(angleDegrees);
  
  // Debugging code left in for future experimentation
  //cout << "x coord: " << xCenter - (radius * sin(angleRads))
  //     << ", int: "   << int(xCenter - (radius * sin(angleRads)) + 0.5)
  //     << endl
  //     << "y coord: " << yCenter - (radius * cos(angleRads))
  //     << ", int: "   << int(yCenter - (radius * cos(angleRads)) + 0.5)
  //     << endl;
  x = int(xCenter - (radius * sin(angleRads)) + 0.5);
  y = int(yCenter - (radius * cos(angleRads)) + 0.5);
  return;
} // end giveCoordinates()
  

