//////////////////////////////////////////////////////////////////////////
//                              FloatFormat.c                           //
// Purpose                                                              //
// =======                                                              //
// To demonstrate the output of floating-point numbers using general    //
// (default), scientific and fixed formats                              //
//                                                                      //
// Author            Creation Date                                      //
// ======            =============                                      //
// C. Phillips       16 November 1998                                   //
//                                                                      //
// Input/Output                                                         //
// ============                                                         //
// No input is required                                                 //
// The program outputs the same number in the different formats for     //
// comparison purposes                                                  //
//                                                                      //
//////////////////////////////////////////////////////////////////////////

#include <iostream>
using namespace std;

int main()
{ 
  cout << "Demonstrating the floating point output modes" << endl
       << "---------------------------------------------" << endl;

  cout << 1234.56789 << "\t\t\t" << "default" << endl;
  cout.setf(ios_base::scientific, ios_base::floatfield);
  cout << 1234.56789 << '\t' << "scientific" << endl;
  cout << 1234.56789 << '\t' << "still scientific" << endl;
  cout.setf(ios_base::fixed, ios_base::floatfield);
  cout << 1234.56789 << "\t\t" << "fixed" << endl;

  cout << "---------------------------------------------" << endl << endl
       << "Demonstrating the use of precision           " << endl
       << "---------------------------------------------" << endl;
  
  cout.setf(0, ios_base::floatfield);  // Set the mode back to the default

  cout.precision(5);
  cout << "Output of 1234.56789 with precision 5" << endl <<endl;
  
  cout << 1234.56789 << "\t\t\t" << "default" << endl;
  cout.setf(ios_base::scientific, ios_base::floatfield);
  cout << 1234.56789 << "\t\t" << "scientific" << endl;
  cout.setf(ios_base::fixed, ios_base::floatfield);
  cout << 1234.56789 << "\t\t" << "fixed" << endl;

  cout << "---------------------------------------------" << endl << endl
       << "Demonstrating the use of width               " << endl
       << "---------------------------------------------" << endl;
  
  cout.setf(0, ios_base::floatfield);  // Set the mode back to the default
  
  cout.width(10);
  cout << 12345 << '\t'   << "width was set to 10" << endl;
  cout << 12345 << "\t\t" << "automatically back to the default" << endl;
  cout.precision(2);
  cout.width(10);
  cout << 3.14159 << '\t' << "precision set to 2, width to 10" << endl;
  
  cout << "---------------------------------------------" << endl << endl
       << "Demonstrating the use of justification & fill" << endl
       << "---------------------------------------------" << endl;
  
  cout.setf(0, ios_base::floatfield);  // Set the mode back to the default
  
  cout.width(10);
  cout.setf(ios_base::left, ios_base::adjustfield);
  cout << 12345 << '\t'   << "width 10, left-justified" << endl;
  cout.width(10);
  cout.setf(ios_base::right, ios_base::adjustfield);
  cout << 12345 << '\t'   << "width 10, right-justified" << endl;
  cout.precision(2);
  cout.width(10);
  cout << 3.14159 << '\t' << "precision set to 2, width 10, " 
       << "right-justified" << endl;
       
  
  cout.fill('*');
  cout.width(10);
  cout.setf(ios_base::left, ios_base::adjustfield);
  cout << 12345 << '\t'   << "width 10, left-justified, fill *" << endl;
  cout.width(10);
  cout.setf(ios_base::right, ios_base::adjustfield);
  cout << 12345 << '\t'   << "width 10, right-justified, fill *" << endl;
  cout.precision(2);
  cout.width(10);
  cout << 3.14159 << '\t' << "precision set to 2, width 10, " 
       << "right-justified, fill *" << endl;


  return 0;
} // end main()
