      SUBROUTINE MAXFUN(FUN,DEPAR,THETA,F,NFE,LFL)
C
C--MAXFUN VERSION 6.0 (1-APR-1994)
C
C  Copyright 1994 R.C. Elston
C
C  This program is free software; you can redistribute it and/or modify
C  it under the terms of the GNU General Public License as published by
C  the Free Software Foundation; either version 2, or (at your option)
C  any later version.
C
C  This program is distributed in the hope that it will be useful,
C  but WITHOUT ANY WARRANTY; without even the implied warranty of
C  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C  GNU General Public License for more details.
C
C  You should have received a copy of the GNU General Public License
C  along with this program; if not, write to the Free Software
C  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
C
C--WRITTEN BY ALEXA J. M. SORANT AND ROBERT C. ELSTON,
C--WITH ALGORITHMS FOR DIRECT SEARCH AND NEWTON-RAPHSON METHODS ADAPTED
C--FROM MAXLIK (BY E. B. KAPLAN AND R. C. ELSTON) AND ALGORITHM FOR
C--VARIABLE METRIC METHOD ADAPTED FROM GEMINI (BY J. M. LALOUEL)
C
C--MAXIMIZES A FUNCTION SPECIFIED BY CALLER (IN SUBROUTINE FUN) WITH
C--RESPECT TO PARAMETERS (ARRAY THETA) SUBJECT TO RESTRICTIONS SPECIFIED
C--BY CALLER (IN SUBROUTINE DEPAR AND BOUND ARRAYS THL AND THU)
C
C--RETURNS FLAG LFL:
C--   0:  NO ERRORS FOUND, BUT ZERO ITERATIONS REQUESTED
C--   1:  CONVERGED BY CRITERION 1 (IN BCNVCH OR VCNVCH)
C--   2:  CONVERGED BY CRITERION 2:  NORMALIZED GRADIENT 
C--       <= SPECIFIED TOLERANCE EPSC2 (IN NRSTEP OR DIRECT)
C--   3:  CONVERGED BY CRITERION 3:  CHANGE IN FUNCTION VALUE LESS THAN
C--       SPECIFIED TOLERANCE EPSC3 (IN BCNVCH OR VCNVCH)
C--   4:  REACHED MAXIMUM # ITERATIONS
C--   5:  ACCUMULATION OF ROUNDING ERROR OR BOUNDARY PROBLEM PREVENTS 
C--       FURTHER PROGRESS (VARIABLE METRIC METHOD) (NO STEP COMPLETED 
C--       IN LSRCH)
C--   6:  SEARCH DIRECTION NOT UPWARDS (VARIABLE METRIC METHOD)
C--       (IN DIRECT)
C--   7:  ALL SIGNIFICANT DIGITS LOST IN OPTIMAL CONDITIONING DURING
C--       UPDATE OF B MATRIX (VARIABLE METRIC METHOD) (IN BUPDT)
C--   8:  GRADIENT COULD NOT BE COMPUTED (IN DERIV1)
C--   9:  VARIANCE-COVARIANCE MATRIX COULD NOT BE COMPUTED (IN VCMX)
C--  10:  ALL INDEPENDENT PARAMETERS CONVERGED TO BOUNDS (IN FIXBND)
C--  11:  TOO MANY PARAMETERS TO USE DERIVATIVES (IN PREPD)
C--  12:  UNACCEPTABLE INITIAL ESTIMATES (IN MAXFUN)
C--  13:  INVALID CONTROL INPUT (IN MAXFUN)
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      PARAMETER (NP=45,NPV=45)
      PARAMETER (PRECIS=2.D0**(-45))
      PARAMETER (TAU=0.5D0)
      COMMON /MAXFOP/ IOUT,IDET,LPRT
      COMMON /MAXF1/ THIN(NP),THL(NP),THU(NP),STPIN(NP),EPSD,YOTA,EPST,
     $               EPSC1,EPSC2,EPSC3,ISTIN(NP),NT,MAXIT,METHOD,IXVC,
     $               IHIT
      COMMON /MAXF2/ THPR(NP),CTH(NP),STP(NP),G(NPV),H(NPV,NPV),
     $               V(NPV,NPV),AV(NP,NP),STDE(NP),ULT(NPV,NPV),
     $               DIAG(NPV),PDIR(NPV),ERM,FPR,FCH,DIFMAX,GTG,PTG,
     $               TSTEP,IST(NP),NE,ND,NI,NB,NV,IMPBND,IT,NSURF2,IGFL,
     $               IVFL,IGAGE,IVAGE,IDIF
      CHARACTER*28 LABEL
      CHARACTER*36 STATUS
      COMMON /MAXFLB/ LABEL(NP)
      COMMON /MAXFST/ STATUS(10)
      DIMENSION THETA(*),DTH(NP),GPR(NPV)
      EXTERNAL FUN,DEPAR
      EXTERNAL AUGV,BINIT,BSRCH,BUPDT,COPYR,DERIV1,DIRECT,FIXBND,LBD,
     $         LBV,LF,LSRCH,NRSTEP,NSRCH,PREPD,PSRCH,VCMX
C
C--INITIALIZE EXIT FLAG
C
      LFL = 0
C
C--PRINT INITIAL MESSAGES AND CHECK INPUT
C
      IF (IOUT .GE. 0) GO TO 10
      PRINT 1
1     FORMAT (2(/' ',32('----')))
      PRINT 2
2     FORMAT (' MAXFUN              FEB 1997')
      PRINT 3, IOUT
3     FORMAT ('0INVALID IOUT =',I4)
      LFL = 13
      RETURN
C
10    IF (IOUT .GT. 0) THEN
         WRITE (IOUT,1)
         WRITE (IOUT,2)
         CALL COPYR(IOUT)
         WRITE (IOUT,11)
11       FORMAT (' ')
      END IF
C
      IF (IDET .LT. 0) THEN
         IF (IOUT .GT. 0) WRITE (IOUT,12) IDET
12       FORMAT (' INVALID IDET =',I4)
         LFL = 13
      ELSE IF (IDET .GT. 0 .AND. IDET .NE. IOUT) THEN
         WRITE (IDET,1)
         WRITE (IDET,2)
         CALL COPYR(IDET)
         WRITE (IDET,11)
      END IF
C
      IF (METHOD .GE. 1 .AND. METHOD .LE. 6) GO TO 20
      IF (IOUT .GT. 0) WRITE (IOUT,13) METHOD
13    FORMAT (' INVALID METHOD =',I4)
      LFL = 13
C
20    IF (NT .GT. 0 .AND. NT .LE. NP) GO TO 30
      IF (IOUT .GT. 0) WRITE (IOUT,21) NT
21    FORMAT (' INVALID NT =',I4)
      LFL = 13
      GO TO 90
C
30    NE = 0
      ND = 0
      DO 60 I=1,NT
      ISTI = ISTIN(I)
      GO TO (50,50,40,60), ISTI
      IF (IOUT .GT. 0) WRITE (IOUT,31) I,ISTI
31    FORMAT (' INVALID ISTIN(',I2,') =',I4)
      LFL = 13
      GO TO 60
40    ND = ND + 1
50    NE = NE + 1
60    CONTINUE
C
      IF (NE .GT. 0) GO TO 70
      IF (IOUT .GT. 0) WRITE (IOUT,61)
61    FORMAT (' ALL PARAMETERS FIXED')
      LFL = 13
      GO TO 90
70    IF (ND .LT. NE) GO TO 80
      IF (IOUT .GT. 0) WRITE (IOUT,71)
71    FORMAT (' ALL PARAMETERS FIXED OR DEPENDENT')
      LFL = 13
      GO TO 90
C
80    IF (LFL .EQ. 0) GO TO 100
C
90    IGFL = 2
      IF (IOUT .LE. 0) RETURN
      WRITE (IOUT,91)
91    FORMAT ('0MAXIMIZATION NOT ATTEMPTED DUE TO IMPROPER CONTROL ',
     $        'INPUT')
      WRITE (IOUT,1)
      RETURN
C
C--SUBSTITUTE DEFAULTS IF NECESSARY
C
100   IF (IXVC .LT. 0 .OR. IXVC .GT. 2) IXVC = 0
      IF (IHIT .LT. 0 .OR. IHIT .GT. 1) IHIT = 0
      IF (EPSC1 .LE. 0.D0 .OR. EPSC1 .GE. TAU) EPSC1 = 1.D-3
      IF (EPSC2 .LE. 0.D0) EPSC2 = 1.D-15
      IF (EPSC3 .LT. 0.D0) EPSC3 = 0.D0
      IF (EPSD .LE. 1.D-9 .OR. EPSD .GE. TAU) THEN
         IF (EPSC1 .GT. 1.D-9) THEN
            EPSD = EPSC1
         ELSE 
            EPSD = 1.D-3
         END IF
      END IF
      IF (YOTA .LE. 0.D0 .OR. YOTA .GE. 1.D0) YOTA = 10.D0*DSQRT(PRECIS)
      IF (EPST .LE. 0.D0) EPST = 10.D0*DSQRT(YOTA)
      DO 110 I=1,NT
      SI = STPIN(I)
110   IF (SI .LE. 0.D0 .OR. SI .GE. 1.D0) STPIN(I) = .1D0
C
C--PRINT OUT CONTROL VALUES
C
      IF (IOUT .LE. 0) GO TO 120
      IF (IDET .GT. 0) WRITE (IOUT,111) IDET
111   FORMAT (' ITERATION DETAILS WILL BE WRITTEN IN FILE ',
     $        'CORRESPONDING TO UNIT',I3)
      WRITE (IOUT,112) NT,NE,ND,MAXIT,IXVC,IHIT,EPSD,YOTA,EPST,EPSC1,
     $                 EPSC2,EPSC3
112   FORMAT (' TOTAL # PARAMETERS IN THE MODEL NT =',I3,
     $        '; # PARAMETERS TO BE ESTIMATED NE =',I3,
     $        '; # DEPENDENT PARAMETERS ND =',I3/
     $        ' MAXIMUM # ITERATIONS MAXIT =',I4/
     $        ' CONTROL VALUES:'/'    IXVC =',I2,'; IHIT =',I2,';'/
     $        '    EPSD =',E10.3,'; YOTA =',E10.3,'; EPST =',E10.3,
     $        '; EPSC1 =',E10.3,'; EPSC2 =',E10.3,'; EPSC3 =',E10.3/
     $        ' ',32('----'))
C
C--GENERAL INITIALIZATION
C
120   IGAGE = -1
      IVAGE = -1
      IGFL = 0
      IVFL = 5
      IH = IHIT
      NSURF2 = 0
      IMPBND = 0
      IT = 0
      NFE = 0
      NI = NE - ND
      DO 130 I=1,NT
      ISTI = ISTIN(I)
      IST(I) = ISTI
      STP(I) = STPIN(I)
      THI = THIN(I)
      IF (ISTI .EQ. 3) GO TO 130
      IF (THI .LT. THL(I) .OR. THI .GT. THU(I)) LFL = 12
130   THETA(I) = THI
      IF (LFL .GT. 0) GO TO 140
      CALL FUN(THETA,F,NFE,LEX)
      IF (LEX .LE. 0) GO TO 150
      LFL = 12
C
C--INITIAL ESTIMATES INVALID
C
140   IGFL = 2
      IF (IOUT .LE. 0) RETURN
      WRITE (IOUT,141)
141   FORMAT ('0MAXIMIZATION NOT ATTEMPTED:  ',
     $        'INITIAL ESTIMATES NOT IN DOMAIN OF THE FUNCTION')
      CALL LBV(THETA,F,0)
      WRITE (IOUT,1)
      RETURN
C
C--CHECK FOR POSSIBLE ZERO-ITERATION RUN
C
150   IF (MAXIT .GT. 0) GO TO 170
      CALL PREPD(FUN,DEPAR,THETA,F,NFE,LEX)
      IF (LEX .LE. 0) GO TO 160
      IGFL = 2
      GO TO 7080
160   IF (IXVC .LE. 0) GO TO 7050
      GO TO 7000
C
C--SELECT PATH FOR CHOSEN METHOD
C
170   GO TO (1000,2000,3000,4000,5000,6000), METHOD
C
C--METHOD 1:  DIRECT SEARCH METHOD, INCLUDING BASIC SEARCH AND 
C--2**(NI)-TRIAL SEARCH
C
C--PRINT METHOD IDENTIFICATION AND INITIAL VALUES
C
1000  IF (IDET .GT. 0 .AND. IDET .NE. IOUT) WRITE (IDET,1001)
1001  FORMAT ('0METHOD 1:  DIRECT SEARCH METHOD')
      IF (IOUT .LE. 0) GO TO 1010
      WRITE (IOUT,1001)
      CALL LBD(THETA,F)
C
C--START BASIC ITERATION PROCESS
C
1010  CALL BSRCH(FUN,THETA,F,NFE,IFLB)
C
C--IF REACHED MAXIMUM # ITERATIONS, EXIT
C
      IF (IFLB .LT. 3) GO TO 1020
      LFL = 4
      GO TO 7030
C
C--SKIP OTHER TYPES OF SEARCH IF ONLY ONE PARAMETER TO VARY
C
1020  IF (NI .LE. 1) GO TO 1050
C
C--SEARCH 2(NI) "NEIGHBORING" PARAMETER SETS
C
      CALL NSRCH(FUN,THETA,F,NFE,DTH,IFL)
      IF (IFL .GT. 0) GO TO 1030
C
C--SIGNIFICANT IMPROVEMENT; IF < MAXIMUM # ITERATIONS, GO BACK TO BASIC
C--ITERATION PROCESS
C
      IF (IT .LT. MAXIT) GO TO 1010
      IF (IOUT .GT. 0) WRITE (IOUT,1021) IT
1021  FORMAT ('0STOPPED AT',I4,' ITERATIONS (REACHED ITERATION LIMIT)')
      LFL = 4
      GO TO 7030
C
C--CHECK WHETHER HAVE DONE 2**(NI)-TRIAL SEARCH MORE THAN ONCE ALREADY
C
1030  IF (NSURF2 .LE. 1) GO TO 1040
      NSURF2 = 3
      IF (IOUT .GT. 0) WRITE (IOUT,1031)
1031  FORMAT ('02**(NI)-TRIAL SEARCH PRODUCED SIGNIFICANT IMPROVEMENT',
     $        ' TWICE; NOT TRIED A THIRD TIME'/
     $        ' DIRECT SEARCH ITERATION METHOD MAY NOT BE APPROPRIATE')
      GO TO 1050
C
C--SEARCH 2**(NI) NEIGHBORING PARAMETER SETS;
C--IF SIGNIFICANT IMPROVEMENT, GO BACK TO BASIC SEARCH PROCESS
C
1040  CALL PSRCH(FUN,THETA,F,NFE,DTH,IFL)
      IF (IFL .LE. 0) GO TO 1010
C
C--FINISH UP
C
1050  LFL = 1
      IF (IFLB .GT. 1) LFL = 3
      CALL PREPD(FUN,DEPAR,THETA,F,NFE,LEX)
      IF (LEX .LE. 0) GO TO 1060
      IGFL = 2
      GO TO 7030
1060  IF (IXVC .LE. 0) GO TO 7030
      GO TO 7000
C
C--METHOD 2:  DIRECT SEARCH METHOD, SKIPPING 2**(NI)-TRIAL SEARCH
C
C--PRINT METHOD IDENTIFICATION AND INITIAL VALUES
C
2000  IF (IDET .GT. 0 .AND. IDET .NE. IOUT) WRITE (IDET,2001)
2001  FORMAT ('0METHOD 2:  DIRECT SEARCH METHOD, WITHOUT 2**(NI)-',
     $        'TRIAL SEARCH')
      IF (IOUT .LE. 0) GO TO 2010
      WRITE (IOUT,2001)
      CALL LBD(THETA,F)
C
C--START BASIC ITERATION PROCESS
C
2010  CALL BSRCH(FUN,THETA,F,NFE,IFLB)
C
C--IF REACHED MAXIMUM # ITERATIONS, EXIT
C
      IF (IFLB .LT. 3) GO TO 2020
      LFL = 4
      GO TO 7030
C
C--SKIP OTHER TYPE OF SEARCH IF ONLY ONE PARAMETER TO VARY
C
2020  IF (NI .LE. 1) GO TO 2030
C
C--SEARCH 2(NI) "NEIGHBORING" PARAMETER SETS 
C
      CALL NSRCH(FUN,THETA,F,NFE,DTH,IFL)
      IF (IFL .GT. 0) GO TO 2030
C
C--SIGNIFICANT IMPROVEMENT; IF < MAXIMUM # ITERATIONS, GO BACK TO BASIC
C--ITERATION PROCESS
C
      IF (IT .LT. MAXIT) GO TO 2010
      IF (IOUT .GT. 0) WRITE (IOUT,1021) IT
      LFL = 4
      GO TO 7030
C
C--FINISH UP
C
2030  LFL = 1
      IF (IFLB .GT. 1) LFL = 3
      CALL PREPD(FUN,DEPAR,THETA,F,NFE,LEX)
      IF (LEX .LE. 0) GO TO 2040
      IGFL = 2
      GO TO 7030
2040  IF (IXVC .LE. 0) GO TO 7030
      GO TO 7000
C
C--METHOD 3:  NEWTON-RAPHSON METHOD WITHOUT RECOMPUTATION OF VARIANCE-
C--COVARIANCE MATRIX
C
C--PRINT METHOD IDENTIFICATION AND INITIAL VALUES
C
3000  IF (IDET .GT. 0 .AND. IDET .NE. IOUT) WRITE (IDET,3001)
3001  FORMAT ('0METHOD 3:  NEWTON-RAPHSON METHOD, WITHOUT ',
     $        'RECOMPUTATION OF VARIANCE-COVARIANCE MATRIX')
      IF (IOUT .LE. 0) GO TO 3010
      WRITE (IOUT,3001)
      CALL LBV(THETA,F,1)
C
C--PREPARE FOR NEWTON-RAPHSON ITERATION
C
3010  CALL PREPD(FUN,DEPAR,THETA,F,NFE,LEX)
      IF (LEX .LE. 0) GO TO 3020
      LFL = LEX + 9
      IGFL = 2
      RETURN
C
C--USE CENTRAL DIFFERENCE FOR GRADIENT CALCULATIONS
C
3020  IDIF = 2
C
C--COMPUTE NEW VARIANCE-COVARIANCE MATRIX FIRST TIME OR IF PARAMETERS
C--BECOME FIXED
C
3030  CALL VCMX(FUN,DEPAR,THETA,F,NFE,IHIT)
      IF (IVFL .LT. 3) GO TO 3040
      LFL = 9
      GO TO 7030
C
C--COMPUTE GRADIENT VECTOR
C
3040  CALL DERIV1(FUN,THETA,F,NFE)
      IF (IGFL .LE. 0) GO TO 3050
      LFL = 8
      GO TO 7030
C
C--DO ONE NEWTON-RAPHSON ITERATION
C
3050  CALL NRSTEP(FUN,THETA,F,NFE,IFL)
C
C--GO BACK TO COMPUTE NEW G UNLESS MET SOME STOPPING CRITERION
C
      GO TO (3060,3080,3090,3080,3120), IFL+1
C
C--CHECK FOR CONVERGENCE TO BOUNDS BEFORE NEXT ITERATION
C
3060  CALL FIXBND(FUN,DEPAR,THETA,F,NFE,LEX)
      GO TO (3040,3030,3070), LEX+1
3070  LFL = 10
      GO TO 7030
C
C--CONVERGED; IF ITERATION DONE, CHECK FOR CONVERGENCE TO BOUNDS BEFORE
C--QUITTING
C
3080  CALL FIXBND(FUN,DEPAR,THETA,F,NFE,LEX)
C
3090  LFL = IFL
      GO TO (7030,3110,3100), IXVC+1
3100  IF (IHIT .LE. 0) GO TO 7000
3110  IF (IXVC+IVAGE .LE. 2) GO TO 7030
      GO TO 7000
C
C--REACHED MAXIMUM # ITERATIONS
C
3120  LFL = 4
      GO TO 7030
C
C--METHOD 4:  NEWTON-RAPHSON METHOD WITH RECOMPUTATION OF VARIANCE-
C--COVARIANCE MATRIX AT EACH ITERATION
C
C--PRINT METHOD IDENTIFICATION AND INITIAL VALUES
C
4000  IF (IDET .GT. 0 .AND. IDET .NE. IOUT) WRITE (IDET,4001)
4001  FORMAT ('0METHOD 4:  NEWTON-RAPHSON METHOD')
      IF (IOUT .LE. 0) GO TO 4010
      WRITE (IOUT,4001)
      CALL LBV(THETA,F,1)
C
C--PREPARE FOR NEWTON-RAPHSON ITERATION
C
4010  CALL PREPD(FUN,DEPAR,THETA,F,NFE,LEX)
      IF (LEX .LE. 0) GO TO 4020
      LFL = LEX + 9
      IGFL = 2
      RETURN
C
C--USE CENTRAL DIFFERENCE FOR GRADIENT CALCULATIONS
C
4020  IDIF = 2
C
C--COMPUTE NEW VARIANCE-COVARIANCE MATRIX AND VECTOR OF 1ST PARTIAL
C--DERIVATIVES
C
4030  CALL VCMX(FUN,DEPAR,THETA,F,NFE,IHIT)
      IF (IVFL .LT. 3) GO TO 4040
      LFL = 9
      GO TO 7030
C
4040  CALL DERIV1(FUN,THETA,F,NFE)
      IF (IGFL .LE. 0) GO TO 4050
      LFL = 8
      GO TO 7030
C
C--DO ONE NEWTON-RAPHSON ITERATION
C
4050  CALL NRSTEP(FUN,THETA,F,NFE,IFL)
C
C--GO BACK TO COMPUTE NEW V AND G UNLESS MET SOME STOPPING CRITERION
C
      GO TO (4060,4070,4080,4070,4110), IFL+1
C
C--CHECK FOR CONVERGENCE TO BOUNDS BEFORE NEXT ITERATION
C
4060  CALL FIXBND(FUN,DEPAR,THETA,F,NFE,LEX)
      IF (LEX .LE. 1) GO TO 4030
      LFL = 10
      GO TO 7030
C
C--CONVERGED; IF ITERATION DONE, CHECK FOR CONVERGENCE TO BOUNDS BEFORE
C--QUITTING
C
4070  CALL FIXBND(FUN,DEPAR,THETA,F,NFE,LEX)
C
4080  LFL = IFL
      GO TO (7030,4100,4090), IXVC+1
4090  IF (IHIT .LE. 0) GO TO 7000
4100  IF (IXVC+IVAGE .LE. 2) GO TO 7030
      GO TO 7000
C
C--REACHED MAXIMUM # ITERATIONS
C
4110  LFL = 4
      GO TO 7030
C
C--METHOD 5:  VARIABLE METRIC METHOD WITH INITIAL B = IDENTITY
C
C--PRINT METHOD IDENTIFICATION
C
5000  IF (IDET .GT. 0 .AND. IDET .NE. IOUT) WRITE (IDET,5001)
5001  FORMAT ('0METHOD 5:  VARIABLE METRIC METHOD',
     $        ', USING NEGATIVE IDENTITY FOR INITIAL HESSIAN')
      IF (IOUT .GT. 0) WRITE (IOUT,5001)
C
C--SET SWITCH FOR INITIAL B:  DON'T COMPUTE HESSIAN
C
      IHESS = 0
C
C--METHOD 6 JOINS PATH AT THIS POINT
C
C--PRINT INITIAL VALUES
C
5010  IF (IOUT .GT. 0) CALL LBV(THETA,F,1)
C
C--PREPARE FOR DERIVATIVE COMPUTATION
C
      CALL PREPD(FUN,DEPAR,THETA,F,NFE,LEX)
      IF (LEX .LE. 0) GO TO 5020
      LFL = LEX + 9
      IGFL = 2
      RETURN
C
C--INITIALIZE B MATRIX (ULT, DIAG) AND FLAGS
C
5020  CALL BINIT(FUN,DEPAR,THETA,F,NFE,IHESS)
      IDIF = 1
      IFIRST = 1
5030  IUPDT = 0
C
C--START ITERATION
C
C--COMPUTE NEW GRADIENT G, FIRST SAVING OLD ONE FOR BUPDT
C
5040  DO 5050 L=1,NV
5050  GPR(L) = G(L)
      CALL DERIV1(FUN,THETA,F,NFE)
      IF (IGFL .LE. 0) GO TO 5060
      LFL = 8
      GO TO 7030
C
C--IF APPROPRIATE, UPDATE B (ULT, DIAG)
C
5060  IF (IUPDT .LE. 0) GO TO 5070
      CALL BUPDT(GPR,LEX)
      IF (LEX .LE. 0) GO TO 5070
      LFL = 7
      GO TO 5210
C
C--COMPUTE NEW DIRECTION OF SEARCH
C
5070  CALL DIRECT(LEX)
      GO TO (5100,5080,5090), LEX+1
5080  LFL = 2
      GO TO 5210
5090  IF (IDIF .EQ. 1) GO TO 5200
      IF (IOUT .GT. 0) WRITE (IOUT,5091) IT
5091  FORMAT ('0STOPPED AFTER ITERATION',I4,
     $        ' BECAUSE SEARCH DIRECTION IS NOT UPWARDS')
      LFL = 6
      GO TO 5210
C
C--DO LINE SEARCH IN CHOSEN DIRECTION TO COMPLETE ONE ITERATION
C
5100  CALL LSRCH(FUN,THETA,F,NFE,IFIRST,IFL)
      GO TO (5110,5120,5150,5160,5180,5190), IFL+2
C
C--ITERATION COMPLETED, BUT T < INITIAL T AND < TMIN
C
5110  IUPDT = 0
      IF (IDIF .EQ. 2) GO TO 5130
      IF (IDET .GT. 0) WRITE (IDET,5201)
      IDIF = 2
      GO TO 5130
C
C--ITERATION SUCCESSFULLY COMPLETED  WITH T >= INITIAL T AND/OR TMIN
C
5120  IUPDT = 1
C
C--CHECK FOR CONVERGENCE TO BOUNDS BEFORE NEXT ITERATION
C
5130  CALL FIXBND(FUN,DEPAR,THETA,F,NFE,LEX)
      GO TO (5040,5020,5140), LEX+1
5140  LFL = 10
      GO TO 7030
C
C--CONVERGED BY STANDARD TEST
C
5150  LFL = 1
      GO TO 5170
C
C--NEGLIGIBLE FUNCTION CHANGE
C
5160  LFL = 3
C
C--CHECK FOR CONVERGENCE TO BOUNDS BEFORE QUITTING
C
5170  CALL FIXBND(FUN,DEPAR,THETA,F,NFE,LEX)
      GO TO 5210
C
C--REACHED MAXIMUM # ITERATIONS
C
5180  LFL = 4
      GO TO 7030
C
C--COULD NOT COMPLETE ITERATION
C
5190  IF (IDIF .EQ. 1) GO TO 5200
      IF (IOUT .GT. 0) WRITE (IOUT,5191) IT
5191  FORMAT ('0STOPPED AFTER ITERATION',I4,
     $        ' BECAUSE ACCUMULATION OF ROUNDING ERRORS PREVENTS ',
     $        'FURTHER PROGRESS')
      LFL = 5
      GO TO 5210
C
C--SWITCH TO CENTRAL DIFFERENCE COMPUTATION OF GRADIENT 
C--AND RETRY THIS ITERATION
C
5200  IF (IDET .GT. 0) WRITE (IDET,5201)
5201  FORMAT (' ',32('----')/
     $        ' SWITCH TO CENTRAL DIFFERENCE IN GRADIENT COMPUTATION'/
     $        ' ',32('----'))
      IDIF = 2
      GO TO 5030
C
C--FINISH UP
C
5210  IF (IXVC .GT. 0) GO TO 7000
      GO TO 7030
C
C--METHOD 6:  VARIABLE METRIC METHOD WITH INITIAL B = -H 
C--           COMPUTED AT INITIAL ESTIMATES
C
C--PRINT METHOD IDENTIFICATION
C
6000  IF (IDET .GT. 0 .AND. IDET .NE. IOUT) WRITE (IDET,6001)
6001  FORMAT ('0METHOD 6:  VARIABLE METRIC METHOD, ',
     $        'COMPUTING INITIAL HESSIAN')
      IF (IOUT .GT. 0) WRITE (IOUT,6001)
C
C--SET SWITCH TO COMPUTE INITIAL HESSIAN
C
      IHESS = 1
C
C--JOIN METHOD 5 PATH
C
      GO TO 5010
C
C--FINAL OUTPUT AND TERMINATION
C
C--OBTAIN VARIANCE-COVARIANCE MATRIX FOR FINAL ESTIMATES
C
7000  IF (IDET .GT. 0) WRITE (IDET,7001)
7001  FORMAT ('0VARIANCE-COVARIANCE MATRIX WILL BE COMPUTED TO ',
     $        'CORRESPOND TO FINAL ESTIMATES')
      IF (IXVC .GE. 2) IH = 1
      IF (IH .LE. IHIT) GO TO 7020
      DO 7010 I=1,NT
7010  STP(I) = EPSD
7020  CALL VCMX(FUN,DEPAR,THETA,F,NFE,IH)
C
C--AUGMENT AND PRINT FINAL VARIANCE-COVARIANCE MATRIX (IF ONE IS
C--AVAILABLE) AND COMPUTE STANDARD DEVIATIONS
C
7030  IF (IVFL .GE. 3) GO TO 7050
      CALL AUGV(DEPAR,THETA,IH)
C
C--COMPUTE (IF NECESSARY) FINAL GRADIENT
C
7050  IF (IGAGE) 7060,7080,7070
7060  IF (IGFL .GT. 0) GO TO 7080
7070  IDIF = 2
      CALL DERIV1(FUN,THETA,F,NFE)
C
C--PRINT FINAL VALUES
C
7080  IF (IOUT .GT. 0) CALL LF(THETA,F,NFE)
C
      RETURN
C
      END
      SUBROUTINE BSRCH(FUN,THETA,F,NFE,IFL)
C
C--BASIC ITERATION PROCESS OF DIRECT SEARCH
C
C--RETURNS FLAG IFL:
C--   1:  CONVERGED BY CRITERION 1
C--   2:  CONVERGED BY NEGLIGIBLE FUNCTION CHANGE (CRITERION 3)
C--   3:  REACHED MAXIMUM # ITERATIONS
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      PARAMETER (NP=45,NPV=45)
      EXTERNAL BCNVCH,BNDCHK,DFN,DFNINV,EFN,ENDIT,FUN,LITD
      COMMON /MAXFOP/ IOUT,IDET,LPRT
      COMMON /MAXF1/ THIN(NP),THL(NP),THU(NP),STPIN(NP),EPSD,YOTA,EPST,
     $               EPSC1,EPSC2,EPSC3,ISTIN(NP),NT,MAXIT,METHOD,IXVC,
     $               IHIT
      COMMON /MAXF2/ THPR(NP),CTH(NP),STP(NP),G(NPV),H(NPV,NPV),
     $               V(NPV,NPV),AV(NP,NP),STDE(NP),ULT(NPV,NPV),
     $               DIAG(NPV),PDIR(NPV),ERM,FPR,FCH,DIFMAX,GTG,PTG,
     $               TSTEP,IST(NP),NE,ND,NI,NB,NV,IMPBND,IT,NSURF2,IGFL,
     $               IVFL,IGAGE,IVAGE,IDIF
      DIMENSION MEX(NP),THETA(*),THM(NP),THP(NP),THS(NP),THY(NP)
      EQUIVALENCE (THM(1),THS(1))
C
C--INITIALIZE
C
      DO 10 I=1,NT
10    MEX(I) = 0
C
C--EACH ITERATION BEGINS HERE
C
20    DO 30 I=1,NT
30    THPR(I) = THETA(I)
      FPR = F
C
C--INITIALIZE FOR THIS ITERATION
C
      IMPBND = 0
      DIFMAX = 0.D0
C
C--LOOP THROUGH INDEPENDENT PARAMETERS THAT ARE STILL ALLOWED TO VARY
C
      DO 430 I=1,NT
      ISTI = IST(I)
      IF (ISTI .GT. 2) GO TO 430
C
C--INITIALIZE WORKING VALUES FOR THIS PARAMETER
C
      IFIX = 0
      FY = F
      THI = THETA(I)
      ATHI = DABS(THI)
      SI = STP(I)
      THMAX = THU(I)
      THMIN = THL(I)
C
C--FIRST SELECT 3 APPROPRIATE TRIAL VALUES
C
C--CHECK FOR CLOSENESS TO A BOUND
C
      CALL BNDCHK(THI,THMAX,LEX)
      IF (LEX .LE. 0) GO TO 40
      IF (SI .GT. EFN(ATHI,EPSD)) GO TO 80
      THIB = THMAX
      GO TO 50
40    CALL BNDCHK(THI,THMIN,LEX)
      IF (LEX .LE. 0) GO TO 150
      IF (SI .GT. EFN(ATHI,EPSD)) GO TO 100
      THIB = THMIN
C
C--FIX THIS PARAMETER FOR THE REST OF BASIC ITERATION PROCESS
C
50    DO 60 II=1,NT
60    THY(II) = THETA(II)
      THY(I) = THIB
      CALL FUN(THY,FY,NFE,LEX)
      IF (LEX .GT. 0 .OR. FY .LT. F) GO TO 70
      IST(I) = ISTI + 4
      IF (IOUT .GT. 0) WRITE (IOUT,61) I,THIB
61    FORMAT ('0PARAMETER',I3,' IS TEMPORARILY FIXED AT BOUND',G17.8)
      IF (IDET .GT. 0 .AND. IDET .NE. IOUT) WRITE (IDET,61) I,THIB
      GO TO 400
C
70    IST(I) = ISTI + 6
      IF (IOUT .GT. 0) WRITE (IOUT,71) I,THIB
71    FORMAT ('0PARAMETER',I3,' IS TEMPORARILY FIXED NEAR BOUND',G17.8)
      IF (IDET .GT. 0 .AND. IDET .NE. IOUT) WRITE (IDET,71) I,THIB
      GO TO 430
C
C--CLOSE TO UPPER BOUND
C
80    LRET = 3
      THIP = THMAX
C
C--COME BACK TO THIS POINT (FOR LRET = 3) IF HAD TO DECREASE SI
C
90    DBTHI = DFN(DABS(THMAX),SI)
      THIM = THIP - DBTHI
      GO TO 120
C
C--CLOSE TO LOWER BOUND
C
100   LRET = 2
      THIM = THMIN
C
C--COME BACK TO THIS POINT (FOR LRET = 2) IF HAD TO DECREASE SI
C
110   DBTHI = DFN(DABS(THMIN),SI)
      THIP = THIM + DBTHI
C
C--TWO CLOSE-TO-BOUND CASES JOIN AT THIS POINT
C
120   THI = 0.5D0*(THIP + THIM)
      ATHI = DABS(THI)
      DTHI = 0.5D0*DBTHI
      SI = DFNINV(ATHI,DTHI)
      EI8 = EFN(ATHI,EPSD)/8.D0
C
      DO 130 II=1,NT
130   THY(II) = THETA(II)
      THY(I) = THI
      CALL FUN(THY,FY,NFE,LEX)
      IF (LEX .GT. 0) GO TO 140
      DIFMAX = DMAX1(DIFMAX,DABS(FY-FPR))
      GO TO 200
C
140   IMPBND = 1
      SI = 0.5D0*SI
      IF (SI .GE. EI8) GO TO (110,90), LRET-1
      IFIX = 1
      GO TO 420
C
C--NOT CLOSE TO EITHER BOUND
C
150   LRET = 1
      EI8 = EFN(ATHI,EPSD)/8.D0
C
C--INCREASE OR DECREASE SI ACCORDING TO RESULT OF PREVIOUS ITERATION,
C--IF ANY
C
      IF (MEX(I)) 160,180,170
C
160   SI = 0.5D0*SI
      IF (SI .GE. EI8) GO TO 180
C
C--SI HAS NOW BECOME SMALL IN NORMAL ITERATION PROCESS (NOT DUE TO
C--PROBLEMS), SO GO AHEAD AND USE IT BEFORE FIXING PARAMETER
C
      IFIX = 1
      GO TO 180
C
170   SI = DMIN1(SI+SI,0.5D0)
C
180   NDECRP = 0
      NDECRM = 0
C
C--COME BACK TO THIS POINT (FOR LRET = 1) IF HAD TO DECREASE SI
C
190   DTHI = DFN(ATHI,SI)
      THIP = THI + DTHI
      THIM = THI - DTHI
C
C--CLOSE-TO-BOUND CASES JOIN NORMAL CASE AT THIS POINT
C
C--CHECK THAT ALL TRIAL VALUES ARE IN BOUNDS
C
200   IF (THIM .LT. THMIN .OR. THIP .GT. THMAX) GO TO 260
C
C--GET FUNCTION VALUES FOR UPPER AND LOWER TRIAL VALUES
C
      DO 210 II=1,NT
210   THP(II) = THETA(II)
      THP(I) = THIP
      CALL FUN(THP,FP,NFE,LEX)
      IF (LEX .GT. 0) GO TO 220
      DIFMAX = DMAX1(DIFMAX,DABS(FP-FPR))
      IF (LRET .LE. 1 .AND. FP .GT. FY) GO TO 280
      GO TO 230
C
220   IMPBND = 1
      IF (LRET .GT. 1) GO TO 260
      NDECRP = NDECRP + 1
      IF (NDECRP .LE. 3) GO TO 260
      THMAX = THI
      IF (IDET .LE. 0) GO TO 80
      WRITE (IDET,221) I,THI,SI
221   FORMAT ('0WHEN PARAMETER',I3,' =',G17.8,' AND STEPSIZE FACTOR =',
     $        G17.8)
      WRITE (IDET,222)
222   FORMAT (' LOWER TRIAL VALUES ONLY WERE USED IN THIS ITERATION ',
     $        'BECAUSE UPPER TRIAL VALUE MADE FUNCTION UNDEFINED')
      GO TO 80
C
230   DO 240 II=1,NT
240   THM(II) = THETA(II)
      THM(I) = THIM
      CALL FUN(THM,FM,NFE,LEX)
      IF (LEX .GT. 0) GO TO 250
      DIFMAX = DMAX1(DIFMAX,DABS(FM-FPR))
      GO TO 270
C
250   IMPBND = 1
      IF (LRET .GT. 1) GO TO 260
      NDECRM = NDECRM + 1
      IF (NDECRM .LE. 3) GO TO 260
      THMIN = THI
      IF (IDET .LE. 0) GO TO 100
      WRITE (IDET,221) I,THI,SI
      WRITE (IDET,251)
251   FORMAT (' UPPER TRIAL VALUES ONLY WERE USED IN THIS ITERATION ',
     $        'BECAUSE LOWER TRIAL VALUE MADE FUNCTION UNDEFINED')
      GO TO 100
C
C--REDUCE SI AND TRY AGAIN
C
260   SI = 0.5D0*SI
      IF (SI .GE. EI8) GO TO (190,110,90), LRET
      IFIX = 1
      GO TO 390
C
C--HAVE THREE TRIAL VALUES AND CORRESPONDING FUNCTION VALUES;
C--FIND BEST ESTIMATES
C
270   IF (FY .GE. FP .AND. FY .GE. FM) GO TO 320
C
C--EITHER THIP OR THIM IS BEST
C
      IF (FM .GT. FP) GO TO 290
C
C--THIP IS BEST
C
      IF (FP .GE. F) GO TO 280
      MEX(I) = -1
      GO TO 420
280   MEX(I) = 1
      F = FP
      GO TO 370
C
C--THIM IS BEST
C
290   IF (FM .GE. F) GO TO 300
      MEX(I) = -1
      GO TO 420
300   MEX(I) = 1
      F = FM
      DO 310 II=1,NT
310   THETA(II) = THM(II)
      GO TO 420
C
C--THI IS BEST (OR AS GOOD)
C
320   MEX(I) = -1
      DEN = 2.D0*(FM + FP - FY - FY)
      IF (DEN .EQ. 0.D0) GO TO 390
C
C--TRY PARABOLIC APPROXIMATION TO GET A BETTER ESTIMATE
C
C--(USE ARRAY THP ALREADY PARTLY PREPARED)
C
      THIC = THI - ((FP - FM)*DTHI)/DEN
      THP(I) = THIC
      CALL FUN(THP,FC,NFE,LEX)
      IF (LEX .LE. 0) GO TO 330
      IMPBND = 1
      GO TO 350
330   DIFMAX = DMAX1(DIFMAX,DABS(FC-FPR))
      IF (FC - FY) 350,340,360
C
C--THIC EQUALLY GOOD; FIX PARAMETER
C
340   IFIX = 1
      GO TO 390
C
C--THI IS BETTER; RETRY WITH SMALLER STEPSIZE
C
350   DTHI = DMIN1(0.5D0*SI,DABS(THI-THIC))
      SI = DFNINV(ATHI,DTHI)
      IF (SI .LT. 8.D0*EI8) GO TO 390
      GO TO 190
C
C--THIC IS BETTER
C
360   IF (F .GT. FC) GO TO 420
      F = FC
370   DO 380 II=1,NT
380   THETA(II) = THP(II)
      GO TO 420
C
C--CHOOSE BETTER OF THI, THETA(I) (DIFFERENT ONLY IF LRET > 1)
C
390   IF ((LRET .EQ. 1) .OR. (F .GT. FY)) GO TO 420
C
C--SET PARAMETER TO THI
C
400   F = FY
      DO 410 II=1,NT
410   THETA(II) = THY(II)
C
C  SAVE CURRENT STEPSIZE FACTOR
C
420   STP(I) = SI
C
C--FIX PARAMETER IF INDICATED
C
      IF (IFIX .LE. 0) GO TO 430
      IST(I) = ISTI + 8
      IF (IOUT .GT. 0) WRITE (IOUT,421) I
421   FORMAT ('0PARAMETER',I3,' IS TEMPORARILY FIXED')
      IF (IDET .GT. 0 .AND. IDET .NE. IOUT) WRITE (IDET,421) I
C
C--END OF LOOP
C
430   CONTINUE
C
C--FINISH UP THIS ITERATION
C
      CALL ENDIT(THETA,F)
      DIFMAX = DMAX1(DIFMAX,FCH)
C
C--WRITE OUT DETAILS OF THIS ITERATION IF DESIRED
C
      IF (IDET .GT. 0) CALL LITD(THETA,F,NFE)
C
C--CHECK FOR CONVERGENCE
C
      CALL BCNVCH(THETA,LEX)
      GO TO (440,500,500,540), LEX+1
C
C--DO "SUPPLEMENTARY ITERATION PROCESS" BEFORE DOING ANOTHER 
C--BASIC ITERATION
C
C--INITIALIZE
C
440   DO 450 I=1,NT
450   THS(I) = THETA(I)
      N = 1
      TPN = 2.D0
C
C--GO FARTHER IN SAME DIRECTION
C
460   UMTPN = 1.D0 - TPN
      DO 470 I=1,NT
      IF (IST(I) .GT. 2) THEN
         THY(I) = THS(I)
      ELSE
         THY(I) = TPN*THS(I) + UMTPN*THPR(I)
         IF (THY(I) .LT. THL(I) .OR. THY(I) .GT. THU(I)) GO TO 490
      END IF
470   CONTINUE
      CALL FUN(THY,FY,NFE,LEX)
      IF (LEX .GT. 0 .OR. FY .LE. F) GO TO 490
C
C--THY CONTAINS IMPROVED ESTIMATES
C
      DO 480 I=1,NT
480   THETA(I) = THY(I)
      F = FY
C
      N = N + 1
      TPN = TPN + TPN
      GO TO 460
C
C--NO MORE IMPROVEMENT
C
490   IF (N .LE. 1) GO TO 20
C
      N = N - 1
      IF (IDET .LE. 0) GO TO 20
      WRITE (IDET,491) N,F
491   FORMAT (' AFTER THIS ITERATION,',I3,
     $        ' IMPROVED VALUES FOUND IN SAME DIRECTION.  NEW FUNCTION',
     $        ' VALUE',E18.10/
     $        ' ',32('----'))
      GO TO 20
C
C--HAVE CONVERGED; 
C--BEFORE RETURNING, UNFIX ANY TEMPORARILY FIXED PARAMETERS
C
500   DO 530 I=1,NT
      GO TO (530,530,530,530,510,520,510,520,510,520), IST(I)
510   IST(I) = 1
      GO TO 530
520   IST(I) = 2
530   CONTINUE
C
C--HAVE CONVERGED OR REACHED MAXIMUM # ITERATIONS; EXIT
C
540   IFL = LEX
      RETURN
C
      END
      SUBROUTINE NSRCH(FUN,THETA,F,NFE,DTH,IFL)
C
C--TRY 2*(NI) "NEIGHBORING" PARAMETER SETS TO FIND A BETTER ONE
C
C--RETURNS FLAG IFL:
C--   0:  SIGNIFICANT CHANGE; CONTINUE ITERATING
C--   1:  NEGLIGIBLE OR NO CHANGE
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      PARAMETER (NP=45,NPV=45)
      EXTERNAL DFN,EFN,ENDIT,FUN,LITD
      COMMON /MAXFOP/ IOUT,IDET,LPRT
      COMMON /MAXF1/ THIN(NP),THL(NP),THU(NP),STPIN(NP),EPSD,YOTA,EPST,
     $               EPSC1,EPSC2,EPSC3,ISTIN(NP),NT,MAXIT,METHOD,IXVC,
     $               IHIT
      COMMON /MAXF2/ THPR(NP),CTH(NP),STP(NP),G(NPV),H(NPV,NPV),
     $               V(NPV,NPV),AV(NP,NP),STDE(NP),ULT(NPV,NPV),
     $               DIAG(NPV),PDIR(NPV),ERM,FPR,FCH,DIFMAX,GTG,PTG,
     $               TSTEP,IST(NP),NE,ND,NI,NB,NV,IMPBND,IT,NSURF2,IGFL,
     $               IVFL,IGAGE,IVAGE,IDIF
      DIMENSION THETA(*),DTH(*),THS(NP),THY(NP)
C
C--SAVE INCOMING ESTIMATES AND ESTABLISH NEW STEPSIZES
C
      DO 10 I=1,NT
      THS(I) = THETA(I)
      THY(I) = THETA(I)
      ATHI = DABS(THY(I))
      SI = EFN(ATHI,EPSD)
      DTH(I) = DFN(ATHI,SI)
10    STP(I) = SI
      FS = F
C
C--INITIALIZE BOUNDARY FLAG
C
      IMPBND = 0
C
C--LOOP THROUGH PARAMETERS TO CHECK NEIGHBORING VALUES
C
      DO 80 I=1,NT
      IF (IST(I) .GT. 2) GO TO 80
      THI = THY(I)
      THIY = THI + DTH(I)
      IF (THIY .GT. THU(I)) GO TO 40
      THY(I) = THIY
      CALL FUN(THY,FY,NFE,LEX)
      IF (LEX .LE. 0) GO TO 20
      IMPBND = 1
      GO TO 40
20    IF (FY .LE. F) GO TO 40
      DO 30 II=1,NT
30    THETA(II) = THY(II)
      F = FY
40    THIY = THI - DTH(I)
      IF (THIY .LT. THL(I)) GO TO 70
      THY(I) = THIY
      CALL FUN(THY,FY,NFE,LEX)
      IF (LEX .LE. 0) GO TO 50
      IMPBND = 1
      GO TO 70
50    IF (FY .LE. F) GO TO 70
      DO 60 II=1,NT
60    THETA(II) = THY(II)
      F = FY
70    THY(I) = THETA(I)
80    CONTINUE
C
C--IF ANY IMPROVEMENT HAS OCCURRED, CONSIDER THIS ANOTHER ITERATION
C
      IF (F .GT. FS) GO TO 90
      IF (IOUT .GT. 0) WRITE (IOUT,81)
81    FORMAT ('0NO IMPROVEMENT IN 2(NI)-TRIAL SEARCH')
      IFL = 1
      RETURN
C
90    DO 100 I=1,NT
100   THPR(I) = THS(I)
      FPR = FS
      CALL ENDIT(THETA,F)
      DIFMAX = FCH
C
C--PRINT ITERATION DETAILS IF DESIRED
C
      IF (IOUT .GT. 0 .AND. IOUT .NE. IDET) WRITE (IOUT,101)
101   FORMAT ('0IMPROVED VALUES(S) FOUND IN 2(NI)-TRIAL SEARCH')
      IF (IDET .LE. 0) GO TO 110
      WRITE (IDET,102)
102   FORMAT ('02(NI)-TRIAL ITERATION:')
      CALL LITD(THETA,F,NFE)
C
C--CHECK FOR CONVERGENCE
C
110   IF (FCH .GT. EPSC1*EPSC1 .AND. FCH .GT. EPSC3) GO TO 120
      IF (IOUT .GT. 0) WRITE (IOUT,111) FCH
111   FORMAT ('0NEGLIGIBLE CHANGE IN FUNCTION VALUE:',E20.10,
     $        ' IN 2(NI)-TRIAL SEARCH')
      IFL = 1
      RETURN
C
C--SIGNIFICANT CHANGE
C
120   DO 130 I=1,NT
130   STP(I) = 2.D0*STP(I)
      IFL = 0
      RETURN
C
      END
      SUBROUTINE PSRCH(FUN,THETA,F,NFE,DTH,IFL)
C
C--SEARCH 2**(NI) NEIGHBORING PARAMETER SETS FOR BETTER ESTIMATES
C
C--RETURNS FLAG IFL:
C--   0:  SIGNIFICANT CHANGE; CONTINUE ITERATING
C--   1:  NEGLIGIBLE OR NO CHANGE
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      PARAMETER (NP=45,NPV=45)
      EXTERNAL COMB,ENDIT,FUN,LITD
      COMMON /MAXFOP/ IOUT,IDET,LPRT
      COMMON /MAXF1/ THIN(NP),THL(NP),THU(NP),STPIN(NP),EPSD,YOTA,EPST,
     $               EPSC1,EPSC2,EPSC3,ISTIN(NP),NT,MAXIT,METHOD,IXVC,
     $               IHIT
      COMMON /MAXF2/ THPR(NP),CTH(NP),STP(NP),G(NPV),H(NPV,NPV),
     $               V(NPV,NPV),AV(NP,NP),STDE(NP),ULT(NPV,NPV),
     $               DIAG(NPV),PDIR(NPV),ERM,FPR,FCH,DIFMAX,GTG,PTG,
     $               TSTEP,IST(NP),NE,ND,NI,NB,NV,IMPBND,IT,NSURF2,IGFL,
     $               IVFL,IGAGE,IVAGE,IDIF
      DIMENSION THETA(*),DTH(*),THS(NP),THY(NP),LIST(NPV+1)
C
C--SAVE INCOMING VALUES
C
      DO 10 I=1,NT
10    THS(I) = THETA(I)
      FS = F
C
C--INITIALIZE BOUNDARY FLAG
C
      IMPBND = 0
C
C--CONSIDER TRIAL PARAMETER SETS WITH NPLUS INDEPENDENT PARAMETERS
C--CHANGED IN + DIRECTION (AND OTHERS IN - DIRECTION),
C--FOR NPLUS = 0 TO NI
C
C--NPLUS = 0 CASE:  NO PARAMETERS TO CHANGE IN + DIRECTION
C
      NPLUS = 0
      LIST(1) = 0
C
C--SET UP TRIAL PARAMETER SET WITH NPLUS PARAMETERS CHANGING IN
C-- + DIRECTION (WHICH ONES ARE INDICATED IN LIST ARRAY)
C
20    NP1 = 1
      K = 0
      DO 40 I=1,NT
      IF (IST(I) .LE. 2) GO TO 30
      THY(I) = THS(I)
      GO TO 40
30    K = K + 1
      IF (K .EQ. LIST(NP1)) THEN
         THY(I) = THS(I) + DTH(I)
         NP1 = NP1 + 1
      ELSE
         THY(I) = THS(I) - DTH(I)
      END IF
      IF (THY(I) .GT. THU(I) .OR. THY(I) .LT. THL(I)) GO TO 70
40    CONTINUE
C
C--CHECK OUT THIS TRIAL SET
C
      CALL FUN(THY,FY,NFE,LEX)
      IF (LEX .LE. 0) GO TO 50
      IMPBND = 1
      GO TO 70
50    IF (FY .LE. F) GO TO 70
C
C--HAVE AN IMPROVEMENT
C
      DO 60 I=1,NT
60    THETA(I) = THY(I)
      F = FY
C
C--FINISHED WITH THIS TRIAL SET; GET NEXT ONE
C
70    IF (NPLUS .GT. 0) GO TO 90
C
C--DONE WITH THIS NPLUS; INCREASE # PARAMETERS TO CHANGE IN + DIRECTION
C
80    NPLUS = NPLUS + 1
      IF (NPLUS .GT. NI) GO TO 100
      NSW = 0
C
C--GET LIST OF NPLUS PARAMETERS TO CHANGE IN + DIRECTION
C
90    CALL COMB(NI,NPLUS,NSW,LIST)
      IF ( NSW .GT. 1) GO TO 80
      GO TO 20
C
C--HAVE TRIED EVERY DIRECTION OF CHANGE; ANY IMPROVEMENT?
C
100   IF (F .GT. FS) GO TO 110
C
      IF (IOUT .GT. 0) WRITE (IOUT,101)
101   FORMAT ('0NO IMPROVEMENT IN 2**(NI)-TRIAL SEARCH')
      IFL = 1
      RETURN
C
C--INCREMENT # TIMES 2**(NI)-TRIAL SEARCH MADE IMPROVEMENT
C
110   NSURF2 = NSURF2 + 1
C
C--TRY GOING FARTHER IN BEST DIRECTION
C
      DO 120 I=1,NT
      THIY = 2.D0*THETA(I) - THS(I)
      IF (IST(I) .GT. 2 .OR. THIY .LT. THL(I) .OR. THIY .GT. THU(I))
     $ THEN
         THY(I) = THETA(I)
      ELSE
         THY(I) = THIY
      END IF
120   CONTINUE
      CALL FUN(THY,FY,NFE,LEX)
      IF (LEX .LE. 0) GO TO 130
      IMPBND = 1
      GO TO 150
130   IF (FY .LE. F) GO TO 150
      DO 140 I=1,NT
140   THETA(I) = THY(I)
      F = FY
C
C--COMPLETE THIS "ITERATION"
C
150   DO 160 I=1,NT
160   THPR(I) = THS(I)
      FPR = FS
      CALL ENDIT(THETA,F)
      DIFMAX = FCH
C
C--PRINT ITERATION DETAILS IF DESIRED
C
      IF (IOUT .GT. 0 .AND. IOUT .NE. IDET) WRITE (IOUT,161)
161   FORMAT ('0IMPROVED VALUE(S) FOUND IN 2**(NI)-TRIAL SEARCH')
      IF (IDET .LE. 0) GO TO 170
      WRITE (IDET,162)
162   FORMAT ('02**(NI)-TRIAL ITERATION:')
      CALL LITD(THETA,F,NFE)
C
C--CHECK FOR CONVERGENCE
C
170   IF (FCH .GT. EPSC1*EPSC1 .AND. FCH .GT. EPSC3) GO TO 180
      IF (IOUT .GT. 0) WRITE (IOUT,171) FCH
171   FORMAT ('0NEGLIGIBLE CHANGE IN FUNCTION VALUE:',E20.10,
     $        ' IN 2**(NI)-TRIAL SEARCH')
      IFL = 1
      RETURN
C
C--SIGNIFICANT CHANGE
C
180   DO 190 I=1,NT
190   STP(I) = EPSD
      IFL = 0
      RETURN
C
      END
      SUBROUTINE COMB(NTOTAL,NCHOOS,NSW,LIST)
C
C--CHOOSE NCHOOS ELEMENTS OUT OF NTOTAL; INDICATE WHICH ONES IN LIST 
C--(GENERATES COMBINATIONS TO BE USED IN THE 2**(NI)-TRIAL SEARCH:
C--INDICATE WHICH PARAMETERS TO CHANGE IN + DIRECTION)
C
      PARAMETER (NPV=45)
      DIMENSION LIST(*),MAXLST(NPV)
      SAVE MAXLST,KV
C
      IF (NSW .GT. 0) GO TO 20
C
C--START WITH A NEW NCHOOS
C
      NOTCH = NTOTAL - NCHOOS
      DO 10 K=1,NCHOOS
10    MAXLST(K) = NOTCH + K
      NSW = 1
      LIST(NCHOOS+1) = 0
      KV = 1
      LIST(1) = 1
      GO TO 50
C
C--IN PROGRESS WITH THIS NCHOOS
C
20    LISTKV = LIST(KV) + 1
      LIST(KV) = LISTKV
      IF (LISTKV .LE. MAXLST(KV)) RETURN
30    KV = KV - 1
      IF (KV .GT. 0) GO TO 40
      NSW = 2
      RETURN
40    LIST(KV) = LIST(KV) + 1
      IF (LIST(KV) .GT. MAXLST(KV)) GO TO 30
C
C--HAVE ESTABLISHED KV'TH CHOSEN ELEMENT; FILL IN REST OF LIST WITH 
C--LOWEST POSSIBLE VALUES
C
50    IF (KV .GE. NCHOOS) GO TO 70
      DO 60 K=KV+1,NCHOOS
60    LIST(K) = LIST(K-1) + 1
70    KV = NCHOOS
      RETURN
C
      END
      SUBROUTINE NRSTEP(FUN,THETA,F,NFE,IFL)
C
C--PERFORM ONE NEWTON-RAPHSON ITERATION
C
C--RETURNS FLAG IFL:
C--   0:  CONTINUE ITERATING
C--   1:  CONVERGED BY CRITERION 1 (IMPLIED TEST)
C--   2:  CONVERGED BY CRITERION 2:  PTG <= EPSC2
C--   3:  CONVERGED BY NEGLIGIBLE FUNCTION CHANGE (CRITERION 3)
C--   4:  REACHED MAXIMUM # ITERATIONS
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      PARAMETER (NP=45,NPV=45)
      EXTERNAL ENDIT,FUN,LITV,MMULT,VCNVCH
      COMMON /MAXFOP/ IOUT,IDET,LPRT
      COMMON /MAXF1/ THIN(NP),THL(NP),THU(NP),STPIN(NP),EPSD,YOTA,EPST,
     $               EPSC1,EPSC2,EPSC3,ISTIN(NP),NT,MAXIT,METHOD,IXVC,
     $               IHIT
      COMMON /MAXF2/ THPR(NP),CTH(NP),STP(NP),G(NPV),H(NPV,NPV),
     $               V(NPV,NPV),AV(NP,NP),STDE(NP),ULT(NPV,NPV),
     $               DIAG(NPV),PDIR(NPV),ERM,FPR,FCH,DIFMAX,GTG,PTG,
     $               TSTEP,IST(NP),NE,ND,NI,NB,NV,IMPBND,IT,NSURF2,IGFL,
     $               IVFL,IGAGE,IVAGE,IDIF
      DIMENSION THETA(*),THS(NP)
C
C--SAVE INCOMING VALUES
C
      DO 10 I=1,NT
10    THS(I) = THETA(I)
      FS = F
C
C--COMPUTE DIRECTION OF CHANGE
C
      CALL MMULT(V,NPV,NV,NV,G,NPV,1,PDIR,NPV)
C
C--REDUCE AMOUNT OF CHANGE IF NECESSARY TO PRESERVE BOUNDS ON
C--INDEPENDENT PARAMETERS
C
      PTG = 0.D0
      TT = 1.D0
      L = 0
      DO 20 I=1,NT
      IF (IST(I) .GT. 2) GO TO 20
      L = L + 1
      PL = PDIR(L)
      IF (PL .EQ. 0.D0) THEN
         GO TO 20
      ELSE IF (PL .GT. 0.D0) THEN
         TT = DMIN1(TT,(THU(I)-THS(I))/PL)
13       IF (THS(I) + TT*PL .LE. THU(I)) GO TO 19
         TT = (1.D0 - YOTA)*TT
         GO TO 13
      ELSE 
         TT = DMIN1(TT,(THL(I)-THS(I))/PL)
18       IF (THS(I) + TT*PL .GE. THL(I)) GO TO 19
         TT = (1.D0 - YOTA)*TT
         GO TO 18
      END IF
19    PTG = PTG + PL*G(L)
20    CONTINUE
C
C--SEE IF PTG SMALL ENOUGH TO STOP
C
      IF (DABS(PTG) .GT. EPSC2) GO TO 30
      IF (IOUT .GT. 0) WRITE (IOUT,21) IT,PTG
21    FORMAT ('0CONVERGED BY CRITERION 2 AFTER ITERATION',I4,
     $        ':  NORMALIZED GRADIENT',E18.10,
     $        ' WITHIN SPECIFIED TOLERANCE')
      IFL = 2
      RETURN
C
C--INITIALIZE BOUNDARY FLAG
C
30    IMPBND = 0
C
C--COMPUTE NEW ESTIMATES
C
40    L = 0
      DO 50 I=1,NT
      IF (IST(I) .GT. 2) GO TO 50
      L = L + 1
      THETA(I) = THS(I) + TT*PDIR(L)
50    CONTINUE
C
C--GET FUNCTIONAL VALUE IF POSSIBLE
C
      CALL FUN(THETA,F,NFE,LEX)
      IF (LEX .LE. 0) GO TO 60
      IF (IDET .GT. 0) WRITE (IDET,51) IT,TT
51    FORMAT ('0AFTER ITERATION',I4,
     $        ', UNDEFINED FUNCTION WITH STEP SIZE',E18.10)
      IMPBND = 1
      GO TO 70
C
C--CHECK FOR DECREASING VALUE
C
60    IF (F .GE. FS) GO TO 80
      IF (IDET .GT. 0) WRITE (IDET,61) IT,TT
61    FORMAT ('0AFTER ITERATION',I4,
     $        ', DECREASING FUNCTION WITH STEP SIZE',E18.10)
C
C--RAN INTO TROUBLE; CUT DOWN STEP SIZE AND TRY AGAIN
C
70    TT = 0.5D0*TT
      GO TO 40
C
C--OK TO COMPLETE THIS ITERATION 
C
80    TSTEP = TT
      DO 90 I=1,NT
90    THPR(I) = THS(I)
      FPR = FS
      CALL ENDIT(THETA,F)
C
C--INCREMENT NUMBER OF ITERATIONS WITH THIS VARIANCE-COVARIANCE MATRIX
C--AND THIS GRADIENT VECTOR
C
      IVAGE = IVAGE + 1
      IGAGE = IGAGE + 1
C
C--WRITE OUT DETAILS OF THIS ITERATION IF DESIRED
C
      IF (IDET .GT. 0) CALL LITV(THETA,F,NFE)
C
C--CHECK FOR CONVERGENCE
C
      CALL VCNVCH(THETA,LEX)
C
C--SET FLAG AND RETURN
C
      IF (LEX .LE. 1) THEN
         IFL = LEX
      ELSE
         IFL = LEX + 1
      END IF
      RETURN
C
      END
      SUBROUTINE BINIT(FUN,DEPAR,THETA,F,NFE,IHESS)
C
C--OBTAIN INITIAL B MATRIX (APPROXIMATING OPPOSITE OF HESSIAN AT OPTIMAL
C--ESTIMATES) IN FACTORIZED FORM B = ULT*DIAG*ULT' 
C--(NOTE:  OPPOSITES ARE NECESSARY SINCE UPDATING PROCEDURE REQUIRES
C--POSITIVE DEFINITE B)
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      PARAMETER (NP=45,NPV=45)
      EXTERNAL FUN,DEPAR
      EXTERNAL DERIV2
      COMMON /MAXFOP/ IOUT,IDET,LPRT
      COMMON /MAXF1/ THIN(NP),THL(NP),THU(NP),STPIN(NP),EPSD,YOTA,EPST,
     $               EPSC1,EPSC2,EPSC3,ISTIN(NP),NT,MAXIT,METHOD,IXVC,
     $               IHIT
      COMMON /MAXF2/ THPR(NP),CTH(NP),STP(NP),G(NPV),H(NPV,NPV),
     $               V(NPV,NPV),AV(NP,NP),STDE(NP),ULT(NPV,NPV),
     $               DIAG(NPV),PDIR(NPV),ERM,FPR,FCH,DIFMAX,GTG,PTG,
     $               TSTEP,IST(NP),NE,ND,NI,NB,NV,IMPBND,IT,NSURF2,IGFL,
     $               IVFL,IGAGE,IVAGE,IDIF
      DIMENSION THETA(*),B(NPV,NPV)
C
C--SELECT TYPE OF INITIAL MATRIX TO BE USED
C
      IF (IHESS .LE. 0) GO TO 50
C
C--COMPUTE MATRIX OF SECOND PARTIAL DERIVATIVES FOR INITIAL ESTIMATES
C--OF PARAMETERS
C
      IF (IOUT .GT. 0) WRITE (IOUT,1)
1     FORMAT ('0COMPUTING INITIAL B FROM HESSIAN AT INITIAL ESTIMATES')
      CALL DERIV2(FUN,DEPAR,THETA,F,NFE,IHIT,LEX)
      IF (LEX .GT. 1) GO TO 50
C
C--INITIALIZE B TO -H
C
      DO 10 L1=1,NV
      DO 10 L2=1,NV
10    B(L1,L2) = -H(L1,L2)
C
C--DO CHOLESKY FACTORIZATION
C
      DO 40 L=1,NV
      BL = B(L,L)
      IF (BL .GT. 0.D0) GO TO 20
      IF (IOUT .GT. 0) WRITE (IOUT,11)
11    FORMAT (' FACTORIZATION OF B MATRIX FAILED')
      GO TO 50
20    DIAG(L) = BL
      ULT(L,L) = 1.D0
      IF (L .GE. NV) GO TO 80
      DO 30 L1=L+1,NV
30    ULT(L1,L) = B(L1,L)/BL
      DO 40 L2=L+1,NV
      ULTL2L = ULT(L2,L)
      DO 40 L1=L2,NV
40    B(L1,L2) = B(L1,L2) - ULTL2L*ULT(L1,L)*BL
      GO TO 80
C
C--USE IDENTITY MATRIX
C
50    IF (IOUT .GT. 0) WRITE (IOUT,51)
51    FORMAT ('0USING IDENTITY FOR INITIAL B MATRIX')
C
      DO 70 L1=1,NV
      DO 60 L2=1,L1-1
60    ULT(L1,L2) = 0.D0
      ULT(L1,L1) = 1.D0
70    DIAG(L1) = 1.D0
C
80    IF (IOUT .GT. 0) WRITE (IOUT,81)
81    FORMAT (' ',32('----'))
C
      RETURN
C
      END
      SUBROUTINE BUPDT(GPR,LEX)
C
C--UPDATE MATRIX B = ULT*DIAG*ULT'
C
C--RETURNS FLAG LEX:
C--   0:  UPDATE SUCCESSFUL
C--   1:  UPDATE FAILED:  LOST ALL SIGNIFICANT DIGITS IN OPTIMAL 
C--       CONDITIONING
C
C--USING PREVIOUS GRADIENT (BEFORE ITERATION IT) IN GPR AND CURRENT
C--GRADIENT (AFTER ITERATION IT) IN G
C
C***********************************************************************
C* NOTE THAT G, GPR, Y ARE DEFINED OPPOSITE TO QUANTITIES DESCRIBED IN *
C* GEMINI DOCUMENTATION, AND FORMULAS ARE CHANGED ACCORDINGLY          *
C***********************************************************************
C* NOTE ALSO THAT VARIABLES TAU1, TAU2, AND PHL REFER TO QUANTITIES    *
C* THET1, THET2, AND THL IN GEMINI; THESE DO NOT REFER TO THE PARAMETER*
C* ESTIMATE VECTOR THETA                                               *
C***********************************************************************
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      PARAMETER (NP=45,NPV=45)
      DOUBLE PRECISION NU,MUL,LAMBL,LAMBL2
      COMMON /MAXFOP/ IOUT,IDET,LPRT
      COMMON /MAXF2/ THPR(NP),CTH(NP),STP(NP),G(NPV),H(NPV,NPV),
     $               V(NPV,NPV),AV(NP,NP),STDE(NP),ULT(NPV,NPV),
     $               DIAG(NPV),PDIR(NPV),ERM,FPR,FCH,DIFMAX,GTG,PTG,
     $               TSTEP,IST(NP),NE,ND,NI,NB,NV,IMPBND,IT,NSURF2,IGFL,
     $               IVFL,IGAGE,IVAGE,IDIF
      DIMENSION GPR(*),Y(NPV),W(NPV),Z(NPV),WTIL(NPV),ZTIL(NPV),
     $          WTPLP1(NPV),ZTPLP1(NPV),WPL(NPV),ZPL(NPV),
     $          WPLP1(NPV),ZPLP1(NPV),DP(NPV),S(NPV)
C
C--CHECK THAT DIRECTION OF CHANGE IS ONE OF DECREASING GRADIENT;
C--IF NOT, DON'T UPDATE
C
      YTP = 0.D0
      DO 10 L=1,NV
      Y(L) = G(L) - GPR(L)
10    YTP = YTP + Y(L)*PDIR(L)
      IF (YTP .GE. 0.D0) GO TO 260
C
      IF (NV .GT. 1) GO TO 20
C
C--FOR NV = 1:
C
      DIAG(1) = -Y(1)*DIAG(1)/(TSTEP*GPR(1))
      GO TO 260
C
C--FOR NV > 1 (FORMULA NUMBERS REFER TO GEMINI DOCUMENTATION):
C
C-----------------------------------------------------------------------
C
C--GOLDFARB METHOD FOR VARIABLE METRIC B-MATRIX UPDATING;
C--UPDATE OF FACTORIZED B-MATRIX BY RANK TWO MODIFICATION
C--IN REAL PRODUCT FORM WITH FORMULA (3.25) OR (3.28) OF GEMINI 
C--DOCUMENTATION, DEPENDING ON WHETHER NONE OR AT LEAST ONE 
C--LAMBA(L)**2 IS GREATER THAN 10.
C--OPTIMAL CONDITIONING OF DAVIDON ALSO INCORPORATED.
C
C-----------------------------------------------------------------------
C--SOLVE (3.20) AND (3.21) FOR WTIL AND ZTIL
C
20    WTIL(1) = GPR(1)
      ZTIL(1) = -Y(1)
      DO 30 L=2,NV
      WTIL(L) = GPR(L)
      ZTIL(L) = -Y(L)
      DO 30 LL=1,L-1
      WTIL(L) = WTIL(L) - ULT(L,LL)*WTIL(LL)
30    ZTIL(L) = ZTIL(L) - ULT(L,LL)*ZTIL(LL)
C
C-----------------------------------------------------------------------
C--GET SCALARS B, C AND D, DENOTED SB, SC, SD HERE (3.27)
C
      SB = 0.D0
      SC = 0.D0
      SD = 0.D0
      DO 40 L=1,NV
      SB = SB + TSTEP*ZTIL(L)*WTIL(L)/DIAG(L)
      SC = SC + TSTEP*TSTEP*WTIL(L)*WTIL(L)/DIAG(L)
40    SD = SD + ZTIL(L)*ZTIL(L)/DIAG(L)
C
C-----------------------------------------------------------------------
C--OPTIMAL CONDITIONING OF UPDATE, ACCORDING TO THEOREM 3 OF DAVIDON 
C--(1975) -- MAY BE DISABLED BY "GO TO 60"
C---------------------
C
C--PREVENTING UNDERFLOW:
C--IF ANY OF SB, SC, SD IS SMALLER THAN 1.D-10, USE SR1-UPDATE FOR B
C
      FBCD = DMIN1(SB,SC,SD)
      IF (FBCD .LE. 1.D-10) GO TO 50
      FBCD = 2.D0*SC*(SD/SB)/(SC + SD)
      IF (FBCD .LT. 1.D0) GO TO 50
C
C---------------------
C--RANK TWO UPDATE
C
C--GET ALPHA
C
      AA = SB/SC - 2.D0*(SD/SB) + SD/SC
      BB = SB/SC - 1.D0
      CC = 1.D0 - SB/SD
      DEL2 = BB*BB - AA*CC
C
C--IF DISCRIMINANT NEGATIVE OR EQUALS ZERO, TAKE ALPHA EQUAL TO ZERO
C
      IF (DEL2 .LE. 1.D-8) GO TO 60
C
C----------------
C
      DEL1 = DSQRT(DEL2)
      ALPH1 = (-BB + DEL1)/AA
      ALPH2 = (-BB - DEL1)/AA
C
C--FOR NOW, ALWAYS CHOOSE SOLUTION OF SMALLEST MODULUS
C
      IF (DABS(ALPH1) .LE. DABS(ALPH2)) THEN
         ALPHA = ALPH1
      ELSE
         ALPHA = ALPH2
      END IF
C
C--IF ALPHA VERY SMALL, ALPHA TAKEN EQUAL TO ZERO 
C
      IF (DABS(ALPHA) .LE. 1.D-5) GO TO 60
C
C--GET SA
C
      SA = (ALPHA + 1.D0)*(ALPHA + 1.D0) + SC/SB 
     $     - ALPHA*ALPHA*(SC/SB)*(SD/SB) - 1.D0 + ALPHA*ALPHA*(SD/SB)
      IF (SA .LE. 0.D0) THEN
         SA = 0.D0
      ELSE
         SA = 1.D0/(DSQRT(SA)*SB)
      END IF
C
C--GET TAU1 AND TAU FOR NON-TRIVIAL ALPHA
C
      RDIV = 1.D0/(ALPHA*ALPHA*SD + 2.D0*ALPHA*SB + SC)
      TAU1 = -(SA*(ALPHA*(ALPHA*SD + SB)) + 1.D0)*RDIV
      TAU2 = SA + (ALPHA*SA*(SC + ALPHA*SB) - ALPHA)*RDIV
      GO TO 70
C
C---------------------
C--SR1 (SYMMETRIC RANK-ONE) UPDATE
C
50    ALPHA = -1.D0
      SBC = SB - SC
      IF (SBC .EQ. 0.D0) GO TO 290
      SDB = SD - SB
      IF (SDB .EQ. 0.D0) GO TO 290
      SDEN = DSQRT(DABS(SBC))*DSQRT(DABS(SDB))
      IF (SDEN .EQ. 0.D0) GO TO 290
      SA =1.D0/SDEN
      SDBC = SD - 2.D0*SB + SC
      IF (SDBC .EQ. 0.D0) GO TO 290
      TAU1 = -(SDB*SA + 1.D0)/SDBC
      TAU2 = SA + (SA*SBC + 1.D0)/SDBC
      GO TO 70
C
C---------------------
C--ALPHA ZERO:  DFP-UPDATE FOR B
C
60    ALPHA = 0.D0
      SA = 1.D0/(DSQRT(SB)*DSQRT(SC))
      TAU1 = -1.D0/SC
      TAU2 = SA
C
C-----------------------------------------------------------------------
C--START WITH SWITCH SET TO DO (3.25) TYPE UPDATE
C
70    ISWUP = 1
C
C--SAVE ULT LOWER TRIANGLE IN UPPER TRIANGLE OF ARRAY ULT, IN CASE A 
C--SWITCH TO (3.28) SHOULD BE REQUIRED
C
      DO 80 L=2,NV
      DO 80 LL=1,L-1
80    ULT(LL,L) = ULT(L,LL)
C
C--GET W AND Z AS GIVEN IN (3.22), (3.23)
C
      DO 90 L=1,NV
      W(L) = TSTEP*WTIL(L) + ALPHA*ZTIL(L)
90    Z(L) = TSTEP*TAU1*WTIL(L) + TAU2*ZTIL(L)
C
C-----------------------------------------------------------------------
C--READY TO APPLY GOLDFARB RECURRENCE 3 TO SOLVE CONCURRENTLY (3.25),
C--(3.24) BEING ALSO SOLVED SIMULTANEOUSLY
C--(OR (3.28) AND CORRESPONDING ANALOG OF (3.24))
C
C--GET S FIRST (P.802 (TOP) OF ?)
C
      S(NV) = 0.D0
      DO 100 L=NV,2,-1
100   S(L-1) = S(L) + W(L)*W(L)/DIAG(L)
C
C-----------------------------------------------------------------------
C--INITIALIZE NU, ETA
C
110   NU = 1.D0
      ETA = 0.D0
C
C-----------------------------------------------------------------------
C--INITIALIZE WTPLP1, ZTPLP1 OR WPLP1, ZPLP1
C
      IF (ISWUP .GT. 1) GO TO 130
      DO 120 L=1,NV
      WTPLP1(L) = GPR(L)
120   ZTPLP1(L) = -Y(L)
      GO TO 150
130   DO 140 L=1,NV
      WPLP1(L) = TSTEP*G(L) - ALPHA*Y(L)
140   ZPLP1(L) = TSTEP*TAU1*G(L) - TAU2*Y(L)
C
C-----------------------------------------------------------------------
C
150   DO 240 L=1,NV-1
C
C--RECURRENCE FORMULA FROM (3.24) OR ANALOG
C
      IF (ISWUP .GT. 1) GO TO 170
      DO 160 LL=L+1,NV
      WTPLP1(LL) = WTPLP1(LL) - WTIL(L)*ULT(LL,L)
160   ZTPLP1(LL) = ZTPLP1(LL) - ZTIL(L)*ULT(LL,L)
      GO TO 190
170   DO 180 LL=L+1,NV
      WPL(LL) = WPLP1(LL)
      ZPL(LL) = ZPLP1(LL)
      WPLP1(LL) = WPL(LL) - W(L)*ULT(LL,L)
180   ZPLP1(LL) = ZPL(LL) - Z(L)*ULT(LL,L)
C
C--RECURRENCE 3 (?) TO GET AL, BL, ETC...
C
190   AL = NU*Z(L) - ETA*W(L)
      PHL = 1.D0 + AL*W(L)/DIAG(L)
      LAMBL2 = PHL*PHL + AL*AL*S(L)/DIAG(L)
C
C--SWITCH TO (3.28) UPDATE IF ANY LAMBL2 GREATER THAN 4
C
      IF (ISWUP .LE. 1 .AND. LAMBL2 .GT. 4.D0) GO TO 270
C
C--COMPUTE L'TH ELEMENT OF D+ (NEW DIAG)
C
      DP(L) = DIAG(L)*LAMBL2
C
C--TAKES SIGN OF LAMBDA OPPOSITE TO THAT OF THETA
C
      LAMBL = DSQRT(LAMBL2)
      IF (PHL .GT. 0.D0) LAMBL = -LAMBL
C
      MUL = PHL - LAMBL
      BL = PHL*W(L) + AL*S(L)
C
C--NOTE:  GAMTL AND BETTL STAND FOR GAMMA TILDE AND BETA TILDE
C--RESPECTIVELY IN (3.26)
C
      GAMTL = BL*NU/(LAMBL2*DIAG(L))
      BETTL = (AL - BL*ETA)/(LAMBL2*DIAG(L))
C
C--UPDATE L'TH COLUMN OF ULT
C
      IF (ISWUP .GT. 1) GO TO 210
      DO 200 LL=L+1,NV
200   ULT(LL,L) = ULT(LL,L) + TSTEP*(BETTL + TAU1*GAMTL)*WTPLP1(LL) +
     $          (ALPHA*BETTL + TAU2*GAMTL)*ZTPLP1(LL)
      GO TO 230
210   DO 220 LL=L+1,NV
220   ULT(LL,L) = ULT(LL,L)/LAMBL2 + BETTL*WPL(LL) + GAMTL*ZPL(LL)
C
C--UPDATE NU, ETA
C
230   NU = -NU/LAMBL
      ETA = -(ETA + AL*AL/(MUL*DIAG(L)))/LAMBL
C
240   CONTINUE
C
C--GET LAST LAMBDA FOR D+
C
      AL = NU*Z(NV) - ETA*W(NV)
      LAMBL = 1.D0 + AL*W(NV)/DIAG(NV)
C
      DP(NV) = DIAG(NV)*LAMBL*LAMBL
C
C--UPDATE DIAG FROM D+
C
      DO 250 L=1,NV
250   DIAG(L) = DP(L)
C
C--NORMAL EXIT
C
260   LEX = 0
      RETURN
C
C--SWITCH TO UPDATING PROCEDURE 2
C
270   ISWUP = 2
      DO 280 L=2,NV
      DO 280 LL=1,L-1
280   ULT(L,LL) = ULT(LL,L)
      GO TO 110
C
C--ERROR EXIT IN CASE IF DIVISION BY ZERO WOULD OCCUR IN OPTIMAL 
C--CONDITIONING
C
290   IF (IOUT .GT. 0) WRITE (IOUT,291) IT
291   FORMAT ('0STOPPED AFTER ITERATION',I5,
     $        ' BECAUSE ALL SIGNIFICANT DIGITS LOST THROUGH',
     $        ' CANCELLATION IN OPTIMAL CONDITIONING')
      LEX = 1
      RETURN
C
      END
      SUBROUTINE DIRECT(LEX)
C
C--COMPUTE DIRECTION OF SEARCH (SOLVING (-ULT*DIAG*ULT')*PDIR = -G FOR 
C--PDIR) AND NORMALIZED GRADIENT
C
C--RETURNS FLAG LEX:
C--   0:  PDIR SUCCESSFULLY DETERMINED; CONTINUE
C--   1:  CONVERGED BY CRITERION 2:  PTG <= EPSC2
C--   2:  PDIR NOT IN ASCENT DIRECTION
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      PARAMETER (NP=45,NPV=45)
      COMMON /MAXFOP/ IOUT,IDET,LPRT
      COMMON /MAXF1/ THIN(NP),THL(NP),THU(NP),STPIN(NP),EPSD,YOTA,EPST,
     $               EPSC1,EPSC2,EPSC3,ISTIN(NP),NT,MAXIT,METHOD,IXVC,
     $               IHIT
      COMMON /MAXF2/ THPR(NP),CTH(NP),STP(NP),G(NPV),H(NPV,NPV),
     $               V(NPV,NPV),AV(NP,NP),STDE(NP),ULT(NPV,NPV),
     $               DIAG(NPV),PDIR(NPV),ERM,FPR,FCH,DIFMAX,GTG,PTG,
     $               TSTEP,IST(NP),NE,ND,NI,NB,NV,IMPBND,IT,NSURF2,IGFL,
     $               IVFL,IGAGE,IVAGE,IDIF
      DIMENSION Q(NPV)
C
C--SEPARATE PATHS FOR ONE OR MORE PARAMETERS
C
      IF (NV .GT. 1) GO TO 10
C
C--FOR NV = 1:
C
      PDIR(1) = G(1)/DIAG(1)
      GO TO 40
C
C--FOR NV > 1:
C
C--FIRST SOLVE   ULT*Q = G   FOR Q
C--(USE G RATHER THAN -G TO COMPENSATE FOR THE FACT THAT ULT*DIAG*ULT'
C--CORRESPONDS TO OPPOSITE OF ACTUAL HESSIAN MATRIX)
C
10    Q(1) = G(1)
      DO 20 L=2,NV
      Q(L) = G(L)
      DO 20 LL=1,L-1
20    Q(L) = Q(L) - ULT(L,LL)*Q(LL)
C
C--THEN SOLVE   ULT'*PDIR = DIAG**(-1)*Q   FOR PDIR
C
      PDIR(NV) = Q(NV)/DIAG(NV)
      DO 30 L = NV-1,1,-1
      PDIR(L) = Q(L)/DIAG(L)
      DO 30 LL=L+1,NV
30    PDIR(L) = PDIR(L) - ULT(LL,L)*PDIR(LL)
C
C--INITIALIZE EXIT FLAG
C
40    LEX = 0
C
C--COMPUTE NORMALIZED GRADIENT PDIR'G
C
      PTG = 0.D0
      DO 50 L=1,NV
50    PTG = PTG + PDIR(L)*G(L)
C
C--MAKE SURE PTG > 0 (DIRECTION WILL INCREASE FUNCTION)
C
60    IF (PTG .GT. 0.D0) GO TO 70
      LEX = 2
      RETURN
C
C--SEE IF PTG SMALL ENOUGH TO STOP
C
70    IF (PTG .GT. EPSC2) RETURN
      IF (IOUT .GT. 0) WRITE (IOUT,71) IT,PTG
71    FORMAT ('0CONVERGED BY CRITERION 2 AFTER ITERATION',I4,
     $        ':  NORMALIZED GRADIENT',E18.10,
     $        ' WITHIN SPECIFIED TOLERANCE')
      LEX = 1
      RETURN
C
      END
      SUBROUTINE LSRCH(FUN,THETA,F,NFE,IFIRST,IFL)
C
C--LINE SEARCH IN CHOSEN DIRECTION (PDIR)
C
C--RETURN FLAG IFL:
C--  -1:  ITERATION COMPLETE, BUT TSTEP < TIN AND < TMIN
C--   0:  ITERATION COMPLETE, WITH TSTEP >= TIN AND/OR TMIN
C--   1:  ITERATION COMPLETE; CONVERGED BY IMPLIED TEST
C--   2:  ITERATION COMPLETE; NEGLIGIBLE FUNCTION CHANGE
C--   3:  ITERATION COMPLETE; REACHED MAXIMUM # ITERATIONS
C--   4:  COULD NOT COMPLETE ITERATION
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      PARAMETER (NP=45,NPV=45)
      PARAMETER (CURV=.75D0)
      EXTERNAL DFN,ENDIT,FUN,LITV,VCNVCH
      COMMON /MAXFOP/ IOUT,IDET,LPRT
      COMMON /MAXF1/ THIN(NP),THL(NP),THU(NP),STPIN(NP),EPSD,YOTA,EPST,
     $               EPSC1,EPSC2,EPSC3,ISTIN(NP),NT,MAXIT,METHOD,IXVC,
     $               IHIT
      COMMON /MAXF2/ THPR(NP),CTH(NP),STP(NP),G(NPV),H(NPV,NPV),
     $               V(NPV,NPV),AV(NP,NP),STDE(NP),ULT(NPV,NPV),
     $               DIAG(NPV),PDIR(NPV),ERM,FPR,FCH,DIFMAX,GTG,PTG,
     $               TSTEP,IST(NP),NE,ND,NI,NB,NV,IMPBND,IT,NSURF2,IGFL,
     $               IVFL,IGAGE,IVAGE,IDIF
      DIMENSION THETA(*),THS(NP),THT(NP)
C
C--SET TIN (INITIAL TT), TMIN (SIMPLE INITIAL VALUES IF THIS IS FIRST
C--ITERATION WITH THIS NV)
C
      IF (IFIRST .LE. 0) GO TO 10
C
C--FIRST TIME
C
      TMIN = 0.D0
      TIN = .1D0
      GO TO 30
C
C--NOT FIRST TIME
C
10    THPM = 1.D30
      L = 0
      DO 20 I=1,NT
      IF (IST(I) .GT. 2) GO TO 20
      L = L + 1
      IF (PDIR(L) .NE. 0.D0)
     $   THPM = DMIN1(THPM,DFN(DABS(THETA(I)),YOTA)/DABS(PDIR(L)))
20    CONTINUE
      TMIN = .5D0*THPM/EPST
C
      TIN = 2.D0*FCH/PTG
      IF (TIN .LE. 0.D0) TIN = 1.D0
      TIN = DMIN1(TIN,1.D0)
      IF (IDIF .GT. 1) TIN = DMAX1(TIN,1.D0)
C
C--ESTABLISH MAXIMUM TSTEP (TBND) TO SATISFY BOUNDARY RESTRICTIONS ON
C--INDEPENDENT PARAMETERS
C
30    TBND = 1.D5
      L = 0
      DO 40 I=1,NT
      IF (IST(I) .GT. 2) GO TO 40
      L = L + 1
      IF (PDIR(L) .GT. 0.D0) THEN
         TBND = DMIN1(TBND,(THU(I) - THETA(I))/PDIR(L))
32       IF (THETA(I) + TBND*PDIR(L) .LE. THU(I)) GO TO 40
         TBND = (1.D0 - YOTA)*TBND
         GO TO 32
      ELSE IF (PDIR(L) .LT. 0.D0) THEN
         TBND = DMIN1(TBND,(THL(I) - THETA(I))/PDIR(L))
36       IF (THETA(I) + TBND*PDIR(L) .GE. THL(I)) GO TO 40
         TBND = (1.D0 - YOTA)*TBND
         GO TO 36
      END IF
40    CONTINUE
C
C--MODIFY TIN IF NECESSARY
C
      IF (TIN*(2.D0 + YOTA) .GE. TBND) TIN = TBND*(.5D0 - YOTA)
      TT = TIN
C
C--WRITE POSSIBLE TSTEP VALUES IN DETAIL FILE, IF ANY
C
      IF (IDET .GT. 0) WRITE (IDET,41) TIN,TMIN,TBND
41    FORMAT ('    INITIAL STEP SIZE',E13.5,'  MINIMUM STEP SIZE',E13.5,
     $        '  MAXIMUM STEP SIZE',E13.5)
C
C--BEGIN LINE SEARCH IN CHOSEN DIRECTION
C
C--SAVE INCOMING VALUES
C
      DO 50 I=1,NT
50    THS(I) = THETA(I)
      FS = F
C
C--INITIALIZE IMPLIED BOUNDARY FLAG
C
      IMPBND = 0
C
C--COMPUTE THETA-1
C
60    L = 0
      DO 80 I=1,NT
      IF (IST(I) .GT. 2) GO TO 70
      L = L + 1
      THT(I) = THS(I) + TT*PDIR(L)
      GO TO 80
70    THT(I) = THS(I)
80    CONTINUE
C
C--GET CORRESPONDING FUNCTIONAL VALUE F-1
C
      CALL FUN(THT,FT,NFE,LEX)
      IF (LEX .GT. 0) GO TO 250
      IF (FT .LE. F) GO TO 180
C
C--IMPROVING; TRY GOING FARTHER
C
90    TT2 = TT + TT
      IF (TT2 .LT. TBND) GO TO 110
C
C--CAN'T GO ANY FARTHER, SO STOP AT THETA-1
C
      IF (IDET .GT. 0) WRITE (IDET,91)
91    FORMAT ('0ACTIVE BOUNDARY CONSTRAINT ON INDEPENDENT PARAMETERS')
      TSTEP = TT
      F = FT
      DO 100 I=1,NT
100   THETA(I) = THT(I)
      GO TO 260
C
C--COMPUTE THETA-2 (FIXED PARAMETERS ALREADY ESTABLISHED; DEPENDENT ONES
C--WILL BE COMPUTED IN DEPAR VIA FUN)
C
110   L = 0
      DO 120 I=1,NT
      THETA(I) = THT(I)
      IF (IST(I) .GT. 2) GO TO 120
      L = L + 1
      THT(I) = THETA(I) + TT*PDIR(L)
120   CONTINUE
C
C--GET CORRESPONDING FUNCTIONAL VALUE F-2
C
      CALL FUN(THT,FT2,NFE,LEX)
      IF (LEX .LE. 0) GO TO 130
      IMPBND = 1
      GO TO 140
130   IF (FT2 .GT. FT) GO TO 150
      IMPBND = 0
C
C--NO LONGER IMPROVING; STOP AT THETA-1
C
140   TSTEP = TT
      F = FT
      GO TO 260
C
C--STILL IMPROVING; HOW FAST?
C
150   TT = TT2
      DIFF1 = FT2 - FT
      DIFF2 = FT - F
      IF (DIFF1 .GT. DIFF2) GO TO 170
C
C--SLOWER; TOO SLOW?
C
      IF (DIFF1/DIFF2 .GE. CURV) GO TO 170
C
C--TOO SLOW; STOP AT THETA-2
C
      TSTEP = TT2
      F = FT2
      DO 160 I=1,NT
160   THETA(I) = THT(I)
      GO TO 260
C
C--IMPROVING FASTER OR AT LEAST FAST ENOUGH;
C--PROCEED WITH THETA-2 AS NEW THETA-1
C
170   FT = FT2
      GO TO 90
C
C--NOT IMPROVING; TRY NOT GOING SO FAR
C
180   IMPBND = 0
      IF (TT .GT. TMIN) GO TO 190
C
C--CAN'T CUT ANY FARTHER; QUIT WITHOUT COMPLETING ITERATION
C
      IFL = 4
      RETURN
C
C--HALVE TT AND COMPUTE THETA-2 (FIXED PARAMETERS ALREADY ESTABLISHED;
C--DEPENDENT ONES WILL BE COMPUTED IN DEPAR VIA FUN)
C
190   TT = .5D0*TT
      L = 0
      DO 200 I=1,NT
      IF (IST(I) .GT. 2) GO TO 200
      L = L + 1
      THT(I) = THS(I) + TT*PDIR(L)
200   CONTINUE
C
C--GET CORRESPONDING FUNCTIONAL VALUE F-2
C
      CALL FUN(THT,FT2,NFE,LEX)
      IF (LEX .GT. 0) GO TO 250
      IF (FT2 .LE. F) GO TO 220
C
C--IMPROVED THIS TIME; STOP AT THETA-2
C
      TSTEP = TT
      F = FT2
      DO 210 I=1,NT
210   THETA(I) = THT(I)
      GO TO 260
C
C--STILL NOT IMPROVING; REDUCE TT FURTHER BY SCALING FACTOR
C
220   DIFF1 = FT + F - FT2 - FT2 
      SCAL = .1D0
      IF (DIFF1 .LT. 0.D0) SCAL = DMAX1(SCAL,1.D0 + .5D0*(F-FT)/DIFF1)
      TT = SCAL*TT
C
C--COMPUTE NEW THETA-2 (FIXED PARAMETERS ALREADY ESTABLISHED; DEPENDENT
C--ONES WILL BE COMPUTED IN DEPAR VIA FUN)
C
      L = 0
      DO 230 I=1,NT
      IF (IST(I) .GT. 2) GO TO 230
      L = L + 1
      THT(I) = THS(I) + TT*PDIR(L)
230   CONTINUE
C
C--GET CORRESPONDING FUNCITONAL VALUE F-2
C
      CALL FUN(THT,FT,NFE,LEX)
      IF (LEX .GT. 0) GO TO 250
C
C--IF STILL NOT IMPROVED, GO BACK TO CUT TT MORE, WITH THETA-2 AS NEW 
C--THETA-1
C
      IF (FT .LE. F) GO TO 180
C
C--IMPROVED THIS TIME; STOP AT THETA-2
C
      TSTEP = TT
      F = FT
      DO 240 I=1,NT
240   THETA(I) = THT(I)
      GO TO 260
C
C--IF RUN INTO UNDEFINED FUNCTION BEFORE ACHIEVING ANY IMPROVEMENT,
C--HALVE TT AND START OVER
C
250   TT = .5D0*TT
      IMPBND = 1
      GO TO 60
C
C--CHECK WHETHER TSTEP < TMIN
C
260   IF (TSTEP .GE. TMIN .OR. TSTEP .GE. TIN) GO TO 270
      IFL = -1
      GO TO 280
C
C--NORMAL TERMINATION
C
270   IFL = 0
C
C--FINISH UP THIS ITERATION
C
280   DO 290 I=1,NT
290   THPR(I) = THS(I)
      FPR = FS
      CALL ENDIT(THETA,F)
      IFIRST = 0
C
C--INCREMENT NUMBER OF ITERATIONS WITH THIS GRADIENT VECTOR
C
      IGAGE = IGAGE + 1
C
C--WRITE OUT DETAILS OF THIS ITERATION IF DESIRED
C
      IF (IDET .GT. 0) CALL LITV(THETA,F,NFE)
C
C--CHECK FOR CONVERGENCE
C
      CALL VCNVCH(THETA,LEX)
C
C--SET FLAG (IF APPROPRIATE) AND RETURN
C
      IF (LEX .GT. 0) IFL = LEX
      RETURN
C
      END
      SUBROUTINE PREPD(FUN,DEPAR,THETA,F,NFE,LEX)
C
C--PREPARE FOR DERIVATIVE COMPUTATION:
C--CHECK FOR CONVERGENCE TO BOUNDS AND WHETHER # PARAMETERS OK,
C--INITIALIZE INCREMENT STEPSIZE FACTORS FOR DERIVATIVE COMPUTATION
C
C--RETURNS FLAG LEX:
C--   0:  EVERYTHING OK
C--   1:  ALL INDEPENDENT PARAMETERS CONVERGED TO BOUNDS
C--   2:  TOO MANY PARAMETERS TO COMPUTE DERIVATIVES
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      PARAMETER (NP=45,NPV=45)
      EXTERNAL FUN,DEPAR
      EXTERNAL FIXBND
      COMMON /MAXFOP/ IOUT,IDET,LPRT
      COMMON /MAXF1/ THIN(NP),THL(NP),THU(NP),STPIN(NP),EPSD,YOTA,EPST,
     $               EPSC1,EPSC2,EPSC3,ISTIN(NP),NT,MAXIT,METHOD,IXVC,
     $               IHIT
      COMMON /MAXF2/ THPR(NP),CTH(NP),STP(NP),G(NPV),H(NPV,NPV),
     $               V(NPV,NPV),AV(NP,NP),STDE(NP),ULT(NPV,NPV),
     $               DIAG(NPV),PDIR(NPV),ERM,FPR,FCH,DIFMAX,GTG,PTG,
     $               TSTEP,IST(NP),NE,ND,NI,NB,NV,IMPBND,IT,NSURF2,IGFL,
     $               IVFL,IGAGE,IVAGE,IDIF
      DIMENSION THETA(*)
C
C--INITIALIZE COUNTER OF PARAMETERS CONVERGED TO BOUNDS
C
      NB = 0
C
C--CHECK FOR CONVERGENCE TO BOUNDS
C
      CALL FIXBND(FUN,DEPAR,THETA,F,NFE,LEXB)
      IF (LEXB .LT. 2) GO TO 10
      LEX = 1
      RETURN
C
C--CHECK FOR TOO MANY PARAMETERS
C
10    IF (NI .LE. NPV) GO TO 20
      IF (IOUT .GT. 0) WRITE (IOUT,11) NI,NPV
11    FORMAT ('0PROGRAM DIMENSIONS TOO SMALL TO COMPUTE DERIVATIVES ',
     $        'FOR',I3,' PARAMETERS; MAXIMUM NI IS',I3)
      LEX = 2
      RETURN
C
C--INITIALIZE INCREMENT STEPSIZE FACTORS FOR 2ND DERIVATIVE COMPUTATION
C
20    IF (IHIT .GT. 0) THEN
         SINIT = EPSD
      ELSE
         SINIT = YOTA
      END IF
      DO 30 I=1,NT
30    STP(I) = SINIT
C
      LEX = 0
      RETURN
C
      END
      SUBROUTINE FIXBND(FUN,DEPAR,THETA,F,NFE,LEX)
C
C--FIX PARAMETERS WHICH ARE CLOSE TO A BOUND
C
C--RETURNS FLAG LEX:
C--   0:  NOTHING NEW FIXED
C--   1:  FIXED AT LEAST ONE INDEPENDENT PARAMETER
C--   2:  ALL INDEPENDENT PARAMETERS NOW FIXED
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      PARAMETER (NP=45,NPV=45)
      EXTERNAL BNDCHK,DEPAR,FUN
      COMMON /MAXFOP/ IOUT,IDET,LPRT
      COMMON /MAXF1/ THIN(NP),THL(NP),THU(NP),STPIN(NP),EPSD,YOTA,EPST,
     $               EPSC1,EPSC2,EPSC3,ISTIN(NP),NT,MAXIT,METHOD,IXVC,
     $               IHIT
      COMMON /MAXF2/ THPR(NP),CTH(NP),STP(NP),G(NPV),H(NPV,NPV),
     $               V(NPV,NPV),AV(NP,NP),STDE(NP),ULT(NPV,NPV),
     $               DIAG(NPV),PDIR(NPV),ERM,FPR,FCH,DIFMAX,GTG,PTG,
     $               TSTEP,IST(NP),NE,ND,NI,NB,NV,IMPBND,IT,NSURF2,IGFL,
     $               IVFL,IGAGE,IVAGE,IDIF
      DIMENSION THETA(*)
C
C--SAVE INCOMING VALUE AND INITIALIZE EXIT FLAG
C
      NBS = NB
C
C--CHECK EACH VARYING INDEPENDENT PARAMETER
C
      DO 30 I=1,NT
      ISTI = IST(I)
      IF (ISTI .GT. 2) GO TO 30
      FS = F
      THIS = THETA(I)
      THIB = THU(I)
      CALL BNDCHK(THIS,THIB,LEXB)
      IF (LEXB .GT. 0) GO TO 10
      THIB = THL(I)
      CALL BNDCHK(THIS,THIB,LEXB)
      IF (LEXB .LE. 0) GO TO 30
C
C--CLOSE TO BOUND; FIX 
C
10    NB = NB + 1
      THETA(I) = THIB
      CALL FUN(THETA,F,NFE,LEXB)
      IF (LEXB .GT. 0 .OR. F .LT. FS) GO TO 20
C
      IST(I) = ISTI + 4
      IF (IOUT .GT. 0) WRITE (IOUT,11) I,THIB
11    FORMAT ('0PARAMETER',I3,' FIXED AT BOUND',G17.8)
      IF (IDET .GT. 0 .AND. IDET .NE. IOUT) WRITE (IDET,11) I,THIB
      GO TO 30
C
20    IST(I) = ISTI + 6
      IF (IOUT .GT. 0) WRITE (IOUT,21) I,THIB
21    FORMAT ('0PARAMETER',I3,' FIXED NEAR BOUND',G17.8)
      IF (IDET .GT. 0 .AND. IDET .NE. IOUT) WRITE (IDET,21) I,THIB
      THETA(I) = THIS
      F = FS
C
30    CONTINUE
C
C--FIX UP DEPENDENT PARAMETERS TO GO WITH FINAL THETA
C--(NEED NOT CHECK RETURN FLAG AS ALREADY TESTED THIS COMBINATION)
C
      IF (ND .GT. 0) CALL DEPAR(THETA,LEXB)
C
C--SET # PARAMETERS THAT MAY VARY
C
      NV = NI - NB
C
C--SEE IF ANY PARAMETERS HAVE BEEN FIXED
C
      IF (NB .GT. NBS) GO TO 40
      LEX = 0
      RETURN
C
C--SEE IF ANY LEFT UNFIXED
C
40    IF (NV .LE. 0) GO TO 50
      LEX = 1
      RETURN
C
50    IF (IOUT .GT. 0) WRITE (IOUT,51) IT
51    FORMAT ('0AFTER ITERATION',I4,
     $        ', ALL INDEPENDENT PARAMETERS CONVERGED TO BOUNDS')
      LEX = 2
      RETURN
C
      END
      SUBROUTINE BNDCHK(TH,THB,LEX)
C
C--TEST FOR CLOSENESS TO A BOUND
C
C--RETURNS FLAG LEX:
C--   0:  NOT CLOSE TO BOUND
C--   1:  CLOSE TO BOUND
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      PARAMETER (NP=45)
      COMMON /MAXF1/ THIN(NP),THL(NP),THU(NP),STPIN(NP),EPSD,YOTA,EPST,
     $               EPSC1,EPSC2,EPSC3,ISTIN(NP),NT,MAXIT,METHOD,IXVC,
     $               IHIT
C
C--PERFORM APPROPRIATE FORM OF TEST
C
      IF (DABS(TH) .GE. EPSD) GO TO 10
C
      IF (DABS(TH-THB) .LE. EPSD*EPSD) GO TO 30
      GO TO 20
C
10    RTH = THB/TH
      IF (RTH .GE. 1.D0-EPSD .AND. RTH .LE. 1.D0+EPSD) GO TO 30
C
C--NOT CLOSE TO BOUND
C
20    LEX = 0
      RETURN
C
C--CLOSE TO BOUND
C
30    LEX = 1
      RETURN
C
      END
      SUBROUTINE BCNVCH(THETA,LEX)
C
C--CHECK FOR CONVERGENCE -- IMPLIED AND REGULAR TESTS AND OTHER STUFF
C--APPROPRIATE FOR DIRECT SEARCH (BASIC)
C
C--RETURNS FLAG LEX:
C--   0:  FAILED CONVERGENCE TEST; CONTINUE ITERATING
C--   1:  PASSED CONVERGENCE TEST (CRITERION 1)
C--   2:  NEGLIGIBLE FUNCTION CHANGE (CONVERGENCE CRITERION 3)
C--   3:  FAILED CONVERGENCE TEST, BUT REACHED MAXIMUM # ITERATIONS
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      PARAMETER (NP=45,NPV=45)
      EXTERNAL EFN,ITEST
      COMMON /MAXFOP/ IOUT,IDET,LPRT
      COMMON /MAXF1/ THIN(NP),THL(NP),THU(NP),STPIN(NP),EPSD,YOTA,EPST,
     $               EPSC1,EPSC2,EPSC3,ISTIN(NP),NT,MAXIT,METHOD,IXVC,
     $               IHIT
      COMMON /MAXF2/ THPR(NP),CTH(NP),STP(NP),G(NPV),H(NPV,NPV),
     $               V(NPV,NPV),AV(NP,NP),STDE(NP),ULT(NPV,NPV),
     $               DIAG(NPV),PDIR(NPV),ERM,FPR,FCH,DIFMAX,GTG,PTG,
     $               TSTEP,IST(NP),NE,ND,NI,NB,NV,IMPBND,IT,NSURF2,IGFL,
     $               IVFL,IGAGE,IVAGE,IDIF
      DIMENSION THETA(*)
C
C--INITIALIZE INTERNAL EPSILON
C
      ELOC = EPSC1
C
C--LOOP THROUGH PARAMETERS, USING IMPLIED TEST FOR DEPENDENT ONES
C
10    DO 40 I=1,NT
      GO TO (20,20,30,40,40,40,40,40,40,40), IST(I)
20    IF (STP(I) .GT. EFN(DABS(THPR(I)),ELOC)) GO TO 60
      GO TO 40
30    CALL ITEST(THETA,I,ELOC,LEX)
      IF (LEX .LE. 0) GO TO 60
40    CONTINUE
C
C--PASSED BASIC CONVERGENCE TEST
C
      IF (IOUT .LE. 0) GO TO 50
      WRITE (IOUT,41) IT
41    FORMAT ('0BASIC ITERATION PROCESS OF DIRECT SEARCH CONVERGED ',
     $        'BY CRITERION 1 AT ITERATION',I4)
      IF (ELOC .GT. EPSC1 ) WRITE (IOUT,42) ELOC
42    FORMAT (' (USING EPSILON',G13.6,')')
50    LEX = 1 
      RETURN
C
C--FAILED STANDARD CONVERGENCE TEST
C
C--TRY INCREASING EPSILON IF NOT ALREADY TRIED AND DIFMAX SMALL ENOUGH
C
60    IF (EPSC1 .LE. 0.D0 .OR. ELOC .GT. EPSC1
     $    .OR. DIFMAX .GT. ELOC*ELOC) GO TO 70
      ELOC = ELOC*10.D0
      GO TO 10
C
C--COMPARE DIFMAX WITH USER-SPECIFIED EPSC3
C
70    IF (DIFMAX .GE. EPSC3) GO TO 80
      IF (IOUT .GT. 0) WRITE (IOUT,71) IT,DIFMAX
71    FORMAT ('0BASIC ITERATION PROCESS STOPPED AFTER ITERATION',I4,
     $        ' DUE TO NEGLIGIBLE DIFFERENCE IN COMPUTED FUNCTION ',
     $        'VALUES',E20.10/' (CONVERGENCE CRITERION 3)')
      LEX = 2
      RETURN
C
C--GIVE UP ON CONVERGENCE; CHECK FOR MAXIMUM # ITERATIONS
C
80    IF (IT .LT. MAXIT) GO TO 90
      IF (IOUT .GT. 0) WRITE (IOUT,81) IT
81    FORMAT ('0STOPPED WITHOUT CONVERGENCE AT',I4,
     $        ' ITERATIONS (REACHED ITERATION LIMIT)')
      LEX = 3
      RETURN
C
C--NOT THAT EITHER; CONTINUE ITERATING
C
90    LEX = 0
      RETURN
C
      END
      SUBROUTINE VCNVCH(THETA,LEX)
C
C--CHECK FOR CONVERGENCE -- IMPLIED TEST APPROPRIATE FOR NEWTON-RAPHSON
C--OR VARIABLE METRIC METHODS
C
C--RETURNS FLAG LEX:
C--   0:  FAILED CONVERGENCE TEST; CONTINUE ITERATING
C--   1:  PASSED (IMPLIED) CONVERGENCE TEST (CRITERION 1)
C--   2:  NEGLIGIBLE FUNCTION CHANGE (CONVERGENCE CRITERION 3)
C--   3:  FAILED CONVERGENCE TEST, BUT REACHED MAXIMUM # ITERATIONS
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      PARAMETER (NP=45,NPV=45)
      EXTERNAL ITEST
      COMMON /MAXFOP/ IOUT,IDET,LPRT
      COMMON /MAXF1/ THIN(NP),THL(NP),THU(NP),STPIN(NP),EPSD,YOTA,EPST,
     $               EPSC1,EPSC2,EPSC3,ISTIN(NP),NT,MAXIT,METHOD,IXVC,
     $               IHIT
      COMMON /MAXF2/ THPR(NP),CTH(NP),STP(NP),G(NPV),H(NPV,NPV),
     $               V(NPV,NPV),AV(NP,NP),STDE(NP),ULT(NPV,NPV),
     $               DIAG(NPV),PDIR(NPV),ERM,FPR,FCH,DIFMAX,GTG,PTG,
     $               TSTEP,IST(NP),NE,ND,NI,NB,NV,IMPBND,IT,NSURF2,IGFL,
     $               IVFL,IGAGE,IVAGE,IDIF
      DIMENSION THETA(*)
C
C--DO IMPLIED TEST FOR EACH VARYING PARAMETER
C
      DO 10 I=1,NT
      IF (IST(I) .GT. 3) GO TO 10
      CALL ITEST(THETA,I,EPSC1,LEX)
      IF (LEX .LE. 0) GO TO 20
10    CONTINUE
C
C--CONVERGED 
C
      IF (IOUT .GT. 0) WRITE (IOUT,11) IT
11    FORMAT ('0CONVERGED BY CRITERION 1 AT ITERATION',I4)
      RETURN
C
C--DID NOT CONVERGE BY IMPLIED TEST 
C--CHECK FOR NEGLIGIBLE CHANGE IN FUNCTION
C
20    IF (FCH .GE. EPSC3) GO TO 30
      IF (IOUT .GT. 0) WRITE (IOUT,21) IT,FCH
21    FORMAT ('0STOPPED AFTER ITERATION',I4,
     $        ' DUE TO NEGLIGIBLE FUNCTION CHANGE',E18.10,
     $        ' (CONVERGENCE CRITERION 3)')
      LEX = 2
      RETURN
C
C--DID NOT CONVERGE; CHECK FOR TOO MANY ITERATIONS
C
30    IF (IT .LT. MAXIT) RETURN
C
C--STOP AT MAXIMUM # ITERATIONS
C
      IF (IOUT .GT. 0) WRITE (IOUT,31) IT
31    FORMAT ('0STOPPED WITHOUT CONVERGENCE AT',I4,
     $        ' ITERATIONS (REACHED ITERATION LIMIT)')
      LEX = 3
      RETURN
C
      END
      SUBROUTINE ITEST(THETA,I,ELOC,LEX)
C
C--CHECK FOR CONVERGENCE ON ONE PARAMETER -- IMPLIED TEST
C
C--RETURNS FLAG LEX:
C--   0:  FAILED IMPLIED CONVERGENCE TEST
C--   1:  PASSED IMPLIED CONVERGENCE TEST
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      PARAMETER (NP=45,NPV=45)
      COMMON /MAXF2/ THPR(NP),CTH(NP),STP(NP),G(NPV),H(NPV,NPV),
     $               V(NPV,NPV),AV(NP,NP),STDE(NP),ULT(NPV,NPV),
     $               DIAG(NPV),PDIR(NPV),ERM,FPR,FCH,DIFMAX,GTG,PTG,
     $               TSTEP,IST(NP),NE,ND,NI,NB,NV,IMPBND,IT,NSURF2,IGFL,
     $               IVFL,IGAGE,IVAGE,IDIF
      DIMENSION THETA(*)
C
      IF (DABS(THPR(I)) .GT. ELOC) GO TO 10
      IF (DABS(CTH(I)) .GT. ELOC*ELOC) GO TO 30
      GO TO 20
10    RTH = THETA(I)/THPR(I)
      IF (RTH .LT. 1.D0-ELOC .OR. RTH .GT. 1.D0+ELOC) GO TO 30
C
C--PASSED TEST
C
20    LEX = 1
      RETURN
C
C--FAILED TEST
C
30    LEX = 0
      RETURN
C
      END
      SUBROUTINE ENDIT(THETA,F)
C
C--FINISH UP AN ITERATION
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      PARAMETER (NP=45,NPV=45)
      COMMON /MAXF1/ THIN(NP),THL(NP),THU(NP),STPIN(NP),EPSD,YOTA,EPST,
     $               EPSC1,EPSC2,EPSC3,ISTIN(NP),NT,MAXIT,METHOD,IXVC,
     $               IHIT
      COMMON /MAXF2/ THPR(NP),CTH(NP),STP(NP),G(NPV),H(NPV,NPV),
     $               V(NPV,NPV),AV(NP,NP),STDE(NP),ULT(NPV,NPV),
     $               DIAG(NPV),PDIR(NPV),ERM,FPR,FCH,DIFMAX,GTG,PTG,
     $               TSTEP,IST(NP),NE,ND,NI,NB,NV,IMPBND,IT,NSURF2,IGFL,
     $               IVFL,IGAGE,IVAGE,IDIF
      DIMENSION THETA(*)
C
      ERM = 0.D0
      DO 10 I=1,NT
      ER = THETA(I) - THPR(I)
      CTH(I) = ER
      ER = DABS(ER)
10    IF (ER .GT. ERM) ERM = ER
C
      FCH = F - FPR
C
      IT = IT + 1
C
      RETURN
C
      END
      SUBROUTINE VCMX(FUN,DEPAR,THETA,F,NFE,IH)
C
C--COMPUTE VARIANCE-COVARIANCE MATRIX
C
C--RETURNS FLAG IVFL:
C--   0:  NO PROBLEM WITH H
C--   1:  ROUND-OFF ERROR IN H
C--   3:  H COULD NOT BE INVERTED
C--   4:  H COULD NOT BE COMPUTED
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      PARAMETER (NP=45,NPV=45)
      EXTERNAL FUN,DEPAR
      EXTERNAL DERIV2,MMULT,MOUT,MXNVRT
      COMMON /MAXFOP/ IOUT,IDET,LPRT
      COMMON /MAXF2/ THPR(NP),CTH(NP),STP(NP),G(NPV),H(NPV,NPV),
     $               V(NPV,NPV),AV(NP,NP),STDE(NP),ULT(NPV,NPV),
     $               DIAG(NPV),PDIR(NPV),ERM,FPR,FCH,DIFMAX,GTG,PTG,
     $               TSTEP,IST(NP),NE,ND,NI,NB,NV,IMPBND,IT,NSURF2,IGFL,
     $               IVFL,IGAGE,IVAGE,IDIF
      DIMENSION THETA(*),HN(NPV,NPV)
C
C--INITIALIZE MATRIX COMPUTATION STATUS FLAG
C
      IVFL = 0
C
C--GET SECOND PARTIAL DERIVATIVES
C
      CALL DERIV2(FUN,DEPAR,THETA,F,NFE,IH,LEX)
      IF (LEX - 1) 30,20,10
10    IVFL = 4
      RETURN
20    IVFL = 1
C
C--PUT NEGATIVE OF MATRIX OF 2ND PARTIALS IN ANOTHER ARRAY
C
30    DO 40 L1=1,NV
      DO 40 L2=1,NV
40    HN(L1,L2) = -H(L1,L2)
C
C--INVERT TO GET VARIANCE-COVARIANCE MATRIX
C
      CALL MXNVRT(HN,NPV,NV,V,NPV,LEX)
      IF (LEX .LE. 0) GO TO 50
      IVFL = 3
      IF (IOUT .GT. 0) WRITE (IOUT,41) IT
41    FORMAT ('0AFTER ITERATION',I4,
     $        ' MATRIX OF SECOND PARTIAL DERIVATIVES CANNOT BE INVERTED'
     $        )
      IVAGE = -1
      RETURN
C
C--WRITE OUT MATRIX AND INVERSE CHECK IN DETAIL FILE, IF ANY
C
50    IF (IDET .LE. 0) GO TO 70
C
      WRITE (IDET,51)
51    FORMAT ('0VARIANCE-COVARIANCE MATRIX'/
     $        ' BEFORE ADDING ROWS AND COLUMNS FOR PARAMETERS THAT ARE',
     $        ' DEPENDENT OR CONVERGED TO A BOUND'/)
      CALL MOUT(V,NPV,NV,NV,IDET)
C
      CALL MMULT(H,NPV,NV,NV,V,NPV,NV,HN,NPV)
      DO 60 L1=1,NV
      DO 60 L2=1,NV
60    HN(L1,L2) = -HN(L1,L2)
      WRITE (IDET,61)
61    FORMAT ('0INVERSE CHECK:  SHOULD BE IDENTITY MATRIX'/)
      CALL MOUT(HN,NPV,NV,NV,IDET)
      WRITE (IDET,62)
62    FORMAT (/)
C
C--NOW HAVE NEW V; INDICATE THAT IT MATCHES CURRENT THETA
C
70    IVAGE = 0
      RETURN
C
      END
      SUBROUTINE AUGV(DEPAR,THETA,IH)
C
C--AUGMENT THE VARIANCE-COVARIANCE MATRIX TO INCLUDE INDEPENDENT
C--PARAMETERS THAT HAVE CONVERGED TO BOUNDS AND DEPENDENT
C--PARAMETERS, PRINT IT, AND COMPUTE STANDARD DEVIATIONS
C
C--NOTE THAT VALUES COMPUTED HERE CORRESPOND TO THE FINAL ESTIMATES
C--THETA, WHILE THE REST OF THE MATRIX MAY NOT
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      PARAMETER (NP=45,NPV=45)
      EXTERNAL DEPAR,DFN,FITDER,MOUT
      COMMON /MAXFOP/ IOUT,IDET,LPRT
      COMMON /MAXF1/ THIN(NP),THL(NP),THU(NP),STPIN(NP),EPSD,YOTA,EPST,
     $               EPSC1,EPSC2,EPSC3,ISTIN(NP),NT,MAXIT,METHOD,IXVC,
     $               IHIT
      COMMON /MAXF2/ THPR(NP),CTH(NP),STP(NP),G(NPV),H(NPV,NPV),
     $               V(NPV,NPV),AV(NP,NP),STDE(NP),ULT(NPV,NPV),
     $               DIAG(NPV),PDIR(NPV),ERM,FPR,FCH,DIFMAX,GTG,PTG,
     $               TSTEP,IST(NP),NE,ND,NI,NB,NV,IMPBND,IT,NSURF2,IGFL,
     $               IVFL,IGAGE,IVAGE,IDIF
      DIMENSION THETA(*),THP(NP),THM(NP),JDP(NPV),PRMUV(NPV),NEWV(NPV),
     $          U(NPV,3),DF(NPV,NPV),VN(NPV,NPV)
C
C--FIRST CONSIDER INDEPENDENT PARAMETERS THAT HAVE CONVERGED TO BOUNDS
C
      IF (NB .GT. 0) GO TO 20
C
C--NO INDEPENDENT PARAMETERS CONVERGED TO BOUNDS (NI = NV); JUST
C--COPY V TO VN AND GO ON
C
      DO 10 KK=1,NI
      DO 10 K=1,NI
10    VN(K,KK) = V(K,KK)
      GO TO 70
C
C--I INDEXES ALL NT PARAMETERS
C--K INDEXES NI INDEPENDENT PARAMETERS
C--L INDEXES NV ITERABLE (INDEPENDENT, NOT NEAR BOUND) PARAMETERS
C
20    K = 0
      L = 0
      DO 60 I=1,NT
      ISTI = IST(I)
      IF (ISTI .GE. 3 .AND. ISTI .LE. 4) GO TO 60
C
      K = K + 1
C
      IF (ISTI .LE. 2) GO TO 40
C
C--PARAMETER I HAS CONVERGED TO A BOUND; INSERT ZEROS
C
      DO 30 KK=1,NI
      VN(K,KK) = 0.D0
30    VN(KK,K) = 0.D0
      GO TO 60
C
C--PARAMETER I IS INDEPENDENT AND VARYING
C
40    L = L + 1
C
C--II, KK, LL PROVIDE SIMILAR INDEXING SCHEME FOR 2ND PARAMETER
C
      KK = 0
      LL = 0
      DO 50 II=1,I
      ISTII = IST(II)
      IF (ISTII .GE. 3 .AND. ISTII .LE. 4) GO TO 50
C
      KK = KK + 1
C
      IF (ISTII .GT. 4) GO TO 50
C
C--PARAMETER II IS INDEPENDENT AND NOT FIXED
C
      LL = LL + 1
      VN(K,KK) = V(L,LL)
      VN(KK,K) = V(LL,L)
C
50    CONTINUE
C
60    CONTINUE
C
C--NOW CONSIDER DEPENDENT PARAMETERS
C
70    IF (ND .GT. 0) GO TO 90
C
C--NO DEPENDENT PARAMETERS (NE = NI); JUST COPY VN TO AV AND GO ON TO
C--COMPUTE STANDARD DEVIATIONS
C
      DO 80 JJ=1,NE
      DO 80 J=1,NE
80    AV(J,JJ) = VN(J,JJ)
      GO TO 320
C
C--THERE ARE DEPENDENT PARAMETERS TO BE TAKEN CARE OF
C
C--FIRST MAJOR LOOP IS THROUGH INDEPENDENT PARAMETERS TO OBTAIN
C--DERIVATIVES OF ALL DEPENDENT PARAMETERS WITH RESPECT TO THEM
C
C--I INDEXES ALL NT PARAMETERS
C--J INDEXES ALL NE NON-FIXED (BY USER) PARAMETERS
C--K INDEXES NI INDEPENDENT PARAMETERS
C--M INDEXES ND DEPENDENT PARAMETERS
C
90    J = 0
      K = 0
      M = 0
C
      DO 270 I=1,NT
      ISTI = IST(I)
      IF (ISTI .EQ. 4) GO TO 270
C
      J = J + 1
C
      IF (ISTI .NE. 3) GO TO 100
C
C--STORE INDEX (IN 1 TO NE SYSTEM) TO MTH DEPENDENT PARAMETER
C
      M = M + 1
      JDP(M) = J
      GO TO 270
C
C--THIS IS AN INDEPENDENT PARAMETER
C
100   K = K + 1
C
      IF (ISTI .EQ. 1) GO TO 120
C
C--FOR INDEPENDENT PARAMETERS WHICH HAVE CONVERGED TO A BOUND OR ARE NOT
C--INVOLVED IN FUNCTIONAL RELATIONSHIPS, SET TO ZERO ALL DERIVATIVES
C--WITH RESPECT TO THEM
C
      DO 110 MM=1,ND
110   DF(MM,K) = 0.D0
      GO TO 250
C
C--PREPARE TO COMPUTE DERIVATIVES WITH RESPECT TO PARAMETER I
C
120   THI = THETA(I)
C
      DO 130 MM=1,ND
      PRMUV(MM) = 999999.D0
130   NEWV(MM) = 1
      DTHI = DFN(DABS(THI),STP(I))
C
      N = 1
C
C--OBTAIN NTH APPROXIMATION TO DERIVATIVE FOR EACH DEPENDENT PARAMETER
C--WHICH STILL NEEDS ANOTHER ITERATION
C
140   DO 150 II=1,NT
      THP(II) = THETA(II)
150   THM(II) = THETA(II)
      THP(I) = THI + DTHI
      THM(I) = THI - DTHI
      CALL DEPAR(THP,LEX)
      IF (LEX .GT. 0) GO TO 170
      CALL DEPAR(THM,LEX)
      IF (LEX .GT. 0) GO TO 170
C
C--II INDEXES ALL NT PARAMETERS
C--MM INDEXES ND DEPENDENT PARAMETERS
C
      MM = 0
      DO 160 II=1,NT
      IF (IST(II) .NE. 3) GO TO 160
      MM = MM + 1
      IF (NEWV(MM) .GT. 0) U(MM,N) = (THP(II) - THM(II))/(DTHI + DTHI)
160   CONTINUE
C
C--PREPARE TO DO ANOTHER APPROXIMATION IF NECESSARY
C
      IF (IH .LE. 0) GO TO 230
      N = N + 1
      IF (N .GT. 3) GO TO 180
C
C--PREPARE FOR ITERATION WITH SMALLER STEPSIZE
C
170   DTHI = DTHI*0.5D0
      GO TO 140
C
C--FOR EACH DEPENDENT PARAMETER STILL BEING WORKED ON, FIT DERIVATIVE
C--USING 3 (LATEST) APPROXIMATIONS
C
C--MM INDEXES ND DEPENDENT PARAMETERS
C
180   NEWIT = 0
      DO 220 MM=1,ND
      IF (NEWV(MM) .LE. 0) GO TO 220
      CALL FITDER(U(MM,1),U(MM,2),U(MM,3),DF(MM,K),PRMUV(MM),LEX)
      IF (LEX - 1) 210,200,190
C
C--POSSIBLE ROUND-OFF ERROR DETECTED IN COMPUTATION OF DERIVATIVE
C
190   IF (IOUT .GT. 0) WRITE(IOUT,191) MM,I,(U(MM,N),N=1,3)
191   FORMAT('0ROUNDING ERRORS MAY BE AFFECTING THE DERIVATIVE OF',
     $       I3,'TH FUNCTIONALLY DEPENDENT PARAMETER',
     $       ' WITH RESPECT TO PARAMETER',I3/
     $       ' THE 3 VALUES ARE',3G16.8)
C
C--GO DIRECTLY HERE IF DERIVATIVE SUCCESSFULLY APPROXIMATED
C
200   NEWV(MM) = 0
      GO TO 220
C
C--ANOTHER ITERATION NECESSARY FOR THIS DERIVATIVE
C
210   NEWIT = 1
220   CONTINUE
C
      IF (NEWIT .EQ. 0) GO TO 250
      N = 3
      GO TO 170
C
C--STORE 1ST APPROXIMATION (WHEN ONLY DOING ONE) FOR EACH DEPENDENT
C--PARAMETER
C
230   DO 240 MM=1,ND
240   DF(MM,K) = U(MM,1)
C
C--COPY ROW, COLUMN FOR THIS INDEPENDENT PARAMETER TO OUTPUT
C--VARIANCE-COVARIANCE MATRIX
C
C--II INDEXES ALL NT PARAMETERS
C--JJ INDEXES ALL NE NON-FIXED PARAMETERS
C--KK INDEXES NI INDEPENDENT PARAMETERS
C
250   JJ = 0
      KK = 0
      DO 260 II=1,I
      ISTII = IST(II)
      IF (ISTII .EQ. 4) GO TO 260
C
      JJ = JJ + 1
C
      IF (ISTII .EQ. 3) GO TO 260
C
      KK = KK + 1
      AV(J,JJ) = VN(K,KK)
      AV(JJ,J) = VN(KK,K)
260   CONTINUE
C
270   CONTINUE
C
C--SECOND MAJOR LOOP IS THROUGH DEPENDENT PARAMETERS TO COMPUTE AND
C--STORE CORRESPONDING VARIANCES, COVARIANCES
C
C--M INDEXES ND DEPENDENT PARAMETERS
C--JM GIVES CORRESPONDING INDEX (IN 1 TO NE SYSTEM) FOR OUTPUT MATRIX
C
      DO 310 M=1,ND
      JM = JDP(M)
C
C--FIRST DO COVARIANCES BETWEEN THIS DEPENDENT PARAMETER AND EACH
C--INDEPENDENT PARAMETER
C
C--I INDEXES ALL NT PARAMETERS
C--J INDEXES NE NON-FIXED PARAMETERS
C--K INDEXES NI INDEPENDENT PARAMETERS
C
      J = 0
      K = 0
      DO 290 I=1,NT
      ISTI = IST(I)
      IF (ISTI .EQ. 4) GO TO 290
C
      J = J + 1
C
      IF (ISTI .EQ. 3) GO TO 290
C
      K = K + 1
      S = 0.D0
      DO 280 KK=1,NI
280   S = S + DF(M,KK)*VN(KK,K)
      AV(JM,J) = S
      AV(J,JM) = S
C
290   CONTINUE
C
C--THEN DO COVARIANCES BETWEEN THIS DEPENDENT PARAMETER AND OTHER
C--DEPENDENT PARAMETERS (INCLUDING ITS OWN VARIANCE)
C
C--MM INDEXES ND DEPENDENT PARAMETERS
C--JMM GIVES CORRESPONDING INDEX (IN 1 TO NE SYSTEM) FOR OUTPUT MATRIX
C
      DO 310 MM=1,M
      JMM = JDP(MM)
      S = 0.D0
      DO 300 KK=1,NI
      DO 300 K=1,NI
300   S = S + DF(M,KK)*DF(MM,K)*VN(KK,K)
      AV(JM,JMM) = S
310   AV(JMM,JM) = S
C
C--PRINT OUT VARIANCE-COVARIANCE MATRIX AND RELATED INFORMATION
C
320   IF (IOUT .LE. 0) GO TO 330
      WRITE (IOUT,321)
321   FORMAT ('0VARIANCE-COVARIANCE MATRIX (NOT INCLUDING USER-FIXED ',
     $        'PARAMETERS):'/)
      CALL MOUT(AV,NP,NE,NE,IOUT)
      WRITE (IOUT,322) IVAGE
322   FORMAT ('0THIS MATRIX CORRESPONDS TO PARAMETER ESTIMATES OF',
     $        I4,' ITERATIONS AGO')
      IF (IVFL .GT. 0) WRITE (IOUT,323)
323   FORMAT ('0THIS MATRIX MAY BE AFFECTED BY ROUND-OFF ERRORS IN ',
     $        'COMPUTATION OF 2ND PARTIAL DERIVATIVES')
C
C--COMPUTE STANDARD DEVIATIONS WHERE POSSIBLE
C
330   J = 0
      DO 360 I=1,NT
      IF (IST(I) .NE. 4) GO TO 340
      STDE(I) = 0.D0
      GO TO 360
340   J = J + 1
      S = AV(J,J)
      IF (S .GE. 0.D0) GO TO 350
      STDE(I) = S
      IVFL = 2
      GO TO 360
350   STDE(I) = DSQRT(S)
360   CONTINUE
C
      RETURN
C
      END
      SUBROUTINE DERIV1(FUN,THETA,F,NFE)
C
C--COMPUTE GRADIENT (VECTOR OF FIRST PARTIAL DERIVATIVES) AND ITS NORM
C
C--RETURNS FLAG IGFL:
C--   0:  DERIVATIVES SUCCESSFULLY COMPUTED
C--   1:  DERIVATIVES COULD NOT BE COMPUTED DUE TO UNDEFINED FUNCTION
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      PARAMETER (NP=45,NPV=45)
      EXTERNAL DFN,FUN
      COMMON /MAXFOP/ IOUT,IDET,LPRT
      COMMON /MAXF1/ THIN(NP),THL(NP),THU(NP),STPIN(NP),EPSD,YOTA,EPST,
     $               EPSC1,EPSC2,EPSC3,ISTIN(NP),NT,MAXIT,METHOD,IXVC,
     $               IHIT
      COMMON /MAXF2/ THPR(NP),CTH(NP),STP(NP),G(NPV),H(NPV,NPV),
     $               V(NPV,NPV),AV(NP,NP),STDE(NP),ULT(NPV,NPV),
     $               DIAG(NPV),PDIR(NPV),ERM,FPR,FCH,DIFMAX,GTG,PTG,
     $               TSTEP,IST(NP),NE,ND,NI,NB,NV,IMPBND,IT,NSURF2,IGFL,
     $               IVFL,IGAGE,IVAGE,IDIF
      DIMENSION THETA(*),THY(NP)
C
C--INITIALIZE
C
      IGAGE = -1
      DO 10 I=1,NT
10    THY(I) = THETA(I)
      GTG = 0.D0
C
C--LOOP THROUGH NV INDEPENDENT VARYING PARAMETERS 
C
      L = 0
      DO 80 I=1,NT
      IF (IST(I) .GT. 2) GO TO 80
      L = L + 1
      THIS = THY(I)
      SI = YOTA
C
20    DTHI = DFN(DABS(THIS),SI)
      THIY = THIS + DTHI
      IF (THIY .GT. THU(I)) GO TO 40
      THY(I) = THIY
      CALL FUN(THY,FP,NFE,LEX)
      IF (LEX .LE. 0) GO TO 50
C
C--RUNNING INTO IMPLIED BOUNDARY
C
30    IMPBND = 1
C
C--RUNNING INTO TROUBLE; DECREASE INCREMENT
C
40    SI = 0.5D0*SI
      IF (SI .LT. EPSD*EPSD/8.D0) GO TO 90
      GO TO 20
C
C--DIVIDE FORWARD, CENTRAL DIFFERENCE PATHS
C
50    IF (IDIF .GT. 1) GO TO 60
C
C--FORWARD DIFFERENCE
C
      G(L) = (FP - F)/DTHI
      GO TO 70
C
C--CENTRAL DIFFERENCE
C
60    THIY = THIS - DTHI
      IF (THIY .LT. THL(I)) GO TO 40
      THY(I) = THIY
      CALL FUN(THY,FM,NFE,LEX)
      IF (LEX .GT. 0) GO TO 30
      G(L) = (FP - FM)/(DTHI + DTHI)
C
70    GTG = GTG + G(L)**2
      THY(I) = THIS
80    CONTINUE
C
C--FINISH NORM OF GRADIENT
C
      GTG = DSQRT(GTG)
C
C--INDICATE HAVE G CORRESPONDING TO CURRENT THETA
C
      IGFL = 0
      IGAGE = 0
C
      RETURN
C
C--ERROR EXIT; PARAMETER I STUCK
C
90    IF (IOUT .GT. 0) WRITE (IOUT,91) IT, I
91    FORMAT ('0AFTER ITERATION',I4,','/
     $        '    1 OR MORE 1ST PARTIAL DERIVATIVES COULD NOT BE ',
     $        'COMPUTED, AS PARAMETER',I4,
     $        ' CLOSE TO EXPLICIT OR IMPLIED BOUNDARY')
      IGFL = 1
      RETURN
C
      END
      SUBROUTINE DERIV2(FUN,DEPAR,THETA,F,NFE,IH,LEX)
C
C--COMPUTE 2ND PARTIAL DERIVATIVES OF THE FUNCTION
C
C--RETURNS FLAG LEX:
C--   0:  NO PROBLEM WITH H
C--   1:  ROUND-OFF ERROR IN H
C--   2:  COULD NOT COMPUTE H
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      PARAMETER (NP=45,NPV=45)
      EXTERNAL DEPAR,DFN,FITDER,FUN,MOUT
      COMMON /MAXFOP/ IOUT,IDET,LPRT
      COMMON /MAXF1/ THIN(NP),THL(NP),THU(NP),STPIN(NP),EPSD,YOTA,EPST,
     $               EPSC1,EPSC2,EPSC3,ISTIN(NP),NT,MAXIT,METHOD,IXVC,
     $               IHIT
      COMMON /MAXF2/ THPR(NP),CTH(NP),STP(NP),G(NPV),H(NPV,NPV),
     $               V(NPV,NPV),AV(NP,NP),STDE(NP),ULT(NPV,NPV),
     $               DIAG(NPV),PDIR(NPV),ERM,FPR,FCH,DIFMAX,GTG,PTG,
     $               TSTEP,IST(NP),NE,ND,NI,NB,NV,IMPBND,IT,NSURF2,IGFL,
     $               IVFL,IGAGE,IVAGE,IDIF
      DIMENSION THETA(*),THY(NP),LRH(NPV,NPV),NBD(4),HN(NPV,NPV,3)
C
C--INDICATE TYPE OF APPROXIMATION USED FOR SECOND DERIVATIVES
C
      IF (IDET .LE. 0) GO TO 10
      IF (IH .GT. 0) THEN
         WRITE (IDET,1)
1        FORMAT ('0COMPUTING SECOND PARTIAL DERIVATIVES USING ',
     $           'ITERATIVE APPROXIMATION')
      ELSE
         WRITE (IDET,2)
2        FORMAT ('0COMPUTING SECOND PARTIAL DERIVATIVES USING A ',
     $           'SINGLE APPROXIMATION')
      END IF
C
C--INITIALIZE
C
10    LEX = 0
      E2D8 = EPSD*EPSD/8.D0
      DO 20 I=1,NT
20    THY(I) = THETA(I)
      DO 30 LL=1,NV
      DO 30 L=1,NV
30    LRH(L,LL) = 0
C
C--LOOP THROUGH INDEPENDENT, VARYING PARAMETERS
C
      L = 0
      DO 450 I=1,NT
      ISTI = IST(I)
      IF (ISTI .GT. 2) GO TO 450
      L = L + 1
      THI = THY(I)
      ATHI = DABS(THI)
      SI = STP(I)
      DTHI = DFN(ATHI,SI)
C
C--CHECK WHETHER NEIGHBORING VALUES ARE OK WITH RESPECT TO BOUNDS,
C--DEPENDENT PARAMETERS
C
40    THIP = THI + DTHI
      THIM = THI - DTHI
      IF (THIP .LE. THU(I) .AND. THIM .GE. THL(I)) GO TO 50
      SI = SI*0.5D0
      IF (SI .LT. E2D8) GO TO 490
      DTHI = 0.5D0*DTHI
      GO TO 40
50    IF (ISTI .EQ. 2) GO TO 80
60    THY(I) = THIP
      CALL DEPAR(THY,LEXF)
      IF (LEXF .GT. 0) GO TO 70
      THY(I) = THIM
      CALL DEPAR(THY,LEXF)
      IF (LEXF .LE. 0) GO TO 80
70    IMPBND = 1
      SI = SI*0.5D0
      IF (SI .LT. E2D8) GO TO 490
      DTHI = 0.5D0*DTHI
      THIM = THI - DTHI
      THIP = THI + DTHI
      GO TO 60
C
C--RESTORE THY(I) AND SAVE CURRENT VALUE OF STEPSIZE FACTOR
C
80    STP(I) = SI
      THY(I) = THI
C
C--COMPUTE 2ND PARTIAL DERIVATIVES FOR (I,II) AND (II,I) PAIRS 
C--WHERE II < I
C
      IF (I .EQ. 1) GO TO 360
C
      LL = 0
      DO 350 II=1,I-1
      ISTII = IST(II)
      IF (ISTII .GT. 2) GO TO 350
      LL = LL + 1
C
      THII = THY(II)
      ATHII = DABS(THII)
      SII = STP(II)
      DTHII = DFN(ATHII,SII)
      SI = STP(I)
      DTHI = DFN(ATHI,SI)
C
C--IF BOTH INDEPENDENT PARAMETERS ARE INVOLVED IN FUNCTIONAL
C--RELATIONSHIPS, CHECK ALL COMBINATIONS OF NEIGHBORING PARAMETER PAIRS
C--WITH RESPECT TO DEPENDENT PARAMETERS
C
      IF (ISTI .EQ. 2 .OR. ISTII .EQ. 2) GO TO 260
90    NL = 1
100   DO 110 NK=1,4
110   NBD(NK) = 0
      THY(I) = THI + DTHI
      THY(II) = THII + DTHII
      NM = 0
      NK = 1
120   CALL DEPAR(THY,LEXF)
      IF (LEXF .LE. 0) GO TO 130
      IMPBND = 1
      NBD(NK) = 1
      NM = NM + 1
130   GO TO (140,150,160,170), NK
140   THY(II) = THII - DTHII
      NK = 2
      GO TO 120
150   THY(I) = THI - DTHI
      THY(II) = THII + DTHII
      NK = 3
      GO TO 120
160   THY(II) = THII - DTHII
      NK = 4
      GO TO 120
170   IF (NM .LE. 0) GO TO 260
      GO TO (180,220,230,230), NM
180   GO TO (190,200,210,190), NL
190   SI = SI*0.5D0
      IF (SI .LT. E2D8) GO TO 490
      DTHI = 0.5D0*DTHI
      NL = 2
      GO TO 100
200   SII = SII*0.5D0
      IF (SII .LT. E2D8) GO TO 480
      DTHII = 0.5D0*DTHII
      SI = SI + SI
      DTHI = DTHI + DTHI
      NL = 3
      GO TO 100
210   SI = SI*0.5D0
      IF (SI .LT. E2D8) GO TO 490
      DTHI = 0.5D0*DTHI
      NL = 4
      GO TO 100
220   IF ((NBD(1)*NBD(2) .GT. 0) .OR. (NBD(3)*NBD(4) .GT. 0)) GO TO 250
      IF ((NBD(1)*NBD(3) .GT. 0) .OR. (NBD(2)*NBD(4) .GT. 0)) GO TO 240
230   SI = SI*0.5D0
      IF (SI .LT. E2D8) GO TO 490
      DTHI = 0.5D0*DTHI
240   SII = SII*0.5D0
      IF (SII .LT. E2D8) GO TO 480
      DTHII = 0.5D0*DTHII
      GO TO 90
250   SI = SI*0.5D0
      IF (SI .LT. E2D8) GO TO 490
      DTHI = 0.5D0*DTHI
      GO TO 90
C
C--READY TO GO AHEAD WITH DERIVATIVE ESTIMATION
C
260   PRMUH = 999999.D0
      N = 1
C
C--COMPUTE NTH APPROXIMATION TO 2ND PARTIAL DERIVATIVE
C
270   THY(I) = THI + DTHI
      THY(II) = THII + DTHII
      CALL FUN(THY,FPP,NFE,LEXF)
      IF (LEXF .GT. 0) GO TO 280
      THY(I) = THI - DTHI
      CALL FUN(THY,FMP,NFE,LEXF)
      IF (LEXF .GT. 0) GO TO 280
      THY(II) = THII - DTHII
      CALL FUN(THY,FMM,NFE,LEXF)
      IF (LEXF .GT. 0) GO TO 280
      THY(I) = THI + DTHI
      CALL FUN(THY,FPM,NFE,LEXF)
      IF (LEXF .LE. 0) GO TO 290
280   IMPBND = 1
      IF (N .GT. 1) GO TO 470
      SI = SI*0.5D0
      IF (SI .LT. E2D8) GO TO 470
      SII = SII*0.5D0
      IF (SII .LT. E2D8) GO TO 470
      DTHI = DTHI*0.5D0
      DTHII = DTHII*0.5D0
      GO TO 270
C
290   HN(L,LL,N) = (FPP - FMP - FPM + FMM)/(4.D0*DTHI*DTHII)
C
C--STORE FIRST APPROXIMATION IF ONLY DOING ONE
C
      IF (IH .GT. 0) GO TO 300
      H(L,LL) = HN(L,LL,1)
      GO TO 340
C
C--PREPARE TO DO ANOTHER APPROXIMATION IF APPROPRIATE
C
300   N = N + 1
      IF (N .LE. 3) GO TO 320
C
C--FIT DERIVATIVES FROM 3 APPROXIMATIONS
C
      CALL FITDER(HN(L,LL,1),HN(L,LL,2),HN(L,LL,3),H(L,LL),PRMUH,LEXF)
C
C--CHECK RESULTS OF 2ND DERIVATIVE ESTIMATION
C
      IF (LEXF - 1) 310,340,330
C
C--NEED TO DO ANOTHER ITERATION FOR 2ND DERIVATIVE
C
310   N = 3
C
320   SI = SI*0.5D0
      DTHI = DTHI*0.5D0
      SII = SII*0.5D0
      DTHII = DTHII*0.5D0
      GO TO 270
C
C--ITERATION FINISHED BUT THERE IS ROUND-OFF ERROR IN COMPUTING
C--2ND DERIVATIVE
C
330   LRH(L,LL) = 1
      LEX = 1
C
C--COPY 2ND DERIVATIVE TO ELEMENT (LL,L) OF SYMMETRIC MATRIX
C
340   H(LL,L) = H(L,LL)
C
C--FINISH UP LOOP
C
C--RESTORE ORIGINAL VALUES OF ITH, IITH PARAMETERS
C
      THY(I) = THI
      THY(II) = THII
C
350   CONTINUE
C
C--TAKE CARE OF (I,I) PAIR
C
360   SI = STP(I)
      DTHI = DFN(ATHI,SI)
C
      PRMUH = 999999.D0
      N = 1
C
C--START HERE TO WORK ON NTH APPROXIMATION
C
370   THY(I) = THI + DTHI
      CALL FUN(THY,FP,NFE,LEXF)
      IF (LEXF .GT. 0) GO TO 380
      THY(I) = THI - DTHI
      CALL FUN(THY,FM,NFE,LEXF)
      IF (LEXF .LE. 0) GO TO 390
380   IMPBND = 1
      IF (N .GT. 1) GO TO 490
      SI = SI*0.5D0
      IF (SI .LT. E2D8) GO TO 490
      DTHI = DTHI*0.5D0
      GO TO 370
C
390   HN(L,L,N) = (FP - F - F + FM)/(DTHI*DTHI)
C
C--STORE FIRST APPROXIMATION IF ONLY DOING ONE
C
      IF (IH .GT. 0) GO TO 400
      H(L,L) = HN(L,L,1)
      GO TO 440
C
C--PREPARE TO DO ANOTHER APPROXIMATION IF NECESSARY
C
400   N = N + 1
      IF (N .LE. 3) GO TO 420
C
C--FIT DERIVATIVES FROM 3 APPROXIMATIONS
C
      CALL FITDER(HN(L,L,1),HN(L,L,2),HN(L,L,3),H(L,L),PRMUH,LEXF)
C
C--CHECK RESULTS OF 2ND DERIVATIVE ESTIMATION
C
      IF (LEXF - 1) 410,440,430
C
C--NEED TO DO ANOTHER ITERATION FOR 2ND DERIVATIVE
C
410   N = 3
C
420   SI = SI*0.5D0
      DTHI = 0.5D0*DTHI
      GO TO 370
C
C--ITERATION FINISHED BUT THERE IS ROUND-OFF ERROR IN COMPUTING
C--2ND DERIVATIVE
C
430   LRH(L,L) = 1
      LEX = 1
C
C--RESTORE ORIGINAL VALUE OF I'TH PARAMETER
C
440   THY(I) = THI
C
450   CONTINUE
C
C--PRINT H AND WARNINGS ABOUT ROUND-OFF ERRORS IN DETAIL FILE, IF ANY
C
      IF (IDET .LE. 0) RETURN
C
      WRITE (IDET,451)
451   FORMAT ('0MATRIX OF SECOND PARTIAL DERIVATIVES'/
     $        ' NOT COUNTING PARAMETERS THAT ARE FIXED, DEPENDENT, OR ',
     $        'CONVERGED TO A BOUND'/)
      CALL MOUT(H,NPV,NV,NV,IDET)
C
      IF (LEX .LE. 0) RETURN
C
C--PRINT WARNINGS ABOUT 2ND PARTIAL DERIVATIVES
C
      WRITE(IDET,452)
452   FORMAT('0ROUNDING ERRORS MAY BE AFFECTING THE FOLLOWING ELEMENTS',
     $       ' IN THE MATRIX OF SECOND PARTIAL DERIVATIVES:'//
     $       '   L LL',8X,'D1(L,LL)',8X,'D2(L,LL)',8X,'D3(L,LL)')
      DO 460 L=1,NV
      DO 460 LL=1,L
460   IF (LRH(L,LL) .GT. 0) WRITE(IDET,461) L,LL,(HN(L,LL,N),N=1,3)
461   FORMAT(' ',2I3,3G16.8)
C
      RETURN
C
C--ERROR EXIT; PARAMETERS II AND I STUCK
C
470   IF (IOUT .GT. 0) WRITE(IOUT,491) IT,II
      GO TO 490
C
C--ERROR EXIT; PARAMETER II STUCK
C
480   I = II
C
C--ERROR EXIT; PARAMETER I STUCK
C
490   IF (IOUT .GT. 0) WRITE(IOUT,491) IT,I
491   FORMAT ('0AFTER ITERATION',I4,','/
     $        '    1 OR MORE 2ND PARTIAL DERIVATIVES COULD NOT BE ',
     $        'COMPUTED, AS PARAMETER',I4,
     $        ' CLOSE TO EXPLICIT OR IMPLIED BOUNDARY')
C
      LEX = 2
      RETURN
C
      END
      SUBROUTINE FITDER(D1,D2,D3,DD,PRMU,LEX)
C
C--FITDER COMPUTES AN IMPROVED VALUE FOR A NUMERICAL DERIVATIVE
C--USING 3 ESTIMATES WHICH HAVE BEEN COMPUTED USING 3 DIFFERENT 
C--STEP SIZES.
C
C--RETURNS FLAG LEX:
C--   0:  NEED ANOTHER ITERATION
C--   1:  SUCCESSFUL DERIVATIVE ESTIMATION
C--   2:  ROUND-OFF ERROR
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      PARAMETER (NP=45,NPV=45)
      PARAMETER (ZER=0.1D-07)
      COMMON /MAXF1/ THIN(NP),THL(NP),THU(NP),STPIN(NP),EPSD,YOTA,EPST,
     $               EPSC1,EPSC2,EPSC3,ISTIN(NP),NT,MAXIT,METHOD,IXVC,
     $               IHIT
C
C--SEE IF ALL ESTIMATES < 10**-8
C
      IF (DABS(D1) .GE. ZER .OR. DABS(D2) .GE. ZER .OR.
     $    DABS(D3) .GE. ZER) GO TO 10
      DD = 0.D0
      LEX = 1
      RETURN
C
C--COMPUTE RATIO R
C
10    RDEN = D3 + D3 - D2
      IF (RDEN .NE. 0.D0) GO TO 20
      R = 0.D0
      GO TO 30
20    R = (D2 + D2 - D1)/RDEN
C
C--IF R "CLOSE" TO 1, FINISHED
C
30    TEPS = 10.D0*EPSD
      IF (R .GE. 1.D0-TEPS .AND. R .LE. 1.D0+TEPS) GO TO 50
C
C--UNLESS R GETTING FARTHER FROM 1, DO ANOTHER ITERATION
C
      RMU = DABS(R - 1.D0)
      IF (RMU .GT. PRMU) GO TO 40
      PRMU = RMU
      D1 = D2
      D2 = D3
      LEX = 0
      RETURN
C
40    DD = D1
      LEX = 2
      RETURN
C
50    DD = (D1 - 6.0D0*D2 + 8.0D0*D3)/3.0D0
      LEX = 1
      RETURN
C
      END
      FUNCTION DFN(ATH,SF)
C
C--COMPUTES INCREMENT ("DELTA THETA") AS A FUNCTION OF ATH AND STEPSIZE
C--FACTOR SF, WITH PARAMETER TAU
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      PARAMETER (TAU=0.5D0)
C
      IF (ATH .GT. TAU) THEN
         DFN = ATH
      ELSE
         DFN = TAU
      END IF
      DFN = SF*DFN
      RETURN
C
      END
      FUNCTION DFNINV(ATH,DELTH)
C
C--COMPUTES INCREMENT STEPSIZE FACTOR AS A FUNCTION OF ATH AND 
C--INCREMENT DELTH, WITH PARAMETER TAU
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      PARAMETER (TAU=0.5D0)
C
      IF (ATH .GT. TAU) THEN
         DFNINV = DELTH/ATH
      ELSE
         DFNINV = DELTH/TAU
      END IF
      RETURN
C
      END
      FUNCTION EFN(ATH,ELOC)
C
C--COMPUTES MINIMAL VALUE OF INCREMENT STEPSIZE FACTOR (DELTA) AS A 
C--FUNCTION OF ATH, WITH PARAMETERS ELOC AND TAU
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      PARAMETER (TAU=0.5D0)
C
      EFN = ELOC
      IF (ATH .GT. TAU) RETURN
      EFN = EFN/TAU
      IF (ATH .GT. ELOC) THEN
         EFN = EFN*ATH
      ELSE
         EFN = EFN*ELOC
      END IF
      RETURN
C
      END
      SUBROUTINE MXNVRT(A,MRA,M,B,MRB,LEX)
C
C--INVERT POSITIVE DEFINITE MATRIX A (M BY M) AND PLACE INVERSE MATRIX
C--IN B (M BY M)
C
C--GAUSS-JORDAN ALGORITHM IS PERFORMED WITHOUT PERMUTATION OF ROWS:
C--A ZERO PIVOT ELEMENT AT ANY STEP CAUSES ERROR EXIT
C
C--RETURNS FLAG LEX:
C--   0:  NO ERROR
C--   1:  MATRIX CANNOT BE INVERTED BY THIS SUBROUTINE
C--   2:  INVALID ARGUMENT: ORDER OF MATRIX <= 0
C
C--NOTE THAT INDICES I, J, K ARE LOCAL TO THIS SUBROUTINE AND MAY NOT
C--CORRESPOND TO INDICES OF THE SAME NAMES IN OTHER PROGRAM UNITS
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DIMENSION A(MRA,*),B(MRB,*)
C
C--FIRST TAKE CARE OF SCALAR CASE
C
      IF (M - 1) 10,20,30
C
C--INVALID ORDER OF MATRIX
C
10    LEX = 2
      RETURN
C
C--SCALAR CASE:  M = 1
C
20    D = A(1,1)
      IF (D .EQ. 0.D0) GO TO 100
      B(1,1) = 1.D0/D
      GO TO 90
C
C--USUAL CASE:  M > 1
C
C--INITIALIZE 
C
30    DO 40 J=1,M
      DO 40 I=1,M
40    B(I,J) = A(I,J)
C
C--LOOP THROUGH PIVOT ELEMENTS
C
      DO 80 K=1,M
C
C--GET PIVOT ELEMENT
C
      P = B(K,K)
C
C--CHECK FOR ZERO PIVOT ELEMENT
C
      IF (P .EQ. 0.D0) GO TO 100
C
C--INVERT PIVOT ELEMENT
C
      P = 1.D0/P
C
C--PROCESS K'TH COLUMN (EXCEPT K'TH ROW ELEMENT)
C
      DO 50 I=1,M
50    IF (I .NE. K) B(I,K) = B(I,K)*P
C
C--LOOP THROUGH OTHER COLUMNS
C
      DO 70 J=1,M
      IF (J .EQ. K) GO TO 70
C
C--PROCESS J'TH COLUMN (EXCEPT K'TH ROW ELEMENT)
C
      DO 60 I=1,M
60    IF (I .NE. K) B(I,J) = B(I,J) - B(I,K)*B(K,J)
C
70    CONTINUE
C
C--NOW TAKE CARE OF K'TH ROW 
C
      B(K,K) = P
C
      P = -P
      DO 80 J=1,M
80    IF (J .NE. K) B(K,J) = P*B(K,J)
C
C--NORMAL RETURN
C
90    LEX = 0
      RETURN
C
C--ERROR EXIT IF MATRIX CANNOT BE INVERTED
C
100   LEX = 1
      RETURN
C
      END
      SUBROUTINE MMULT(A,MRA,MA,NAMB,B,MRB,NB,C,MRC)
C
C--MULTIPLY MATRIX A (MA BY NAMB) BY MATRIX B (NAMB BY NB) AND STORE
C--THE RESULT IN MATRIX C (MA BY NB)
C
C--NOTE THAT INDICES I, J, K ARE LOCAL TO THIS GENERAL SUBROUTINE AND
C--MAY NOT CORRESPOND TO INDICES OF THE SAME NAMES IN OTHER PROGRAM
C--UNITS
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DIMENSION A(MRA,*),B(MRB,*),C(MRC,*)
C
      DO 20 I=1,MA
      DO 20 J=1,NB
      Z = 0.D0
      DO 10 K=1,NAMB
10    Z = Z + A(I,K)*B(K,J)
20    C(I,J) = Z
      RETURN
C
      END
      SUBROUTINE MOUT(A,MRA,M,N,IPR)
C
C--WRITE (IN IPR) MATRIX A (M BY N) WHOSE REAL FIRST DIMENSION SIZE IS
C--MRA
C
C--NOTE THAT INDICES I, J ARE LOCAL TO THIS GENERAL SUBROUTINE AND MAY
C--NOT CORRESPOND TO INDICES OF THE SAME NAMES IN OTHER PROGRAM UNITS
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DIMENSION A(MRA,*)
C
      JI = 1
      IF (N .LE. 9) GO TO 20
10    JF = 9
      GO TO 30
20    JF = N
30    DO 40 I=1,M
40    WRITE (IPR,41) (A(I,J),J=JI,JF)
41    FORMAT (' ',9E14.6)
      IF (JF .GE. N) RETURN
      WRITE (IPR,42)
42    FORMAT (/)
      JI = JI + 9
      JF = JF + 9
      IF (JF .GT. N) GO TO 20
      GO TO 30
C
      END
      SUBROUTINE LBD(THETA,F)
C
C--LIST (IN IOUT) INITIAL CONDITIONS FOR DIRECT SEARCH METHOD 
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      PARAMETER (NP=45)
      CHARACTER*28 LABEL
      CHARACTER*36 STATUS
      COMMON /MAXFLB/ LABEL(NP)
      COMMON /MAXFST/ STATUS(10)
      COMMON /MAXFOP/ IOUT,IDET,LPRT
      COMMON /MAXF1/ THIN(NP),THL(NP),THU(NP),STPIN(NP),EPSD,YOTA,EPST,
     $               EPSC1,EPSC2,EPSC3,ISTIN(NP),NT,MAXIT,METHOD,IXVC,
     $               IHIT
      DIMENSION THETA(*)
C
      WRITE (IOUT,1)
1     FORMAT ('0INITIAL CONDITIONS'/
     $        '    PARAMETER',27X,'LOWER BOUND      INITIAL EST',
     $        6X,'UPPER BOUND',5X,'IN STEP FACT',7X,'STATUS')
      DO 10 I=1,NT
      ISTI = ISTIN(I)
10    WRITE (IOUT,11) I,LABEL(I),THL(I),THETA(I),THU(I),STPIN(I),
     $                STATUS(ISTI)
11    FORMAT ('    ',I2,2X,A28,2X,4G17.8,3X,A16)
      IF (LPRT .GT. 0) WRITE (IOUT,12) F
12    FORMAT ('    INITIAL FUNCTION VALUE',E18.10)
      WRITE (IOUT,13)
13    FORMAT (' ',32('----'))
      RETURN
C
      END
      SUBROUTINE LBV(THETA,F,LIN)
C
C--LIST (IN IOUT) INITIAL CONDITIONS FOR NEWTON-RAPHSON OR VARIABLE 
C--METRIC METHOD 
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      PARAMETER (NP=45)
      CHARACTER*28 LABEL
      CHARACTER*36 STATUS
      COMMON /MAXFLB/ LABEL(NP)
      COMMON /MAXFST/ STATUS(10)
      COMMON /MAXFOP/ IOUT,IDET,LPRT
      COMMON /MAXF1/ THIN(NP),THL(NP),THU(NP),STPIN(NP),EPSD,YOTA,EPST,
     $               EPSC1,EPSC2,EPSC3,ISTIN(NP),NT,MAXIT,METHOD,IXVC,
     $               IHIT
      DIMENSION THETA(*)
C
      WRITE (IOUT,1)
1     FORMAT ('0INITIAL CONDITIONS'/
     $        '    PARAMETER',27X,'LOWER BOUND      INITIAL EST',
     $        6X,'UPPER BOUND',7X,'STATUS')
      DO 10 I=1,NT
      ISTI = ISTIN(I)
10    WRITE (IOUT,11) I,LABEL(I),THL(I),THETA(I),THU(I),STATUS(ISTI)
11    FORMAT ('    ',I2,2X,A28,2X,3G17.8,3X,A16)
      IF (LIN .GT. 0 .AND. LPRT .GT. 0) WRITE (IOUT,12) F
12    FORMAT ('    INITIAL FUNCTION VALUE',E18.10)
      WRITE (IOUT,13)
13    FORMAT (' ',32('----'))
      RETURN
C
      END
      SUBROUTINE LITD(THETA,F,NFE)
C
C--LIST (IN IDET) DETAILS OF ONE DIRECT-SEARCH ITERATION
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      PARAMETER (NP=45,NPV=45)
      COMMON /MAXFOP/ IOUT,IDET,LPRT
      COMMON /MAXF1/ THIN(NP),THL(NP),THU(NP),STPIN(NP),EPSD,YOTA,EPST,
     $               EPSC1,EPSC2,EPSC3,ISTIN(NP),NT,MAXIT,METHOD,IXVC,
     $               IHIT
      COMMON /MAXF2/ THPR(NP),CTH(NP),STP(NP),G(NPV),H(NPV,NPV),
     $               V(NPV,NPV),AV(NP,NP),STDE(NP),ULT(NPV,NPV),
     $               DIAG(NPV),PDIR(NPV),ERM,FPR,FCH,DIFMAX,GTG,PTG,
     $               TSTEP,IST(NP),NE,ND,NI,NB,NV,IMPBND,IT,NSURF2,IGFL,
     $               IVFL,IGAGE,IVAGE,IDIF
      DIMENSION THETA(*)
C
      WRITE (IDET,1) IT
1     FORMAT (' ITERATION',I5/
     $        '    PARAMETER',4X,'STEP FACT',14X,'OLD',14X,
     $        'NEW',11X,'CHANGE')
      DO 10 I=1,NT
10    WRITE (IDET,11) I,STP(I),THPR(I),THETA(I),CTH(I)
11    FORMAT ('    ',I2,7X,3G17.8,E17.4)
      WRITE (IDET,12) ERM,FPR,F,FCH,DIFMAX,NFE
12    FORMAT ('    MAX ABSOLUTE CHANGE',E18.10/
     $        '    OLD FUNCTN VALUE',E18.10,
     $        '  NEW FUNCTN VALUE',E18.10,'  CHANGE',E18.10,
     $        '  MAX F DIF',E18.10/
     $        '    NUMBER OF FUNCTION EVALUATIONS',I5/
     $        ' ',32('----'))
      RETURN
C
      END
      SUBROUTINE LITV(THETA,F,NFE)
C
C--LIST (IN IDET) DETAILS OF ONE NEWTON-RAPHSON OR VARIABLE METRIC
C--ITERATION
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      PARAMETER (NP=45,NPV=45)
      COMMON /MAXFOP/ IOUT,IDET,LPRT
      COMMON /MAXF1/ THIN(NP),THL(NP),THU(NP),STPIN(NP),EPSD,YOTA,EPST,
     $               EPSC1,EPSC2,EPSC3,ISTIN(NP),NT,MAXIT,METHOD,IXVC,
     $               IHIT
      COMMON /MAXF2/ THPR(NP),CTH(NP),STP(NP),G(NPV),H(NPV,NPV),
     $               V(NPV,NPV),AV(NP,NP),STDE(NP),ULT(NPV,NPV),
     $               DIAG(NPV),PDIR(NPV),ERM,FPR,FCH,DIFMAX,GTG,PTG,
     $               TSTEP,IST(NP),NE,ND,NI,NB,NV,IMPBND,IT,NSURF2,IGFL,
     $               IVFL,IGAGE,IVAGE,IDIF
      DIMENSION THETA(*)
C
      WRITE (IDET,1) IT
1     FORMAT (' ITERATION',I5/
     $        '    PARAMETER',5X,'GRADIENT',7X,'SEARCH DIR',14X,'OLD',
     $        14X,'NEW',11X,'CHANGE')
      L = 0
      DO 20 I=1,NT
      IF (IST(I) .GT. 2) GO TO 10
      L = L + 1
      WRITE (IDET,2) I,G(L),PDIR(L),THPR(I),THETA(I),CTH(I)
2     FORMAT ('    ',I2,7X,2E17.8,2G17.8,E17.4)
      GO TO 20
10    WRITE (IDET,11) I,THPR(I),THETA(I),CTH(I)
11    FORMAT ('    ',I2,7X,2('   --------------'),2G17.8,E17.4)
20    CONTINUE
      WRITE (IDET,21) GTG,PTG,TSTEP,ERM,FPR,F,FCH,NFE
21    FORMAT ('    NORM OF G',E18.10,'  P''G',E18.10,
     $        '  STEP SIZE',E18.10,'  MAX ABSOLUTE CHANGE',E18.10/
     $        '    OLD FUNCTION VALUE',E18.10,
     $        '  NEW FUNCTION VALUE',E18.10,'  CHANGE',E18.10/
     $        '    NUMBER OF FUNCTION EVALUATIONS',I5/
     $        ' ',32('----'))
      RETURN
C
      END
      SUBROUTINE LF(THETA,F,NFE)
C
C--LIST (IN IOUT) FINAL CONDITIONS
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      PARAMETER (NP=45,NPV=45)
      CHARACTER*28 LABEL
      CHARACTER*36 STATUS
      CHARACTER*1 STAR
      CHARACTER*16 CSE,CG,UNDEF
      COMMON /MAXFLB/ LABEL(NP)
      COMMON /MAXFST/ STATUS(10)
      COMMON /MAXFOP/ IOUT,IDET,LPRT
      COMMON /MAXF1/ THIN(NP),THL(NP),THU(NP),STPIN(NP),EPSD,YOTA,EPST,
     $               EPSC1,EPSC2,EPSC3,ISTIN(NP),NT,MAXIT,METHOD,IXVC,
     $               IHIT
      COMMON /MAXF2/ THPR(NP),CTH(NP),STP(NP),G(NPV),H(NPV,NPV),
     $               V(NPV,NPV),AV(NP,NP),STDE(NP),ULT(NPV,NPV),
     $               DIAG(NPV),PDIR(NPV),ERM,FPR,FCH,DIFMAX,GTG,PTG,
     $               TSTEP,IST(NP),NE,ND,NI,NB,NV,IMPBND,IT,NSURF2,IGFL,
     $               IVFL,IGAGE,IVAGE,IDIF
      DIMENSION THETA(*)
      DATA UNDEF /'  ----------    '/
C
      WRITE (IOUT,1)
1     FORMAT ('0FINAL CONDITIONS'/
     $        '    PARAMETER',29X,'FINAL EST',10X,'STD DEV',
     $        6X,'FIRST DERIV',7X,'STATUS')
C
      L = 0
      DO 10 I=1,NT
      STAR = ' '
      ISTI = IST(I)
      IF (ISTI .LE. 2) L = L + 1
C
      IF (IVFL .LE. 2) THEN
         SEI = STDE(I)
         WRITE (CSE,2) SEI
2        FORMAT (G16.8)
         IF (SEI .LT. 0.D0) STAR = '*'
      ELSE
         CSE = UNDEF
      END IF
C
      IF (IGAGE .EQ. 0 .AND. ISTI .LE. 2) THEN
         WRITE (CG,3) G(L)
3        FORMAT (F12.8,'    ')
      ELSE
         CG = UNDEF
      END IF
C
10    WRITE (IOUT,11) I,LABEL(I),THETA(I),CSE,STAR,CG,STATUS(ISTI)
11    FORMAT ('    ',I2,2X,A28,2X,G17.8,1X,A16,A1,A16,3X,A36)
C
      IF (LPRT .GT. 0) WRITE (IOUT,12) F
12    FORMAT ('    FINAL FUNCTION VALUE', E18.10)
      WRITE (IOUT,13) NFE
13    FORMAT ('    NUMBER OF FUNCTION EVALUATIONS',I5)
C
      IF (IMPBND .GT. 0) WRITE (IOUT,14)
14    FORMAT ('   !WARNING:  ITERATION STOPPED AT OR NEAR BOUND OF ',
     $        'DEPENDENT PARAMETER OR IMPLIED BOUNDARY;'/
     $        '   !FUNCTION NOT NECESSARILY AT A LOCAL MAXIMUM') 
C
      IF (IVFL .EQ. 2) WRITE (IOUT,15)
15    FORMAT ('   *NEGATIVE VALUE IN S. D. COLUMN IS COMPUTED ',
     $        '"VARIANCE"')
      WRITE (IOUT,16)
16    FORMAT (2(/' ',32('----')))
      RETURN
C
      END
      SUBROUTINE DEPAR(TR,LEX)
C
C--SUBROUTINE TO COMPUTE VALUES OF DEPENDENT PARAMETERS, IF ANY,
C--AND CHECK ON ANY OTHER RESTRICTIONS ON PARAMETER COMBINATION
C
C--RETURNS FLAG LEX:
C--   0:  NO PROBLEM
C--   1:  INVALID PARAMETER COMBINATION
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      PARAMETER (NP=45)
      COMMON /MAXF1/ THIN(NP),THL(NP),THU(NP),STPIN(NP),EPSD,YOTA,EPST,
     $               EPSC1,EPSC2,EPSC3,ISTIN(NP),NT,MAXIT,METHOD,IXVC,
     $               IHIT
      DIMENSION TR(*)
C
C--COMPUTE DEPENDENT PARAMETER VALUES; TAKE ERROR EXIT IF CAN'T
C
C     IF (<CAN'T BE COMPUTED>) GO TO 10
C     TR(<WHICHEVER>) = <WHATEVER>
C
C--CHECK THAT DEPENDENT PARAMETER VALUES ARE WITHIN BOUNDS
C
C     IF (TR(<WHICHEVER>) .LT. THL(<WHICHEVER>) .OR.
C    $    TR(<WHICHEVER>) .GT. THU(<WHICHEVER>)) GO TO 10
C
C--CHECK ON ANY OTHER RESTRICTIONS
C
C     IF (<PARAMETER COMBINATION INVALID>) GO TO 10
C
C--NORMAL RETURN
C
      LEX = 0
      RETURN
C
C--ERROR RETURN
C
10    LEX = 1
      RETURN
C
      END
      BLOCK DATA MAXFBD
C
C--INITIALIZE CERTAIN COMMON VALUES
C
      PARAMETER (NP=45)
      CHARACTER*28 LABEL
      CHARACTER*36 STATUS
      COMMON /MAXFOP/ IOUT,IDET,LPRT
      COMMON /MAXFLB/ LABEL(NP)
      COMMON /MAXFST/ STATUS(10)
      DATA IOUT /21/, IDET /0/, LPRT /1/,
     $     STATUS(1) /'IND-FN, MAY VARY'/,
     $     STATUS(2) /'IND, MAY VARY'/,
     $     STATUS(3) /'DEPENDENT'/,
     $     STATUS(4) /'FIXED EXTERNALLY'/,
     $     STATUS(5) /'IND-FN, FIXED BY MAXFUN AT BOUND'/,
     $     STATUS(6) /'IND, FIXED BY MAXFUN AT BOUND'/,
     $     STATUS(7) /'IND-FN, FIXED BY MAXFUN NEAR BOUND'/,
     $     STATUS(8) /'IND, FIXED BY MAXFUN NEAR BOUND'/,
     $     STATUS(9) /'IND-FN, FIXED BY MAXFUN NOT NEAR BND'/,
     $     STATUS(10) /'IND, FIXED BY MAXFUN NOT NEAR BOUND'/,
     $     LABEL /NP*' '/
C
      END
      SUBROUTINE COPYR(POUT)
C
C  COPYR VERSION 2.0:
C  SUBROUTINE TO WRITE COPYRIGHT MESSAGE TO SPECIFIED OUTPUT FILE
C
C  ALEXA J. M. SORANT AND ALEXANDER F. WILSON 1-APR-1994
C
      INTEGER POUT
C
      WRITE (POUT,1)
1     FORMAT (' COPYRIGHT (C) 1994 BY R. C. ELSTON, INC.')
      RETURN
C
      END
