	program THREELOCARP

*
*	Three locus MLS program for analysing 
*       affected relative pair linkage data
*	USES MAXFUN  NOT NAG SUBROUTINES 
*	Implemented using general three locus model (see  Cordell et al.
*	1999 (in preparation) for details
*
*	Based on program TWOLOC (see Farrall
*       	Genetic Epidemiology March 1996) 
*
*

      	IMPLICIT DOUBLE PRECISION(A-H,O-Z)

	PARAMETER (NP=45,NPV=45)

c
	double precision popprev, wt(900,3,3,3), 
     + alpha(900,3,3,3) 

	integer option, nfam

	common/mainblock/popprev, wt, alpha, option, nfam

	double precision zz(900, 3,3,3),
     +  vadd(3), vdom(3), vaddadd12, vaddadd13, vaddadd23,
     + vdomdom12, vdomdom13, vdomdom23, vadddom12, 
     + vadddom13,vadddom23,
     +vdomadd12, vdomadd13, vdomadd23, vaddaddadd,
     + vaddadddom, vadddomadd,
     +vdomaddadd, vdomdomadd, vdomadddom, vadddomdom, 
     + vdomdomdom,
     +  lsib, lrelf, lamstar,
     + kp, ls, lo, lmz


c
      COMMON /MAXFLB/ LABEL(NP)
      COMMON /MAXFOP/ IOUT,IDET,LPRT
      COMMON /MAXF1/ THIN(NP),THL(NP),THU(NP),STPIN(NP),EPSD,YOTA,EPST,
     $               EPSC1,EPSC2,EPSC3,ISTIN(NP),NT,MAXIT,METHOD,IXVC,
     $               IHIT
      COMMON /MAXF2/ THPR(NP),CTH(NP),STP(NP),G(NPV),H(NPV,NPV),
     $               V(NPV,NPV),AV(NP,NP),STDE(NP),ULT(NPV,NPV),
     $               DIAG(NPV),PDIR(NPV),ERM,FPR,FCH,DIFMAX,GTG,PTG,
     $               TSTEP,IST(NP),NE,ND,NI,NB,NV,IMPBND,IT,NSURF2,IGFL,
     $               IVFL,IGAGE,IVAGE,IDIF
	COMMON /XAMP2/ Y(1000), EAIJ(1000,5),PREVTR(11),RND2,CONST,N,K,KPU,
     $                                    KX
      COMMON /MKUND/ KP2,KK
C
C
C Local variables
C
      INTEGER LFL, NFE, nincr, fam, id1, id2, incr, optno
      DIMENSION THETA(26)
	
	double precision fpost(900, 300,3,3,3), fprior(900,300, 3,3,3),
     +lrel(900), posn, finalres(300,10)
c






*       variables for maximalization NAG subroutine E04JAF
        double precision bl(26), bu(26), w(165), x(26), f
        integer ibound, n, ifail, iw(12), liw, lw
*
c        external E04JAF

      EXTERNAL FUNCTION
      EXTERNAL MAXFUN
      EXTERNAL DEPAR1


	write(*,*) ' '
	write(*,*) ' '
	write(*,*) 'THREELOCARP - A program to fit'
	write(*,*) 'a variety of  three-locus susceptibility gene models'
	write(*,*) 'to affected relative pair data.'
	write(*,*) ' '


        write(*,*) 'Please cite Cordell H.J. et al. (2000) '
	write(*,*) 'Multilocus linkage tests'
        write(*,*) 'based on affected relative pairs.' 
	write(*,*) '(Am J Hum Genet 66:1273-1286)'
15	write(*,*) ' '



c18	write(*,*) ' '
c	write(*,*) '1      3-locus general model'
c	write(*,*) '5     3-locus additive model'
c	write(*,*) '9      two-locus model (locus 1 and 2)'
c	write(*,*) '13    3-locus multiplicative model'
c	write(*,*) '  '
c	write(*,*) 'Enter which model you wish to fit :'
c	read(*,*) option
c	if (option .lt. 1 .or. option .gt. 16) then
c	write(*,*) option, ' is not a valid choice, please try again: '
c	go to 18
c	end if



	write(*,*) ' '
	open(8,file = 'threeprior.dat', status = 'old')
	open(9,file = 'threeposterior.dat' , status = 'old')
	open(10,file = 'threemls.out', status = 'unknown')
	read(9,*) popprev
	read(9,*) nfam
	read(9,*) nincr

	write(10,*) ' '
	write(10,*) ' '
	write(10,*) 'THREELOCARP - A program to fit a variety of three-locus'
	write(10,*) 'susceptibility gene models to affected relative pair data'
	write(10,*) ' '
	write(10,*) 'Please cite Cordell H.J. et al. (2000) Multilocus linkage tests'
	write(10,*) 'based on affected relative pairs. (Am J Hum Genet 66:1273-1286 )'
	write(10,*) ' '

c	ACTUALLY nfam IS NUMBER OF AFFECTED PAIRS - MAX 900
c	nincr is number of increments (eg 300 at 1cM intervals) - MAX 300

	do 2 i=1, nfam

c	print*,'fam=',i
c	read in the array of taus from posterior.dat

	do 7 incr=1,nincr 

c	print*,'incr=',incr

	read(9,*) posn, fam, id1, id2, 
     + fpost(i, incr,1,1,1), 
     + fpost(i, incr,1,1,2), fpost(i, incr,1,1,3),
     + fpost(I,incr, 1,2,1), fpost(I,incr, 1,2,2), 
     + fpost(I,incr, 1,2,3),
     + fpost(I,incr, 1,3,1), fpost(I,incr, 1,3,2), 
     + fpost(I,incr, 1,3,3),
     + fpost(I,incr, 2, 1,1), fpost(I,incr, 2, 1,2), 
     + fpost(I,incr, 2, 1,3),
     + fpost(I,incr, 2, 2,1), fpost(I,incr, 2, 2,2), 
     + fpost(I,incr, 2, 2,3),
     + fpost(I,incr, 2, 3,1), fpost(I,incr, 2, 3,2), 
     + fpost(I,incr, 2, 3,3),
     + fpost(I,incr, 3, 1,1), fpost(I,incr, 3, 1,2), 
     + fpost(I,incr, 3, 1,3),
     + fpost(I,incr, 3, 2,1), fpost(I,incr, 3, 2,2), 
     + fpost(I,incr, 3, 2,3),
     + fpost(I,incr, 3, 3,1), fpost(I,incr, 3, 3,2), 
     + fpost(I,incr, 3, 3,3)


* read in the array of alphas from prior.dat

	read(8,*) posn, fam, id1, id2, 
     + fprior(i, incr,1,1,1), 
     + fprior(i, incr,1,1,2), fprior(i, incr,1,1,3),
     + fprior(I,incr, 1,2,1), fprior(I,incr, 1,2,2), 
     + fprior(I,incr, 1,2,3),
     + fprior(I,incr, 1,3,1), fprior(I,incr, 1,3,2), 
     + fprior(I,incr, 1,3,3),
     + fprior(I,incr, 2, 1,1), fprior(I,incr, 2, 1,2), 
     + fprior(I,incr, 2, 1,3),
     + fprior(I,incr, 2, 2,1), fprior(I,incr, 2, 2,2), 
     + fprior(I,incr, 2, 2,3),
     + fprior(I,incr, 2, 3,1), fprior(I,incr, 2, 3,2), 
     + fprior(I,incr, 2, 3,3),
     + fprior(I,incr, 3, 1,1), fprior(I,incr, 3, 1,2), 
     + fprior(I,incr, 3, 1,3),
     + fprior(I,incr, 3, 2,1), fprior(I,incr, 3, 2,2), 
     + fprior(I,incr, 3, 2,3),
     + fprior(I,incr, 3, 3,1), fprior(I,incr, 3, 3,2), 
     + fprior(I,incr, 3, 3,3)


7	continue

2	continue

	write(*,*) ' '
	write(*,*) ' '
	write(*,*) ' '
	write(*,*) ' '
	write(*,*) ' '

	write(*,*) ' '
        write(*,*) 'THREE-LOCUS SIBPAIR LINKAGE ANALYSIS RESULTS'
        write(*,*) ' '

c	if (ifail .ne. -99) write(*,*) 'IFAIL = ', ifail

        write(10,*) ' '
        write(10,*) 'THREE-LOCUS SIBPAIR LINKAGE ANALYSIS RESULTS  '
        write(10,*) ' '
c        if (ifail .ne. -99) write(10,*) 'IFAIL = ', ifail
	write(*,*) ' '
	write(10,*) ' '
	write(*,*) 'Total number of sibpairs in analysis = ', nfam
        write(10,*) 'Total number of sibpairs in analysis = ', nfam
        write(*,*) ' '
        write(10,*) ' '


c	DO WHOLE THING FOR OPTIONS 9,13,5,1
c	DO WHOLE THING ACROSS CHROMOSOME

c	write(*,*) '1      3-locus general model'
c	write(*,*) '5     3-locus additive model'
c	write(*,*) '9      two-locus model (locus 1 and 2)'
c	write(*,*) '13    3-locus multiplicative model'


	do 2001 optno=1,8

	if (optno.eq.1) option=1
	if (optno.eq.2) option=2
	if (optno.eq.3) option=3
	if (optno.eq.4) option=4
	if (optno.eq.5) option=5
	if (optno.eq.6) option=6
	if (optno.eq.7) option=7
	if (optno.eq.8) option=8


	
        write(10,*) ' '
        write(10,*) ' '
	if (option .eq. 6) then
	write(10,*)
     1  'option = 6 -  three locus general model - '
	write (10,*) 'all 26 variance components iterated'
	endif
	if (option .eq. 5) then
	write(10,*)
     1  'option = 5 -  three locus additive model '
	write(10,*) '(includes dominance components)'
	endif
	if (option .eq. 8) then
	write(10,*)
     1  'option = 8 -  two locus general model plus additive locus 3 '
	write(10,*) '(includes dominance components)'
	endif
	if (option .eq. 7) then
	write(10,*)
     1  'option = 7 -  two locus general model plus'
	write(10,*) 'multiplicative locus 3 '
	write(10,*) '(includes dominance components)'
	endif
	if (option .eq. 3) then
	write(10,*)
     1  'option = 3 - two locus general model '
	write(10,*) '(locus 1 and 2 on their own)'
	write(10,*) '(includes dominance components)'
	endif
	if (option .eq. 4) then
	write(10,*)
     1  'option = 4 - three locus multiplicative model '
	write(10,*) '(includes dominance components)'
	endif
	if (option .eq. 1) then
	write(10,*)
     1  'option = 1 - two locus multiplicative model '
	write(10,*) '(locus 1 and 2 on their own)'
	write(10,*) '(includes dominance components)'
	endif
	if (option .eq. 2) then
	write(10,*)
     1  'option = 2 - two locus additive model '
	write(10,*) '(locus 1 and 2 on their own)'
	write(10,*) '(includes dominance components)'
	endif

	do 2000 incr=1,nincr


c       FOR 2-LOCUS MODELS, ONLY DO 1ST INCR
	if (optno.le.3) then
	if (incr.gt.1) then
	finalres(incr,optno)=finalres(1,optno)
	goto 1999
	end if	
	end if


	do 1010 I=1,nfam
	do 1010 j=1,3
	do 1010 k=1,3
	do 1010 l=1,3
	wt(I,j,k,l)=fpost(I,incr,j,k,l)
	alpha(I,j,k,l)=fprior(I,incr,j,k,l)
1010	continue


*	bias weights with prior probability for IBD matrix

 	do 3 i=1,nfam
 	do 3 j=1,3
 	do 3 k=1,3
	do 3 l=1,3
 	if (alpha(I,j,k,l) .gt. 0.0d0) then
 	wt(i,j,k,l) = wt(i,j,k,l)/alpha(I,j,k,l)
 	else
 	wt(i,j,k,l) = 0.0d0
 	end if
3	continue

*	maximum number of interated parameters = 26 for general model
*
*
*	initialize x
*
	do i=1,26
	x(i) = 0.001d0
	end do


	if ((option .eq. 1).or.(option.eq.2)) then
	n = 4
	else
	if ((option .eq. 5) .or. (option .eq. 4)) then
	n = 6
	else
	if (option .eq. 3) then
	n = 8
	else
	if (option .eq. 8 .or. option .eq. 7)  then
	n = 10
	else
	if (option.eq.6) then
	n=26
	end if
	end if
	end if
	end if
	end if
	

	NT=n
	model=option

c	ibound = 3
c	bl(1) = 0.0d0
c	bu(1) = 1.0d0
c	liw = 12
c	lw = 165
c	ifail = 1
c	nfe = 0

	if (option .ne. 20) then
c
C Set up maxfun structures
C See manual for details
      IOUT     = 0
      IDET     = 0
      IXVC     = 0
      METHOD   =1
      
	do i=1,26
      THIN(i) = 0.001
      THL(i)  = 1.0D-16
      THU(i)  = 1.0
      ISTIN(i)= 1
	end do

	THIN(1)=0.001180703655
	THIN(2)= 0.001180703655
	THIN(3)= 0.001180703655
	THIN(4)=0.00166215549
	THIN(5)= 0.00166215549
	THIN(6)= 0.00166215549


      MAXIT= 1000

C Call Maxfun with the function to be evaluated, the function to
C check the bounds of the parameters, the array of initial values,
C an integer for the number of times the function is evaluated,
C and an error return code.
c
c
c	print*,'OK up to call maxfun'
c
      CALL MAXFUN(FUNCTION, DEPAR1, THETA, F, NFE, LFL)
c
c
c
	else
c	call funct1(n,x,f)
	CALL FUNCTION(x, FTR, NFE, LEX)
	endif



*	the population prevalence (kp) has to set to something

        kp = popprev
 
	if (option .eq. 6) then
*	three locus general model
       	 vadd(1) = THETA(1)
        	vadd(2) = THETA(2)
	vadd(3)=THETA(3)
        	vdom(1) = THETA(4)
        	vdom(2) = THETA(5)
	vdom(3)=theta(6)
       	vaddadd12 = THETA(7)
	vaddadd13 = THETA(8)
	vaddadd23 = THETA(9)
	 vadddom12 = THETA(10)
	 vadddom13 = THETA(11)
	 vadddom23 = THETA(12)
     	 vdomadd12 = THETA(13)
	vdomadd13 = THETA(14)
	vdomadd23 = THETA(15)
       	 vdomdom12 = THETA(16)
	 vdomdom13 = THETA(17)
	 vdomdom23 = THETA(18)
	vaddaddadd=THETA(19)
	vaddadddom=THETA(20)
	vadddomadd=THETA(21)
	vdomaddadd=THETA(22)
	vadddomdom=THETA(23)
	vdomadddom=THETA(24)
	vdomdomadd=THETA(25)
	vdomdomdom=THETA(26)


	end if
*


	if (option .eq. 5) then
*	three locus additive model
	vadd(1) = THETA(1)
        	vadd(2) = THETA(2)
	vadd(3)=THETA(3)
        	vdom(1) = THETA(4)
        	vdom(2) = THETA(5)
	vdom(3)=THETA(6)
       	vaddadd12 = 0
	vaddadd13 = 0
	vaddadd23 =0
	 vadddom12 = 0
	 vadddom13 = 0
	 vadddom23 = 0
     	 vdomadd12 = 0
	vdomadd13 = 0
	vdomadd23 = 0
       	 vdomdom12 = 0
	 vdomdom13 = 0
	 vdomdom23 = 0
	vaddaddadd=0
	vaddadddom=0
	vadddomadd=0
	vdomaddadd=0
	vadddomdom=0
	vdomadddom=0
	vdomdomadd=0
	vdomdomdom=0

	end if
 
	if (option .eq. 2) then
*	two locus additive model
	vadd(1) = THETA(1)
        	vadd(2) = THETA(2)
	vadd(3)=0
        	vdom(1) = THETA(3)
        	vdom(2) = THETA(4)
	vdom(3)=0
       	vaddadd12 = 0
	vaddadd13 = 0
	vaddadd23 =0
	 vadddom12 = 0
	 vadddom13 = 0
	 vadddom23 = 0
     	 vdomadd12 = 0
	vdomadd13 = 0
	vdomadd23 = 0
       	 vdomdom12 = 0
	 vdomdom13 = 0
	 vdomdom23 = 0
	vaddaddadd=0
	vaddadddom=0
	vadddomadd=0
	vdomaddadd=0
	vadddomdom=0
	vdomadddom=0
	vdomdomadd=0
	vdomdomdom=0

	end if

*
*
        if (option .eq. 3) then
*       locus 1 and 2, general model
	vadd(1) = THETA(1)
        	vadd(2) = THETA(2)
	vadd(3)=0
        	vdom(1) = THETA(3)
        	vdom(2) = THETA(4)
	vdom(3)=0
       	vaddadd12 = THETA(5)
	vaddadd13 = 0
	vaddadd23 =0
	 vadddom12 =THETA(6)
	 vadddom13 = 0
	 vadddom23 = 0
     	 vdomadd12 = THETA(7)
	vdomadd13 = 0
	vdomadd23 = 0
       	 vdomdom12 = THETA(8)
	 vdomdom13 = 0
	 vdomdom23 = 0
	vaddaddadd=0
	vaddadddom=0
	vadddomadd=0
	vdomaddadd=0
	vadddomdom=0
	vdomadddom=0
	vdomdomadd=0
	vdomdomdom=0
        end if

        if (option .eq. 8) then
*       gen locus 1 and 2, add loc 3
	vadd(1) = THETA(1)
        	vadd(2) = THETA(2)
	vadd(3)=THETA(9)
        	vdom(1) = THETA(3)
        	vdom(2) = THETA(4)
	vdom(3)=THETA(10)
       	vaddadd12 = THETA(5)
	vaddadd13 = 0
	vaddadd23 =0
	 vadddom12 =THETA(6)
	 vadddom13 = 0
	 vadddom23 = 0
     	 vdomadd12 = THETA(7)
	vdomadd13 = 0
	vdomadd23 = 0
       	 vdomdom12 = THETA(8)
	 vdomdom13 = 0
	 vdomdom23 = 0
	vaddaddadd=0
	vaddadddom=0
	vadddomadd=0
	vdomaddadd=0
	vadddomdom=0
	vdomadddom=0
	vdomdomadd=0
	vdomdomdom=0
        end if

*
	if (option .eq. 7) then
*	gen loc 1 and 2, mul loc 3
	vadd(1) = THETA(1)
        	vadd(2) = THETA(2)
	vadd(3)=THETA(3)
        	vdom(1) = THETA(4)
        	vdom(2) = THETA(5)
	vdom(3)=THETA(6)
       	vaddadd12 = THETA(7)
	vaddadd13 = vadd(1)*vadd(3)/(kp**2)
	vaddadd23 = vadd(2)*vadd(3)/(kp**2)
	 vadddom12 = THETA(8)
	 vadddom13 = vadd(1)*vdom(3)/(kp**2)
	 vadddom23 = vadd(2)*vdom(3)/(kp**2)
     	 vdomadd12 = THETA(9)
	vdomadd13 = vdom(1)*vadd(3)/(kp**2)
	vdomadd23 = vdom(2)*vadd(3)/(kp**2)
       	 vdomdom12 = THETA(10)
	 vdomdom13 = vdom(1)*vdom(3)/(kp**2)
	 vdomdom23 = vdom(2)*vdom(3)/(kp**2)
	vaddaddadd= THETA(7)*vadd(3)/(kp**2)
	vaddadddom= THETA(7)*vdom(3)/(kp**2)
	vadddomadd= THETA(8)*vadd(3)/(kp**2)
	vdomaddadd= THETA(9)*vadd(3)/(kp**2)
	vadddomdom= THETA(8)*vdom(3)/(kp**2)
	vdomadddom= THETA(9)*vdom(3)/(kp**2)
	vdomdomadd= THETA(10)*vadd(3)/(kp**2)
	vdomdomdom= THETA(10)*vdom(3)/(kp**2)

        end if

*
	if (option .eq. 4) then
*	three locus multiplicative
	vadd(1) = THETA(1)
        	vadd(2) = THETA(2)
	vadd(3)=THETA(3)
        	vdom(1) = THETA(4)
        	vdom(2) = THETA(5)
	vdom(3)=THETA(6)
       	vaddadd12 = vadd(1)*vadd(2)/(kp**2)
	vaddadd13 = vadd(1)*vadd(3)/(kp**2)
	vaddadd23 = vadd(2)*vadd(3)/(kp**2)
	 vadddom12 = vadd(1)*vdom(2)/(kp**2)
	 vadddom13 = vadd(1)*vdom(3)/(kp**2)
	 vadddom23 = vadd(2)*vdom(3)/(kp**2)
     	 vdomadd12 = vdom(1)*vadd(2)/(kp**2)
	vdomadd13 = vdom(1)*vadd(3)/(kp**2)
	vdomadd23 = vdom(2)*vadd(3)/(kp**2)
       	 vdomdom12 = vdom(1)*vdom(2)/(kp**2)
	 vdomdom13 = vdom(1)*vdom(3)/(kp**2)
	 vdomdom23 = vdom(2)*vdom(3)/(kp**2)
	vaddaddadd= vadd(1)*vadd(2)*vadd(3)/(kp**4)
	vaddadddom= vadd(1)*vadd(2)*vdom(3)/(kp**4)
	vadddomadd= vadd(1)*vdom(2)*vadd(3)/(kp**4)
	vdomaddadd= vdom(1)*vadd(2)*vadd(3)/(kp**4)
	vadddomdom= vadd(1)*vdom(2)*vdom(3)/(kp**4)
	vdomadddom= vdom(1)*vadd(2)*vdom(3)/(kp**4)
	vdomdomadd= vdom(1)*vdom(2)*vadd(3)/(kp**4)
	vdomdomdom= vdom(1)*vdom(2)*vdom(3)/(kp**4)

        end if

*
	if (option .eq. 1) then
*	two locus multiplicative
	vadd(1) = THETA(1)
        	vadd(2) = THETA(2)
	vadd(3)=0
        	vdom(1) = THETA(3)
        	vdom(2) = THETA(4)
	vdom(3)=0
       	vaddadd12 = vadd(1)*vadd(2)/(kp**2)
	vaddadd13 = vadd(1)*vadd(3)/(kp**2)
	vaddadd23 = vadd(2)*vadd(3)/(kp**2)
	 vadddom12 = vadd(1)*vdom(2)/(kp**2)
	 vadddom13 = vadd(1)*vdom(3)/(kp**2)
	 vadddom23 = vadd(2)*vdom(3)/(kp**2)
     	 vdomadd12 = vdom(1)*vadd(2)/(kp**2)
	vdomadd13 = vdom(1)*vadd(3)/(kp**2)
	vdomadd23 = vdom(2)*vadd(3)/(kp**2)
       	 vdomdom12 = vdom(1)*vdom(2)/(kp**2)
	 vdomdom13 = vdom(1)*vdom(3)/(kp**2)
	 vdomdom23 = vdom(2)*vdom(3)/(kp**2)
	vaddaddadd= vadd(1)*vadd(2)*vadd(3)/(kp**4)
	vaddadddom= vadd(1)*vadd(2)*vdom(3)/(kp**4)
	vadddomadd= vadd(1)*vdom(2)*vadd(3)/(kp**4)
	vdomaddadd= vdom(1)*vadd(2)*vadd(3)/(kp**4)
	vadddomdom= vadd(1)*vdom(2)*vdom(3)/(kp**4)
	vdomadddom= vdom(1)*vadd(2)*vdom(3)/(kp**4)
	vdomdomadd= vdom(1)*vdom(2)*vadd(3)/(kp**4)
	vdomdomdom= vdom(1)*vdom(2)*vdom(3)/(kp**4)

        end if

c        write(10,*) 'Variance Components/K^2 are:'
c        write(10,*) ' '
c        write(10,*) 'vadd1=', vadd(1)/(kp**2)
c        write(10,*) 'vadd2=', vadd(2)/(kp**2)
c        write(10,*) 'vadd3=', vadd(3)/(kp**2)
c        write(10,*) 'vdom1=', vdom(1)/(kp**2)
c        write(10,*) 'vdom2=', vdom(2)/(kp**2)
c        write(10,*) 'vdom3=', vdom(3)/(kp**2)
c        write(10,*) 'vaddadd12=', vaddadd12/(kp**2)
c        write(10,*) 'vaddadd13=', vaddadd13/(kp**2)
c        write(10,*) 'vaddadd23=', vaddadd23/(kp**2) 
c        write(10,*) 'vadddom12=', vadddom12/(kp**2)
c        write(10,*) 'vadddom13=', vadddom13/(kp**2)
c        write(10,*) 'vadddom23=', vadddom23/(kp**2) 
c        write(10,*) 'vdomadd12=', vdomadd12/(kp**2) 
c        write(10,*) 'vdomadd13=', vdomadd13/(kp**2) 
c        write(10,*) 'vdomadd23=', vdomadd23/(kp**2) 
c        write(10,*) 'vdomdom12=', vdomdom12/(kp**2) 
c        write(10,*) 'vdomdom13=', vdomdom13/(kp**2)
c        write(10,*) 'vdomdom23=', vdomdom23/(kp**2) 
c        write(10,*) 'vaddaddadd=',vaddaddadd/(kp**2)
c        write(10,*) 'vaddadddom=', vaddadddom/(kp**2)
c        write(10,*) 'vadddomadd=', vadddomadd/(kp**2)
c        write(10,*) 'vdomaddadd=', vdomaddadd/(kp**2)
c        write(10,*) 'vadddomdom=', vadddomdom/(kp**2)
c        write(10,*) 'vdomadddom=', vdomadddom/(kp**2)
c        write(10,*) 'vdomdomadd=', vdomdomadd/(kp**2)
c        write(10,*) 'vdomdomdom=', vdomdomdom/(kp**2)
c        write(10,*) ' ' 




c	THIS BELOW WOULD BE JUST FOR 1st Affected pair
c
	if (option .le. 16.0d0 .or. option .eq. 20) then
		lrel(1) = lrelf(1,alpha, kp, vadd, 
     + vdom, vaddadd12, vaddadd13, vaddadd23,
     + vdomdom12, vdomdom13, vdomdom23, 
     + vadddom12, vadddom13,vadddom23,
     +vdomadd12, vdomadd13, vdomadd23, 
     + vaddaddadd,vaddadddom, vadddomadd,
     +vdomaddadd, vdomdomadd, vdomadddom, 
     + vadddomdom, vdomdomdom)
	zz(1,1,1,1) = alpha(1,1,1,1) * 
     + 1.0d0 / lrel(1)
	zz(1,1,1,2)=alpha(1,1,1,2)*
     + lamstar(0,0,1, kp, vadd, vdom, 
     + vaddadd12, vaddadd13, vaddadd23,
     + vdomdom12, vdomdom13, vdomdom23, 
     + vadddom12, vadddom13,vadddom23,
     +vdomadd12, vdomadd13, vdomadd23, 
     + vaddaddadd,vaddadddom, vadddomadd,
     +vdomaddadd, vdomdomadd, vdomadddom, 
     + vadddomdom, vdomdomdom)/lrel(1)
	zz(1,1,1,3)=alpha(1,1,1,3)*
     + lamstar(0,0,2,kp, vadd, vdom, 
     + vaddadd12, vaddadd13, vaddadd23,
     + vdomdom12, vdomdom13, vdomdom23, vadddom12, 
     + vadddom13,vadddom23,
     +vdomadd12, vdomadd13, vdomadd23, 
     + vaddaddadd,vaddadddom, vadddomadd,
     +vdomaddadd, vdomdomadd, vdomadddom, 
     + vadddomdom, vdomdomdom)/lrel(1)
	zz(1,1,2,1)=alpha(1,1,2,1)*
     + lamstar(0,1,0,kp, vadd, vdom, 
     + vaddadd12, vaddadd13, vaddadd23,
     + vdomdom12, vdomdom13, vdomdom23, 
     + vadddom12, vadddom13,vadddom23,
     +vdomadd12, vdomadd13, vdomadd23, 
     + vaddaddadd,vaddadddom, vadddomadd,
     +vdomaddadd, vdomdomadd, vdomadddom, 
     + vadddomdom, vdomdomdom)/lrel(1)
	zz(1,1,2,2)=alpha(1,1,2,2)*
     + lamstar(0,1,1,kp, vadd, vdom, 
     + vaddadd12, vaddadd13, vaddadd23,
     + vdomdom12, vdomdom13, vdomdom23, 
     + vadddom12, vadddom13,vadddom23,
     +vdomadd12, vdomadd13, vdomadd23, 
     + vaddaddadd,vaddadddom, vadddomadd,
     +vdomaddadd, vdomdomadd, vdomadddom, 
     + vadddomdom, vdomdomdom)/lrel(1)
	zz(1,1,2,3)=alpha(1,1,2,3)*
     + lamstar(0,1,2,kp, vadd, vdom, 
     + vaddadd12, vaddadd13, vaddadd23,
     + vdomdom12, vdomdom13, vdomdom23, 
     + vadddom12, vadddom13,vadddom23,
     +vdomadd12, vdomadd13, vdomadd23, 
     + vaddaddadd,vaddadddom, vadddomadd,
     +vdomaddadd, vdomdomadd, vdomadddom, 
     + vadddomdom, vdomdomdom)/lrel(1)
	zz(1,1,3,1)=alpha(1,1,3,1)*
     + lamstar(0,2,0,kp, vadd, vdom, 
     + vaddadd12, vaddadd13, vaddadd23,
     + vdomdom12, vdomdom13, vdomdom23, 
     + vadddom12, vadddom13,vadddom23,
     +vdomadd12, vdomadd13, vdomadd23, 
     + vaddaddadd,vaddadddom, vadddomadd,
     +vdomaddadd, vdomdomadd, vdomadddom, 
     + vadddomdom, vdomdomdom)/lrel(1)
	zz(1,1,3,2)=alpha(1,1,3,2)*
     + lamstar(0,2,1,kp, vadd, vdom, 
     + vaddadd12, vaddadd13, vaddadd23,
     + vdomdom12, vdomdom13, vdomdom23, 
     + vadddom12, vadddom13,vadddom23,
     +vdomadd12, vdomadd13, vdomadd23, 
     + vaddaddadd,vaddadddom, vadddomadd,
     +vdomaddadd, vdomdomadd, vdomadddom, 
     + vadddomdom, vdomdomdom)/lrel(1)
	zz(1,1,3,3)=alpha(1,1,3,3)*
     + lamstar(0,2,2,kp, vadd, vdom, 
     + vaddadd12, vaddadd13, vaddadd23,
     + vdomdom12, vdomdom13, vdomdom23, 
     + vadddom12, vadddom13,vadddom23,
     +vdomadd12, vdomadd13, vdomadd23, 
     + vaddaddadd,vaddadddom, vadddomadd,
     +vdomaddadd, vdomdomadd, vdomadddom, 
     + vadddomdom, vdomdomdom)/lrel(1)


	zz(1,2,1,1) = alpha(1,2,1,1) * 
     + lamstar(1,0,0,kp, vadd, 
     + vdom, vaddadd12, vaddadd13, vaddadd23,
     + vdomdom12, vdomdom13, vdomdom23, 
     + vadddom12, vadddom13,vadddom23,
     +vdomadd12, vdomadd13, vdomadd23, 
     + vaddaddadd,vaddadddom, vadddomadd,
     +vdomaddadd, vdomdomadd, vdomadddom, 
     + vadddomdom, vdomdomdom)/lrel(1)
	zz(1,2,1,2)=alpha(1,2,1,2)*
     + lamstar(1,0,1,kp, vadd, vdom, 
     + vaddadd12, vaddadd13, vaddadd23,
     + vdomdom12, vdomdom13, vdomdom23, 
     + vadddom12, vadddom13,vadddom23,
     +vdomadd12, vdomadd13, vdomadd23, 
     + vaddaddadd,vaddadddom, vadddomadd,
     +vdomaddadd, vdomdomadd, vdomadddom, 
     + vadddomdom, vdomdomdom)/lrel(1)
	zz(1,2,1,3)=alpha(1,2,1,3)*
     + lamstar(1,0,2,kp, vadd, vdom, 
     + vaddadd12, vaddadd13, vaddadd23,
     + vdomdom12, vdomdom13, vdomdom23, 
     + vadddom12, vadddom13,vadddom23,
     +vdomadd12, vdomadd13, vdomadd23, 
     + vaddaddadd,vaddadddom, vadddomadd,
     +vdomaddadd, vdomdomadd, vdomadddom, 
     + vadddomdom, vdomdomdom)/lrel(1)
	zz(1,2,2,1)=alpha(1,2,2,1)*
     + lamstar(1,1,0,kp, vadd, vdom, 
     + vaddadd12, vaddadd13, vaddadd23,
     + vdomdom12, vdomdom13, vdomdom23, 
     + vadddom12, vadddom13,vadddom23,
     +vdomadd12, vdomadd13, vdomadd23, 
     + vaddaddadd,vaddadddom, vadddomadd,
     +vdomaddadd, vdomdomadd, vdomadddom, 
     + vadddomdom, vdomdomdom)/lrel(1)
	zz(1,2,2,2)=alpha(1,2,2,2)
     + *lamstar(1,1,1,kp, vadd, vdom, 
     + vaddadd12, vaddadd13, vaddadd23,
     + vdomdom12, vdomdom13, vdomdom23, 
     + vadddom12, vadddom13,vadddom23,
     +vdomadd12, vdomadd13, vdomadd23, 
     + vaddaddadd,vaddadddom, vadddomadd,
     +vdomaddadd, vdomdomadd, vdomadddom, 
     + vadddomdom, vdomdomdom)/lrel(1)
	zz(1,2,2,3)=alpha(1,2,2,3)*
     + lamstar(1,1,2,kp, vadd, vdom, 
     + vaddadd12, vaddadd13, vaddadd23,
     + vdomdom12, vdomdom13, vdomdom23, 
     + vadddom12, vadddom13,vadddom23,
     +vdomadd12, vdomadd13, vdomadd23, 
     + vaddaddadd,vaddadddom, vadddomadd,
     +vdomaddadd, vdomdomadd, vdomadddom, 
     + vadddomdom, vdomdomdom)/lrel(1)
	zz(1,2,3,1)=alpha(1,2,3,1)*
     + lamstar(1,2,0,kp, vadd, vdom, 
     + vaddadd12, vaddadd13, vaddadd23,
     + vdomdom12, vdomdom13, vdomdom23, 
     + vadddom12, vadddom13,vadddom23,
     +vdomadd12, vdomadd13, vdomadd23, 
     + vaddaddadd,vaddadddom, vadddomadd,
     +vdomaddadd, vdomdomadd, vdomadddom, 
     + vadddomdom, vdomdomdom)/lrel(1)
	zz(1,2,3,2)=alpha(1,2,3,2)*
     + lamstar(1,2,1,kp, vadd, vdom, 
     + vaddadd12, vaddadd13, vaddadd23,
     + vdomdom12, vdomdom13, vdomdom23, 
     + vadddom12, vadddom13,vadddom23,
     +vdomadd12, vdomadd13, vdomadd23, 
     + vaddaddadd,vaddadddom, vadddomadd,
     +vdomaddadd, vdomdomadd, vdomadddom, 
     + vadddomdom, vdomdomdom)/lrel(1)
	zz(1,2,3,3)=alpha(1,2,3,3)*
     + lamstar(1,2,2,kp, vadd, vdom, 
     + vaddadd12, vaddadd13, vaddadd23,
     + vdomdom12, vdomdom13, vdomdom23, 
     + vadddom12, vadddom13,vadddom23,
     +vdomadd12, vdomadd13, vdomadd23, 
     + vaddaddadd,vaddadddom, vadddomadd,
     +vdomaddadd, vdomdomadd, vdomadddom, 
     + vadddomdom, vdomdomdom)/lrel(1)

	zz(1,3,1,1) = alpha(1,3,1,1) * 
     + lamstar(2,0,0,kp, vadd, vdom, 
     + vaddadd12, vaddadd13, vaddadd23,
     + vdomdom12, vdomdom13, vdomdom23, 
     + vadddom12, vadddom13,vadddom23,
     +vdomadd12, vdomadd13, vdomadd23, vaddaddadd,
     + vaddadddom, vadddomadd,
     +vdomaddadd, vdomdomadd, vdomadddom, 
     + vadddomdom, vdomdomdom)/lrel(1)
	zz(1,3,1,2)=alpha(1,3,1,2)*
     + lamstar(2,0,1,kp, vadd, vdom, 
     + vaddadd12, vaddadd13, vaddadd23,
     + vdomdom12, vdomdom13, vdomdom23, 
     + vadddom12, vadddom13,vadddom23,
     +vdomadd12, vdomadd13, vdomadd23, 
     + vaddaddadd,vaddadddom, vadddomadd,
     +vdomaddadd, vdomdomadd, vdomadddom, 
     + vadddomdom, vdomdomdom)/lrel(1)
	zz(1,3,1,3)=alpha(1,3,1,3)*
     + lamstar(2,0,2,kp, vadd, vdom, 
     + vaddadd12, vaddadd13, vaddadd23,
     + vdomdom12, vdomdom13, vdomdom23, 
     + vadddom12, vadddom13,vadddom23,
     +vdomadd12, vdomadd13, vdomadd23, 
     + vaddaddadd,vaddadddom, vadddomadd,
     +vdomaddadd, vdomdomadd, vdomadddom, 
     + vadddomdom, vdomdomdom)/lrel(1)
	zz(1,3,2,1)=alpha(1,3,2,1)*
     + lamstar(2,1,0,kp, vadd, vdom, 
     + vaddadd12, vaddadd13, vaddadd23,
     + vdomdom12, vdomdom13, vdomdom23, 
     + vadddom12, vadddom13,vadddom23,
     +vdomadd12, vdomadd13, vdomadd23, 
     + vaddaddadd,vaddadddom, vadddomadd,
     +vdomaddadd, vdomdomadd, vdomadddom, 
     + vadddomdom, vdomdomdom)/lrel(1)
	zz(1,3,2,2)=alpha(1,3,2,2)*
     + lamstar(2,1,1,kp, vadd, vdom, 
     + vaddadd12, vaddadd13, vaddadd23,
     + vdomdom12, vdomdom13, vdomdom23, 
     + vadddom12, vadddom13,vadddom23,
     +vdomadd12, vdomadd13, vdomadd23, 
     + vaddaddadd,vaddadddom, vadddomadd,
     +vdomaddadd, vdomdomadd, vdomadddom, 
     + vadddomdom, vdomdomdom)/lrel(1)
	zz(1,3,2,3)=alpha(1,3,2,3)*
     + lamstar(2,1,2,kp, vadd, vdom, 
     + vaddadd12, vaddadd13, vaddadd23,
     + vdomdom12, vdomdom13, vdomdom23, 
     + vadddom12, vadddom13,vadddom23,
     +vdomadd12, vdomadd13, vdomadd23, 
     + vaddaddadd,vaddadddom, vadddomadd,
     +vdomaddadd, vdomdomadd, vdomadddom, 
     + vadddomdom, vdomdomdom)/lrel(1)
	zz(1,3,3,1)=alpha(1,3,3,1)*
     + lamstar(2,2,0,kp, vadd, vdom, 
     + vaddadd12, vaddadd13, vaddadd23,
     + vdomdom12, vdomdom13, vdomdom23, 
     + vadddom12, vadddom13,vadddom23,
     +vdomadd12, vdomadd13, vdomadd23, 
     + vaddaddadd,vaddadddom, vadddomadd,
     +vdomaddadd, vdomdomadd, vdomadddom, 
     + vadddomdom, vdomdomdom)/lrel(1)
	zz(1,3,3,2)=alpha(1,3,3,2)*
     + lamstar(2,2,1,kp, vadd, vdom, 
     + vaddadd12, vaddadd13, vaddadd23,
     + vdomdom12, vdomdom13, vdomdom23, 
     + vadddom12, vadddom13,vadddom23,
     +vdomadd12, vdomadd13, vdomadd23, 
     + vaddaddadd,vaddadddom, vadddomadd,
     +vdomaddadd, vdomdomadd, vdomadddom, 
     + vadddomdom, vdomdomdom)/lrel(1)
	zz(1,3,3,3)=alpha(1,3,3,3)*
     + lamstar(2,2,2,kp, vadd, vdom, 
     + vaddadd12, vaddadd13, vaddadd23,
     + vdomdom12, vdomdom13, vdomdom23, 
     + vadddom12, vadddom13,vadddom23,
     +vdomadd12, vdomadd13, vdomadd23, 
     + vaddaddadd,vaddadddom, vadddomadd,
     +vdomaddadd, vdomdomadd, vdomadddom, 
     + vadddomdom, vdomdomdom)/lrel(1)

	else
*       multiplicative models
	end if

c	do 32 I=1,3
c	do 32 j=1,3
c	do 32 k=1,3
c	write(10,*) 'I,j,k, z=', I,j,k, zz(1,I,j,k)
c32	continue


        write(*,35) ' Number of function evaluations = ',nfe
        write(*,*) ' '
c        write(10,35) ' Number of function evaluations = ',nfe
c        write(10,*) ' '
35     format(a34,2x,i6)
	write(*,*) ' ' 
36     format(g8.2,7g10.2)
 


40	format(a11,3f14.6)
	write(*,*) 'MLS = ', f
        write(10,46) 'Position= ',incr, ' MLS =  ', f
46	format(a15,2x,i5,a6,2x,f8.3)


	finalres(incr,optno)=f
	finalres(incr,10)=incr	

1000	continue

1999	continue
2000	continue
2001	continue

        write(10,*) ' '
        write(10,*) ' ' 

        write(10,*) 'FINAL MLS RESULTS'
        write(10,*) ' ' 
        write(10,*) 'pos 2mul 2add 2gen 3mul 3add 3gen 2mul3 2add3'
        write(10,*) ' ' 


	do 2010 incr=1,nincr
	
	write(10, 47) finalres(incr,10),  
     + finalres(incr,1),finalres(incr,2),
     +finalres(incr,3), finalres(incr,4),
     +finalres(incr,5), finalres(incr,6),
     +finalres(incr,7), finalres(incr,8)


2010	continue

47	format(9f9.3)

        write(10,*) ' '
        write(10,*) ' ' 

        write(10,*) 'NESTED MLS RESULTS TO BE PLOTTED e.g. IN EXCEL'
        write(10,*) ' ' 
        write(10,*) 'pos 3mu-2mu 3ad-2ad 3ge-2ge 2mu3-2ge 2ad3-2ge'
        write(10,*) ' ' 


	do 2011 incr=1,nincr
	
	write(10, 47) finalres(incr,10),  
     + finalres(incr,4)-finalres(incr,1),
     + finalres(incr,5)-finalres(incr,2),
     + finalres(incr,6)-finalres(incr,3), 
     + finalres(incr,7)-finalres(incr,3), 
     + finalres(incr,8)-finalres(incr,3)


 2011	continue


	close(10)


	stop
	end


	
c	subroutine funct1(n,xc,fc)

	SUBROUTINE FUNCTION(TR, FTR, NFE, LEX)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
C The function to be evaluated:
C  Parameters:  TR  - trial paramters
C               FTR - function value with parameters tr
C               NFE - number of times the function has been evaluated
C               LEX - error code
c

c	COMMON VARIABLES


	double precision popprev, wt(900,3,3,3), 
     + alpha(900,3,3,3)

	integer option, nfam

	common/mainblock/popprev, wt, alpha, option, nfam

c	LOCAL VARIABLES

	double precision zz(900,3,3,3), xc(26), 
     + like, top, bottom, fc,
     +  vadd(3), vdom(3), vaddadd12, 
     + vaddadd13, vaddadd23,
     + vdomdom12, vdomdom13, vdomdom23, vadddom12, 
     + vadddom13,vadddom23,
     +vdomadd12, vdomadd13, vdomadd23, vaddaddadd,
     + vaddadddom, vadddomadd,
     +vdomaddadd, vdomdomadd, vdomadddom, 
     + vadddomdom, vdomdomdom,
     + lamstar,  lsib, lsibf, kp, ls, 
     + lo, lmz, lrel(900), lrelf


	integer n, nf, nfe

	INTEGER I, j, k


	DIMENSION TR(*)
      	EXTERNAL DEPAR1

C 	Check the parameters are valid
      	CALL DEPAR1(TR, LEX)
      	IF (LEX .GT. 0) RETURN

C Calculate function

	FTR=0

	if ((option .eq. 1).or.(option.eq.2)) then
	n = 4
	else
	if ((option .eq. 5) .or. (option .eq. 4)) then
	n = 6
	else
	if (option .eq. 3) then
	n = 8
	else
	if (option .eq. 8 .or. option .eq. 7)  then
	n = 10
	else
	if (option.eq.6) then
	n=26
	end if
	end if
	end if
	end if
	end if


	do 10 I=1,n
	xc(I)=TR(I)
10	continue

*	set population prevalence to something vaguely plausible

	kp = popprev


	if (option .eq. 6) then
*	three locus general model
       	 vadd(1) = XC(1)
        	vadd(2) = XC(2)
	vadd(3)=XC(3)
        	vdom(1) = XC(4)
        	vdom(2) = XC(5)
	vdom(3)=XC(6)
       	vaddadd12 = XC(7)
	vaddadd13 = XC(8)
	vaddadd23 = XC(9)
	 vadddom12 = XC(10)
	 vadddom13 = XC(11)
	 vadddom23 = XC(12)
     	 vdomadd12 = XC(13)
	vdomadd13 = XC(14)
	vdomadd23 = XC(15)
       	 vdomdom12 = XC(16)
	 vdomdom13 = XC(17)
	 vdomdom23 = XC(18)
	vaddaddadd=XC(19)
	vaddadddom=XC(20)
	vadddomadd=XC(21)
	vdomaddadd=XC(22)
	vadddomdom=XC(23)
	vdomadddom=XC(24)
	vdomdomadd=XC(25)
	vdomdomdom=XC(26)


	end if
*


	if (option .eq. 5) then
*	three locus additive model
	vadd(1) = XC(1)
        	vadd(2) = XC(2)
	vadd(3)=XC(3)
        	vdom(1) = XC(4)
        	vdom(2) = XC(5)
	vdom(3)=XC(6)
       	vaddadd12 = 0
	vaddadd13 = 0
	vaddadd23 =0
	 vadddom12 = 0
	 vadddom13 = 0
	 vadddom23 = 0
     	 vdomadd12 = 0
	vdomadd13 = 0
	vdomadd23 = 0
       	 vdomdom12 = 0
	 vdomdom13 = 0
	 vdomdom23 = 0
	vaddaddadd=0
	vaddadddom=0
	vadddomadd=0
	vdomaddadd=0
	vadddomdom=0
	vdomadddom=0
	vdomdomadd=0
	vdomdomdom=0

	end if
 
	if (option .eq. 2) then
*	two locus additive model
	vadd(1) = XC(1)
        	vadd(2) = XC(2)
	vadd(3)=0
        	vdom(1) = XC(3)
        	vdom(2) = XC(4)
	vdom(3)=0
       	vaddadd12 = 0
	vaddadd13 = 0
	vaddadd23 =0
	 vadddom12 = 0
	 vadddom13 = 0
	 vadddom23 = 0
     	 vdomadd12 = 0
	vdomadd13 = 0
	vdomadd23 = 0
       	 vdomdom12 = 0
	 vdomdom13 = 0
	 vdomdom23 = 0
	vaddaddadd=0
	vaddadddom=0
	vadddomadd=0
	vdomaddadd=0
	vadddomdom=0
	vdomadddom=0
	vdomdomadd=0
	vdomdomdom=0

	end if

*
*
        if (option .eq. 3) then
*       locus 1 and 2, general model
	vadd(1) = XC(1)
        	vadd(2) = XC(2)
	vadd(3)=0
        	vdom(1) = XC(3)
        	vdom(2) = XC(4)
	vdom(3)=0
       	vaddadd12 = XC(5)
	vaddadd13 = 0
	vaddadd23 =0
	 vadddom12 =XC(6)
	 vadddom13 = 0
	 vadddom23 = 0
     	 vdomadd12 = XC(7)
	vdomadd13 = 0
	vdomadd23 = 0
       	 vdomdom12 = XC(8)
	 vdomdom13 = 0
	 vdomdom23 = 0
	vaddaddadd=0
	vaddadddom=0
	vadddomadd=0
	vdomaddadd=0
	vadddomdom=0
	vdomadddom=0
	vdomdomadd=0
	vdomdomdom=0
        end if

        if (option .eq. 8) then
*       gen locus 1 and 2, add loc 3
	vadd(1) = XC(1)
        	vadd(2) = XC(2)
	vadd(3)=XC(9)
        	vdom(1) = XC(3)
        	vdom(2) = XC(4)
	vdom(3)=XC(10)
       	vaddadd12 = XC(5)
	vaddadd13 = 0
	vaddadd23 =0
	 vadddom12 =XC(6)
	 vadddom13 = 0
	 vadddom23 = 0
     	 vdomadd12 = XC(7)
	vdomadd13 = 0
	vdomadd23 = 0
       	 vdomdom12 = XC(8)
	 vdomdom13 = 0
	 vdomdom23 = 0
	vaddaddadd=0
	vaddadddom=0
	vadddomadd=0
	vdomaddadd=0
	vadddomdom=0
	vdomadddom=0
	vdomdomadd=0
	vdomdomdom=0
        end if

*
	if (option .eq. 7) then
*	gen loc 1 and 2, mul loc 3
	vadd(1) = XC(1)
        	vadd(2) = XC(2)
	vadd(3)=XC(3)
        	vdom(1) = XC(4)
        	vdom(2) = XC(5)
	vdom(3)=XC(6)
       	vaddadd12 = XC(7)
	vaddadd13 = vadd(1)*vadd(3)/(kp**2)
	vaddadd23 = vadd(2)*vadd(3)/(kp**2)
	 vadddom12 = XC(8)
	 vadddom13 = vadd(1)*vdom(3)/(kp**2)
	 vadddom23 = vadd(2)*vdom(3)/(kp**2)
     	 vdomadd12 = XC(9)
	vdomadd13 = vdom(1)*vadd(3)/(kp**2)
	vdomadd23 = vdom(2)*vadd(3)/(kp**2)
       	 vdomdom12 = XC(10)
	 vdomdom13 = vdom(1)*vdom(3)/(kp**2)
	 vdomdom23 = vdom(2)*vdom(3)/(kp**2)
	vaddaddadd= XC(7)*vadd(3)/(kp**2)
	vaddadddom= XC(7)*vdom(3)/(kp**2)
	vadddomadd= XC(8)*vadd(3)/(kp**2)
	vdomaddadd= XC(9)*vadd(3)/(kp**2)
	vadddomdom= XC(8)*vdom(3)/(kp**2)
	vdomadddom= XC(9)*vdom(3)/(kp**2)
	vdomdomadd= XC(10)*vadd(3)/(kp**2)
	vdomdomdom= XC(10)*vdom(3)/(kp**2)

        end if

*
	if (option .eq. 4) then
*	three locus multiplicative
	vadd(1) = XC(1)
        	vadd(2) = XC(2)
	vadd(3)=XC(3)
        	vdom(1) = XC(4)
        	vdom(2) = XC(5)
	vdom(3)=XC(6)
       	vaddadd12 = vadd(1)*vadd(2)/(kp**2)
	vaddadd13 = vadd(1)*vadd(3)/(kp**2)
	vaddadd23 = vadd(2)*vadd(3)/(kp**2)
	 vadddom12 = vadd(1)*vdom(2)/(kp**2)
	 vadddom13 = vadd(1)*vdom(3)/(kp**2)
	 vadddom23 = vadd(2)*vdom(3)/(kp**2)
     	 vdomadd12 = vdom(1)*vadd(2)/(kp**2)
	vdomadd13 = vdom(1)*vadd(3)/(kp**2)
	vdomadd23 = vdom(2)*vadd(3)/(kp**2)
       	 vdomdom12 = vdom(1)*vdom(2)/(kp**2)
	 vdomdom13 = vdom(1)*vdom(3)/(kp**2)
	 vdomdom23 = vdom(2)*vdom(3)/(kp**2)
	vaddaddadd= vadd(1)*vadd(2)*vadd(3)/(kp**4)
	vaddadddom= vadd(1)*vadd(2)*vdom(3)/(kp**4)
	vadddomadd= vadd(1)*vdom(2)*vadd(3)/(kp**4)
	vdomaddadd= vdom(1)*vadd(2)*vadd(3)/(kp**4)
	vadddomdom= vadd(1)*vdom(2)*vdom(3)/(kp**4)
	vdomadddom= vdom(1)*vadd(2)*vdom(3)/(kp**4)
	vdomdomadd= vdom(1)*vdom(2)*vadd(3)/(kp**4)
	vdomdomdom= vdom(1)*vdom(2)*vdom(3)/(kp**4)

        end if

*
	if (option .eq. 1) then
*	two locus multiplicative
	vadd(1) = XC(1)
        	vadd(2) = XC(2)
	vadd(3)=0
        	vdom(1) = XC(3)
        	vdom(2) = XC(4)
	vdom(3)=0
       	vaddadd12 = vadd(1)*vadd(2)/(kp**2)
	vaddadd13 = vadd(1)*vadd(3)/(kp**2)
	vaddadd23 = vadd(2)*vadd(3)/(kp**2)
	 vadddom12 = vadd(1)*vdom(2)/(kp**2)
	 vadddom13 = vadd(1)*vdom(3)/(kp**2)
	 vadddom23 = vadd(2)*vdom(3)/(kp**2)
     	 vdomadd12 = vdom(1)*vadd(2)/(kp**2)
	vdomadd13 = vdom(1)*vadd(3)/(kp**2)
	vdomadd23 = vdom(2)*vadd(3)/(kp**2)
       	 vdomdom12 = vdom(1)*vdom(2)/(kp**2)
	 vdomdom13 = vdom(1)*vdom(3)/(kp**2)
	 vdomdom23 = vdom(2)*vdom(3)/(kp**2)
	vaddaddadd= vadd(1)*vadd(2)*vadd(3)/(kp**4)
	vaddadddom= vadd(1)*vadd(2)*vdom(3)/(kp**4)
	vadddomadd= vadd(1)*vdom(2)*vadd(3)/(kp**4)
	vdomaddadd= vdom(1)*vadd(2)*vadd(3)/(kp**4)
	vadddomdom= vadd(1)*vdom(2)*vdom(3)/(kp**4)
	vdomadddom= vdom(1)*vadd(2)*vdom(3)/(kp**4)
	vdomdomadd= vdom(1)*vdom(2)*vadd(3)/(kp**4)
	vdomdomdom= vdom(1)*vdom(2)*vdom(3)/(kp**4)

        end if


	
*	
*	compute joint IBD matrix from variance components model


	nfe = nfe + 1
c	write(*,135) ' Number of function evaluations = ',nfe
c	write(*,*) ' '
135	format(a34,2x,i6)

136     format(8g10.2)
        
c	write(*,*)
c     1  '  Vadd(1)   Vadd(2)   Vdom(1)   Vdom(2)   Vaddadd   Vadddom   Vdomadd   Vdomdom'
c	write(*,136)
c     1  vadd(1), vadd(2), vdom(1), vdom(2), vaddadd, vadddom, vdomadd, vdomdom


140     format(a11,4f14.4)
	like=0.0d0
	do 110 nf=1,nfam

c	print*,'pair=',nf
	if (option .le. 16.0d0 .or. option .eq. 20) then
	lrel(nf) = lrelf(nf,alpha, kp, vadd, vdom, 
     + vaddadd12, vaddadd13, vaddadd23,
     + vdomdom12, vdomdom13, vdomdom23, 
     + vadddom12, vadddom13,vadddom23,
     +vdomadd12, vdomadd13, vdomadd23, 
     + vaddaddadd,vaddadddom, vadddomadd,
     +vdomaddadd, vdomdomadd, vdomadddom, 
     + vadddomdom, vdomdomdom)
c	print*,'lrel=',lrel(nf)
	zz(nf,1,1,1) = alpha(nf,1,1,1) * 
     + 1.0d0 / lrel(nf)
	zz(nf,1,1,2)=alpha(nf,1,1,2)*
     + lamstar(0,0,1, kp, vadd, 
     + vdom, vaddadd12, vaddadd13, vaddadd23,
     + vdomdom12, vdomdom13, vdomdom23, 
     + vadddom12, vadddom13,vadddom23,
     +vdomadd12, vdomadd13, vdomadd23, 
     + vaddaddadd,vaddadddom, vadddomadd,
     +vdomaddadd, vdomdomadd, vdomadddom, 
     + vadddomdom, vdomdomdom)/lrel(nf)
	zz(nf,1,1,3)=alpha(nf,1,1,3)*
     + lamstar(0,0,2,kp, vadd, vdom, 
     + vaddadd12, vaddadd13, vaddadd23,
     + vdomdom12, vdomdom13, vdomdom23, 
     + vadddom12, vadddom13,vadddom23,
     +vdomadd12, vdomadd13, vdomadd23, 
     + vaddaddadd,vaddadddom, vadddomadd,
     +vdomaddadd, vdomdomadd, vdomadddom, 
     + vadddomdom, vdomdomdom)/lrel(nf)
	zz(nf,1,2,1)=alpha(nf,1,2,1)*
     + lamstar(0,1,0,kp, vadd, vdom, 
     + vaddadd12, vaddadd13, vaddadd23,
     + vdomdom12, vdomdom13, vdomdom23, 
     + vadddom12, vadddom13,vadddom23,
     +vdomadd12, vdomadd13, vdomadd23, 
     + vaddaddadd,vaddadddom, vadddomadd,
     +vdomaddadd, vdomdomadd, vdomadddom, 
     + vadddomdom, vdomdomdom)/lrel(nf)
	zz(nf,1,2,2)=alpha(nf,1,2,2)*
     + lamstar(0,1,1,kp, vadd, vdom, 
     + vaddadd12, vaddadd13, vaddadd23,
     + vdomdom12, vdomdom13, vdomdom23, 
     + vadddom12, vadddom13,vadddom23,
     +vdomadd12, vdomadd13, vdomadd23, 
     + vaddaddadd,vaddadddom, vadddomadd,
     +vdomaddadd, vdomdomadd, vdomadddom, 
     + vadddomdom, vdomdomdom)/lrel(nf)
	zz(nf,1,2,3)=alpha(nf,1,2,3)*
     + lamstar(0,1,2,kp, vadd, vdom, 
     + vaddadd12, vaddadd13, vaddadd23,
     + vdomdom12, vdomdom13, vdomdom23, 
     + vadddom12, vadddom13,vadddom23,
     +vdomadd12, vdomadd13, vdomadd23, 
     + vaddaddadd,vaddadddom, vadddomadd,
     +vdomaddadd, vdomdomadd, vdomadddom, 
     + vadddomdom, vdomdomdom)/lrel(nf)
	zz(nf,1,3,1)=alpha(nf,1,3,1)*
     + lamstar(0,2,0,kp, vadd, vdom, 
     + vaddadd12, vaddadd13, vaddadd23,
     + vdomdom12, vdomdom13, vdomdom23, 
     + vadddom12, vadddom13,vadddom23,
     +vdomadd12, vdomadd13, vdomadd23, 
     + vaddaddadd,vaddadddom, vadddomadd,
     +vdomaddadd, vdomdomadd, vdomadddom, 
     + vadddomdom, vdomdomdom)/lrel(nf)
	zz(nf,1,3,2)=alpha(nf,1,3,2)*
     + lamstar(0,2,1,kp, vadd, vdom, 
     + vaddadd12, vaddadd13, vaddadd23,
     + vdomdom12, vdomdom13, vdomdom23, 
     + vadddom12, vadddom13,vadddom23,
     +vdomadd12, vdomadd13, vdomadd23, 
     + vaddaddadd,vaddadddom, vadddomadd,
     +vdomaddadd, vdomdomadd, vdomadddom, 
     + vadddomdom, vdomdomdom)/lrel(nf)
	zz(nf,1,3,3)=alpha(nf,1,3,3)*
     + lamstar(0,2,2,kp, vadd, vdom, 
     + vaddadd12, vaddadd13, vaddadd23,
     + vdomdom12, vdomdom13, vdomdom23, 
     + vadddom12, vadddom13,vadddom23,
     +vdomadd12, vdomadd13, vdomadd23, 
     + vaddaddadd,vaddadddom, vadddomadd,
     +vdomaddadd, vdomdomadd, vdomadddom, 
     + vadddomdom, vdomdomdom)/lrel(nf)


	zz(nf,2,1,1) = alpha(nf,2,1,1) * 
     + lamstar(1,0,0,kp, vadd, vdom, 
     + vaddadd12, vaddadd13, vaddadd23,
     + vdomdom12, vdomdom13, vdomdom23, 
     + vadddom12, vadddom13,vadddom23,
     +vdomadd12, vdomadd13, vdomadd23, 
     + vaddaddadd,vaddadddom, vadddomadd,
     +vdomaddadd, vdomdomadd, vdomadddom, 
     + vadddomdom, vdomdomdom)/lrel(nf)
	zz(nf,2,1,2)=alpha(nf,2,1,2)*
     + lamstar(1,0,1,kp, vadd, vdom, 
     + vaddadd12, vaddadd13, vaddadd23,
     + vdomdom12, vdomdom13, vdomdom23, 
     + vadddom12, vadddom13,vadddom23,
     +vdomadd12, vdomadd13, vdomadd23, 
     + vaddaddadd,vaddadddom, vadddomadd,
     +vdomaddadd, vdomdomadd, vdomadddom, 
     + vadddomdom, vdomdomdom)/lrel(nf)
	zz(nf,2,1,3)=alpha(nf,2,1,3)
     + *lamstar(1,0,2,kp, vadd, vdom, 
     + vaddadd12, vaddadd13, vaddadd23,
     + vdomdom12, vdomdom13, vdomdom23, 
     + vadddom12, vadddom13,vadddom23,
     +vdomadd12, vdomadd13, vdomadd23, 
     + vaddaddadd,vaddadddom, vadddomadd,
     +vdomaddadd, vdomdomadd, vdomadddom, 
     + vadddomdom, vdomdomdom)/lrel(nf)
	zz(nf,2,2,1)=alpha(nf,2,2,1)*
     + lamstar(1,1,0,kp, vadd, vdom, 
     + vaddadd12, vaddadd13, vaddadd23,
     + vdomdom12, vdomdom13, vdomdom23, 
     + vadddom12, vadddom13,vadddom23,
     +vdomadd12, vdomadd13, vdomadd23, 
     + vaddaddadd,vaddadddom, vadddomadd,
     +vdomaddadd, vdomdomadd, vdomadddom, 
     + vadddomdom, vdomdomdom)/lrel(nf)
	zz(nf,2,2,2)=alpha(nf,2,2,2)*
     + lamstar(1,1,1,kp, vadd, vdom, 
     + vaddadd12, vaddadd13, vaddadd23,
     + vdomdom12, vdomdom13, vdomdom23, 
     + vadddom12, vadddom13,vadddom23,
     +vdomadd12, vdomadd13, vdomadd23, 
     + vaddaddadd,vaddadddom, vadddomadd,
     +vdomaddadd, vdomdomadd, vdomadddom, 
     + vadddomdom, vdomdomdom)/lrel(nf)
	zz(nf,2,2,3)=alpha(nf,2,2,3)*
     + lamstar(1,1,2,kp, vadd, vdom, 
     + vaddadd12, vaddadd13, vaddadd23,
     + vdomdom12, vdomdom13, vdomdom23, 
     + vadddom12, vadddom13,vadddom23,
     +vdomadd12, vdomadd13, vdomadd23, 
     + vaddaddadd,vaddadddom, vadddomadd,
     +vdomaddadd, vdomdomadd, vdomadddom, 
     + vadddomdom, vdomdomdom)/lrel(nf)
	zz(nf,2,3,1)=alpha(nf,2,3,1)*
     + lamstar(1,2,0,kp, vadd, vdom, 
     + vaddadd12, vaddadd13, vaddadd23,
     + vdomdom12, vdomdom13, vdomdom23, 
     + vadddom12, vadddom13,vadddom23,
     +vdomadd12, vdomadd13, vdomadd23, 
     + vaddaddadd,vaddadddom, vadddomadd,
     +vdomaddadd, vdomdomadd, vdomadddom, 
     + vadddomdom, vdomdomdom)/lrel(nf)
	zz(nf,2,3,2)=alpha(nf,2,3,2)*
     + lamstar(1,2,1,kp, vadd, vdom, 
     + vaddadd12, vaddadd13, vaddadd23,
     + vdomdom12, vdomdom13, vdomdom23, 
     + vadddom12, vadddom13,vadddom23,
     +vdomadd12, vdomadd13, vdomadd23, 
     + vaddaddadd,vaddadddom, vadddomadd,
     +vdomaddadd, vdomdomadd, vdomadddom, 
     + vadddomdom, vdomdomdom)/lrel(nf)
	zz(nf,2,3,3)=alpha(nf,2,3,3)*
     + lamstar(1,2,2,kp, vadd, vdom, 
     + vaddadd12, vaddadd13, vaddadd23,
     + vdomdom12, vdomdom13, vdomdom23, 
     + vadddom12, vadddom13,vadddom23,
     +vdomadd12, vdomadd13, vdomadd23, 
     + vaddaddadd,vaddadddom, vadddomadd,
     +vdomaddadd, vdomdomadd, vdomadddom, 
     + vadddomdom, vdomdomdom)/lrel(nf)

	zz(nf,3,1,1) = alpha(nf,3,1,1) * 
     + lamstar(2,0,0,kp, vadd, vdom, 
     + vaddadd12, vaddadd13, vaddadd23,
     + vdomdom12, vdomdom13, vdomdom23, 
     + vadddom12, vadddom13,vadddom23,
     +vdomadd12, vdomadd13, vdomadd23, 
     + vaddaddadd,vaddadddom, vadddomadd,
     +vdomaddadd, vdomdomadd, vdomadddom, 
     + vadddomdom, vdomdomdom)/lrel(nf)
	zz(nf,3,1,2)=alpha(nf,3,1,2)*
     + lamstar(2,0,1,kp, vadd, vdom, 
     + vaddadd12, vaddadd13, vaddadd23,
     + vdomdom12, vdomdom13, vdomdom23, 
     + vadddom12, vadddom13,vadddom23,
     +vdomadd12, vdomadd13, vdomadd23, 
     + vaddaddadd,vaddadddom, vadddomadd,
     +vdomaddadd, vdomdomadd, vdomadddom, 
     + vadddomdom, vdomdomdom)/lrel(nf)
	zz(nf,3,1,3)=alpha(nf,3,1,3)*
     + lamstar(2,0,2,kp, vadd, vdom, 
     + vaddadd12, vaddadd13, vaddadd23,
     + vdomdom12, vdomdom13, vdomdom23, 
     + vadddom12, vadddom13,vadddom23,
     +vdomadd12, vdomadd13, vdomadd23, 
     + vaddaddadd,vaddadddom, vadddomadd,
     +vdomaddadd, vdomdomadd, vdomadddom, 
     + vadddomdom, vdomdomdom)/lrel(nf)
	zz(nf,3,2,1)=alpha(nf,3,2,1)*
     + lamstar(2,1,0,kp, vadd, vdom, 
     + vaddadd12, vaddadd13, vaddadd23,
     + vdomdom12, vdomdom13, vdomdom23, 
     + vadddom12, vadddom13,vadddom23,
     +vdomadd12, vdomadd13, vdomadd23, 
     + vaddaddadd,vaddadddom, vadddomadd,
     +vdomaddadd, vdomdomadd, vdomadddom, 
     + vadddomdom, vdomdomdom)/lrel(nf)
	zz(nf,3,2,2)=alpha(nf,3,2,2)*
     + lamstar(2,1,1,kp, vadd, vdom, 
     + vaddadd12, vaddadd13, vaddadd23,
     + vdomdom12, vdomdom13, vdomdom23, 
     + vadddom12, vadddom13,vadddom23,
     +vdomadd12, vdomadd13, vdomadd23, 
     + vaddaddadd,vaddadddom, vadddomadd,
     +vdomaddadd, vdomdomadd, vdomadddom, 
     + vadddomdom, vdomdomdom)/lrel(nf)
	zz(nf,3,2,3)=alpha(nf,3,2,3)*
     + lamstar(2,1,2,kp, vadd, vdom, 
     + vaddadd12, vaddadd13, vaddadd23,
     + vdomdom12, vdomdom13, vdomdom23, 
     + vadddom12, vadddom13,vadddom23,
     +vdomadd12, vdomadd13, vdomadd23, 
     + vaddaddadd,vaddadddom, vadddomadd,
     +vdomaddadd, vdomdomadd, vdomadddom, 
     + vadddomdom, vdomdomdom)/lrel(nf)
	zz(nf,3,3,1)=alpha(nf,3,3,1)*
     + lamstar(2,2,0,kp, vadd, vdom, 
     + vaddadd12, vaddadd13, vaddadd23,
     + vdomdom12, vdomdom13, vdomdom23, 
     + vadddom12, vadddom13,vadddom23,
     +vdomadd12, vdomadd13, vdomadd23, 
     + vaddaddadd,vaddadddom, vadddomadd,
     +vdomaddadd, vdomdomadd, vdomadddom, 
     + vadddomdom, vdomdomdom)/lrel(nf)
	zz(nf,3,3,2)=alpha(nf,3,3,2)*
     + lamstar(2,2,1,kp, vadd, vdom, 
     + vaddadd12, vaddadd13, vaddadd23,
     + vdomdom12, vdomdom13, vdomdom23, 
     + vadddom12, vadddom13,vadddom23,
     +vdomadd12, vdomadd13, vdomadd23, 
     + vaddaddadd,vaddadddom, vadddomadd,
     +vdomaddadd, vdomdomadd, vdomadddom, 
     + vadddomdom, vdomdomdom)/lrel(nf)
	zz(nf,3,3,3)=alpha(nf,3,3,3)*
     + lamstar(2,2,2,kp, vadd, vdom, 
     + vaddadd12, vaddadd13, vaddadd23,
     + vdomdom12, vdomdom13, vdomdom23, 
     + vadddom12, vadddom13,vadddom23,
     +vdomadd12, vdomadd13, vdomadd23, 
     + vaddaddadd,vaddadddom, vadddomadd,
     +vdomaddadd, vdomdomadd, vdomadddom, 
     + vadddomdom, vdomdomdom)/lrel(nf)

	else
*       multiplicative models
	end if



	top = 0.0d0
	bottom = 0.0d0
	do 100 i=1,3
	do 100 j=1,3
	do 100 k=1,3
c	if (nf.eq.1) print*,' vadd, vdom=', vadd(1), vadd(2), vadd(3), vdom(1), vdom(2), vdom(3)
c	print*,'I, j, k, zz ww=',I, j, k, zz(nf,I,j,k), wt(nf,i,j,k)
	top = top + zz(nf,i,j,k)*wt(nf,i,j,k)
100	continue
	if (top .gt. 0.0d0) like = like + log10(top)
c	write(*,*) 'nf, top= ', nf, top
110	continue
c	write(*,115) 'log10(likelihood) = ',like
c	print*,'lrel=',lrel(1)
c	print*,'like=',like
c	write(*,*) ' '
c	write(*,*) ' '
c	write(*,*) ' '
115	format(a20,2x,f12.6)
	fc = -like
	FTR= -fc
	return
	end


	double precision function lrelf(nf,
     + alpha, kp, vadd, 
     + vdom, vaddadd12, vaddadd13, vaddadd23,
     + vdomdom12, vdomdom13, vdomdom23, 
     + vadddom12, vadddom13,vadddom23,
     +vdomadd12, vdomadd13, vdomadd23, 
     + vaddaddadd,vaddadddom, vadddomadd,
     +vdomaddadd, vdomdomadd, vdomadddom, 
     + vadddomdom, vdomdomdom)

*	function to calculate the recurrence risk ratio 
*       for the relative of an affected
*	individual under a two-locus susceptibility 
*       gene model. kp denotes
*	the population prevalence, vadd(1) and vadd(2) 
*       denote the additive variance for the
*	first and second susceptibility genes, vdom(1) and 
*       vdom(2) denote the dominance variance
*	components for the two genes, and vaddadd, vadddom, 
*       vdomadd, vdomdom denote the
*	various epistatic variance components (additive X 
*       additive, additive X dominance,
*	dominance X additive, dominance X dominance). 
*       nf is the pair and alpha the prior
c	probs for the pair of sharing 2,1,0.

C	RECTHETA IS IRRELEVENT SINCE WE HAVE CALCULATED
c	JOINT PROBS AS INPUT



	integer nf
	double precision alpha(900,3,3,3), kp, 
     + vadd(3),vdom(3), vaddadd12, vaddadd13, vaddadd23,
     + vdomdom12, vdomdom13, vdomdom23, vadddom12, 
     + vadddom13,vadddom23,
     + vdomadd12, vdomadd13, vdomadd23, vaddaddadd,
     + vaddadddom, vadddomadd,
     + vdomaddadd, vdomdomadd, vdomadddom, vadddomdom, 
     + vdomdomdom

	double precision tmp(26)

	tmp(1) =  0.5*(alpha(nf,3,3,3)+ alpha(nf,3,3,2)+ 
     + alpha(nf,3,3,1)+
     +alpha(nf,3,2,3)+ alpha(nf,3,2,2)+ alpha(nf,3,2,1)+
     +alpha(nf,3,1,3)+ alpha(nf,3,1,2)+ alpha(nf,3,1,1))+
     +0.25*(alpha(nf,2,3,3)+ alpha(nf,2,3,2)+ 
     + alpha(nf,2,3,1)+
     +alpha(nf,2,2,3)+ alpha(nf,2,2,2)+ alpha(nf,2,2,1)+
     +alpha(nf,2,1,3)+ alpha(nf,2,1,2)+ alpha(nf,2,1,1))
	tmp(2)=tmp(1)
	tmp(3)=tmp(1)

c	print*,'tmp1=',tmp(1)

	tmp(4)= (alpha(nf,3,3,3)+ alpha(nf,3,3,2)+ 
     + alpha(nf,3,3,1)+
     +alpha(nf,3,2,3)+ alpha(nf,3,2,2)+ alpha(nf,3,2,1)+
     +alpha(nf,3,1,3)+ alpha(nf,3,1,2)+ alpha(nf,3,1,1))
	tmp(5)=tmp(4)
	tmp(6)=tmp(4)

	tmp(7)=0.25*(alpha(nf,3,3,3)+ alpha(nf,3,3,2)+ 
     + alpha(nf,3,3,1))+
     +0.125*( alpha(nf,2,3,3)+ alpha(nf,2,3,2)+ 
     + alpha(nf,2,3,1))+
     +0.125*(alpha(nf,3,2,3)+ alpha(nf,3,2,2)+ 
     + alpha(nf,3,2,1))+
     +0.0625*(alpha(nf,2,2,3)+ alpha(nf,2,2,2)+ 
     + alpha(nf,2,2,1))

	tmp(8)= 0.25*(alpha(nf,3,3,3)+ alpha(nf,3,2,3)+ 
     + alpha(nf,3,1,3))+
     +0.125*( alpha(nf,2,3,3)+ alpha(nf,2,2,3)+ 
     + alpha(nf,2,1,3))+
     +0.125*(alpha(nf,3,3,2)+ alpha(nf,3,2,2)+ 
     + alpha(nf,3,1,2))+
     +0.0625*(alpha(nf,2,3,2)+ alpha(nf,2,2,2)+ 
     + alpha(nf,2,1,2))

	tmp(9)= 0.25*(alpha(nf,3,3,3)+ alpha(nf,2,3,3)+ 
     + alpha(nf,1,3,3))+
     +0.125*( alpha(nf,3,2,3)+ alpha(nf,2,2,3)+ 
     + alpha(nf,1,2,3))+
     +0.125*(alpha(nf,3,3,2)+ alpha(nf,2,3,2)+ 
     + alpha(nf,1,3,2))+
     +0.0625*(alpha(nf,3,2,2)+ alpha(nf,2,2,2)+ 
     + alpha(nf,1,2,2))

	tmp(10)= 0.5*(alpha(nf,3,3,3)+ alpha(nf,3,3,2)+ 
     + alpha(nf,3,3,1))+
     +0.25*( alpha(nf,2,3,3)+ alpha(nf,2,3,2)+ 
     + alpha(nf,2,3,1))

	tmp(11)= 0.5*(alpha(nf,3,3,3)+ alpha(nf,3,2,3)+ 
     + alpha(nf,3,1,3))+
     +0.25*( alpha(nf,2,3,3)+ alpha(nf,2,2,3)+ 
     + alpha(nf,2,1,3))

	tmp(12)= 0.5*(alpha(nf,3,3,3)+ alpha(nf,3,3,2)+ 
     + alpha(nf,3,3,1))+
     +0.25*( alpha(nf,3,2,3)+ alpha(nf,3,2,2)+ 
     + alpha(nf,3,2,1))


	tmp(13)= 0.5*(alpha(nf,3,3,3)+ alpha(nf,2,3,3)+ 
     + alpha(nf,1,3,3))+
     +0.25*( alpha(nf,3,2,3)+ alpha(nf,2,2,3)+ 
     + alpha(nf,1,2,3))

	tmp(14)= 0.5*(alpha(nf,3,3,3)+ alpha(nf,3,2,3)+ 
     + alpha(nf,3,1,3))+
     +0.25*( alpha(nf,3,3,2)+ alpha(nf,3,2,2)+ 
     + alpha(nf,3,1,2))

	tmp(15)= 0.5*(alpha(nf,3,3,3)+ alpha(nf,2,3,3)+ 
     + alpha(nf,1,3,3))+
     +0.25*( alpha(nf,3,3,2)+ alpha(nf,2,3,2)+ 
     + alpha(nf,1,3,2))


	tmp(16)= alpha(nf,3,3,3)+ alpha(nf,3,3,2)+ 
     + alpha(nf,3,3,1)

	tmp(17)= alpha(nf,3,3,3)+ alpha(nf,3,2,3)+ 
     + alpha(nf,3,1,3)

	tmp(18)= alpha(nf,3,3,3)+ alpha(nf,2,3,3)+ 
     + alpha(nf,1,3,3)

	tmp(19)=0.125*alpha(nf,3,3,3)+
     + 0.0625*alpha(nf,3,3,2)
     + +0.0625*alpha(nf,3,2,3)+
     +0.0625*alpha(nf,2,3,3)+
     + 0.03125*alpha(nf,3,2,2)+ 
     + 0.03125*alpha(nf,2,3,2)+ 
     + 0.03125*alpha(nf,2,2,3)+
     +0.015625*alpha(nf,2,2,2)


	tmp(20)=0.25*alpha(nf,3,3,3)+
     + 0.125*alpha(nf,2,3,3)+
     + 0.125*alpha(nf,3,2,3)+
     +0.0625*alpha(nf,2,2,3)

	tmp(21)= 0.25*alpha(nf,3,3,3)+
     + 0.125*alpha(nf,2,3,3)+
     + 0.125*alpha(nf,3,3,2)+
     +0.0625*alpha(nf,2,3,2)

	tmp(22)=0.25*alpha(nf,3,3,3)+
     + 0.125*alpha(nf,3,2,3)+
     + 0.125*alpha(nf,3,3,2)+
     +0.0625*alpha(nf,3,2,2)


	tmp(23)= 0.5*alpha(nf,3,3,3)+0.25*alpha(nf,2,3,3)

	tmp(24)= 0.5*alpha(nf,3,3,3)+0.25*alpha(nf,3,2,3)

	tmp(25)= 0.5*alpha(nf,3,3,3)+0.25*alpha(nf,3,3,2)

	tmp(26)= alpha(nf,3,3,3)


c	print*,'tmp=',tmp(1), tmp(2), tmp(3), tmp(4), tmp(5),tmp(6), tmp(7),tmp(26)
c	print*,'kp=',kp

	lrelf = 1 + (1/(kp*kp))*(2*tmp(1)*vadd(1)+
     + 2*tmp(2)*vadd(2)+2*tmp(3)*vadd(3)+
     +tmp(4)*vdom(1)+tmp(5)*vdom(2)+tmp(6)*vdom(3)+
     + 4*tmp(7)*vaddadd12+
     +4*tmp(8)*vaddadd13+4*tmp(9)*vaddadd23+
     + 2*tmp(10)*vadddom12+2*tmp(11)*vadddom13+
     +2*tmp(12)*vdomadd12+2*tmp(13)*vadddom23+
     + 2*tmp(14)*vdomadd13+2*tmp(15)*vdomadd23+
     +tmp(16)*vdomdom12+ tmp(17)*vdomdom13+ 
     + tmp(18)*vdomdom23+8*tmp(19)*vaddaddadd+
     +4*tmp(20)*vaddadddom+4*tmp(21)*vadddomadd+
     + 4*tmp(22)*vdomaddadd+
     +2*tmp(23)*vadddomdom+2*tmp(24)*vdomadddom+
     + 2*tmp(25)*vdomdomadd+
     +tmp(26)*vdomdomdom)

c	print*,'lrel done, =',lrelf

	return
	end



	double precision function lamstar(I,j,k, kp, 
     + vadd, vdom, vaddadd12, vaddadd13, vaddadd23,
     + vdomdom12, vdomdom13, vdomdom23, vadddom12, 
     + vadddom13,vadddom23,
     +vdomadd12, vdomadd13, vdomadd23, vaddaddadd,
     + vaddadddom, vadddomadd,
     +vdomaddadd, vdomdomadd, 
     + vdomadddom, vadddomdom, 
     + vdomdomdom)

c	function to calculate the recurrence risk ratio for two individuals that 
c	share exactly 0 , 0, 1 genes IBD at 3 susceptibility genes

	integer I, j, k

	double precision kp, vadd(3), vdom(3), 
     + vaddadd12, vaddadd13, vaddadd23,
     + vdomdom12, vdomdom13, vdomdom23, vadddom12, 
     + vadddom13,vadddom23,
     +vdomadd12, vdomadd13, vdomadd23, vaddaddadd,
     + vaddadddom, vadddomadd,
     +vdomaddadd, vdomdomadd, 
     + vdomadddom, vadddomdom, 
     + vdomdomdom, a(3), d(3)

	if (i.eq.0) a(1)=0.0
	if (i.eq.0) d(1)=0.0
	if (i.eq.1) a(1)=0.5
	if (i.eq.1) d(1)=0.0
	if (i.eq.2) a(1)=1.0
	if (i.eq.2) d(1)=1.0

	if (j.eq.0) a(2)=0.0
	if (j.eq.0) d(2)=0.0
	if (j.eq.1) a(2)=0.5
	if (j.eq.1) d(2)=0.0
	if (j.eq.2) a(2)=1.0
	if (j.eq.2) d(2)=1.0

	if (k.eq.0) a(3)=0.0
	if (k.eq.0) d(3)=0.0
	if (k.eq.1) a(3)=0.5
	if (k.eq.1) d(3)=0.0
	if (k.eq.2) a(3)=1.0
	if (k.eq.2) d(3)=1.0



	lamstar = 1.0d0 + (1.0d0/(kp*kp))*
     + (a(1)*vadd(1)+
     + a(2)*vadd(2)+a(3)*vadd(3)+
     + d(1)*vdom(1)+d(2)*vdom(2)+d(3)*vdom(3)+
     + a(1)*a(2)*vaddadd12+a(1)*a(3)*vaddadd13+
     + a(2)*a(3)*vaddadd23+
     + a(1)*d(2)*vadddom12+a(1)*d(3)*vadddom13+
     + a(2)*d(3)*vadddom23+
     + d(1)*a(2)*vdomadd12+d(1)*a(3)*vdomadd13+
     + d(2)*a(3)*vdomadd23+
     + d(1)*d(2)*vdomdom12+d(1)*d(3)*vdomdom13+
     + d(2)*d(3)*vdomdom23+
     + a(1)*a(2)*a(3)*vaddaddadd+ a(1)*a(2)*
     + d(3)*vaddadddom+ 
     + a(1)*d(2)*a(3)*vadddomadd+
     + d(1)*a(2)*a(3)*vdomaddadd+ a(1)*d(2)*
     + d(3)*vadddomdom+ 
     + d(1)*a(2)*d(3)*vdomadddom+
     + d(1)*d(2)*a(3)*vdomdomadd+d(1)*d(2)*
     + d(3)*vdomdomdom)
	return
	end

*
*	The following functions are reserved for a future implementation of the
*	multiplicative model
*	BUT MAY NOT BE NEEDED IF NEST MUL MODEL IN GENERAL
*
	double precision function ls(kp,vadd,vdom)

*	function to calculate recurrence risk ratio for siblings
*	of affected individuals

	double precision kp, vadd, vdom

	ls = 1.0d0+1.0d0/(kp*kp)*(vadd/2.0d0 + vdom/4.0d0)
	return
	end

        double precision function lo(kp,vadd)

*	function to calculate recurrence risk ratio for offspring
*	of affected parents
 
        double precision kp, vadd
 
        lo = 1.0d0 + 1.0d0/(kp*kp) * (vadd/2.0d0)
        return
        end

        double precision function lmz(kp,vadd,vdom)

*	function to calculate recurrence risk ratio for MZ twins
 
        double precision kp, vadd, vdom
 
        lmz = 1.0d0 + 1.0d0/(kp*kp) * (vadd + vdom)
        return
        end


	SUBROUTINE HESSIN(DF,HESS,OBS,PAR,F,ITER,KASE,MODEL,NCASE
     :,NOBS,NPAR,DIFFER)
C
C     THIS SUBROUTINE PERMITS RECOMPUTATION OF THE OBJECTIVE FUNCTION
C     F AND ITS DIFFERENTIAL DF.  IF DIFFER(2) IS TRUE, THEN PROVIDE
C     AN APPROXIMATION TO THE SECOND DIFFERENTIAL, I.E, HESSIAN OF F.
C
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      DOUBLE PRECISION DF(NPAR),HESS(NPAR,NPAR),OBS(NOBS)
     :,PAR(NPAR)
      LOGICAL DIFFER(2)
C
C
      END


	SUBROUTINE DEPAR1(TR,LEX)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
C The function to check the parameters are in bounds and to calculate
C dependent parameters.
C
      PARAMETER (NP=45)
	COMMON /MAXF1/ THIN(NP),THL(NP),THU(NP),STPIN(NP),EPSD,YOTA,EPST,
     $               EPSC1,EPSC2,EPSC3,ISTIN(NP),NT,MAXIT,METHOD,IXVC,
     $               IHIT
      COMMON /MKUND/ KP2,KK
      DIMENSION TR(*)

C
C Calculate the dependent parameter
C 
C
C     Check that all parameters are in bounds 0-1

	do I=1,NT
C 
      IF ((TR(i).LT.0.D0).OR.(TR(i).GT.1.0D0))  THEN
         LEX = 1
         RETURN
       END IF

	end do

      LEX = 0

      RETURN
      END
c
c


