%Matlab codes for Figure 2.1
%run ex21.m directly
%(C) Copyright 2011, Jian Qing Shi

%The 1st figure: generate 10 data-sets from a GP. The values of
%hyperparameters are given in X below. 

X=[log(10) log(1) log(1) log(0.001)];   % log of hyperparameters, see the meaning in GPCOV
test=(0:0.05:1)';

Q=gpcov(X, test);  %covariance matrix

R = mvnrnd(test-test, Q, 10);
close('all');
figure(1);
hold on;
for d=1:10
plot(test,R(d,:)','k'); %random draw from gp with the covariance matrix Q
end 

%input1=[10,30]; 
%input2=[10 21 30]; 
%input3=[2 8 15 21 27 34 40]; 

input1=[5,15];
input2=[5 11 15];
input3=[2 5 8 11 14 17 20];

R1=R(5,:)';
plot(test(input3),R1(input3),'kx', 'MarkerSize',10);
ylim([-3 3]);

%The 2nd figure: 2 data points are used to predict test data
test1=[0:0.03:1]';
figure(2);
hold on;
input=input1;
[mu, sigma2]=gp01pred(X,test(input),R1(input),test1);
plot(test1,mu,'k--');
ylim([-3 3]);
plot(test(input),R1(input),'kx', 'MarkerSize',10);
plot(test,R1,'k');
upper=mu+1.96*sqrt(sigma2);
lower=mu-1.96*sqrt(sigma2);
jbfill(test1,upper,lower,'k','k',0,0.3);

%The 3rd figure: 3 data points are used to predict test data
figure(3);
hold on;
input=input2;
[mu, sigma2]=gp01pred(X,test(input),R1(input),test1);
plot(test1,mu,'k--');
ylim([-3 3]);
plot(test(input),R1(input),'kx', 'MarkerSize',10);
plot(test,R1,'k');
upper=mu+1.96*sqrt(sigma2);
lower=mu-1.96*sqrt(sigma2);
jbfill(test1,upper,lower,'k','k',0,0.3);

%The 4th figure: 7 data points are used to predict test data
figure(4);
hold on;
input=input3;
[mu, sigma2]=gp01pred(X,test(input),R1(input),test1);
plot(test1,mu,'k--');
ylim([-3 3]);
plot(test(input),R1(input),'kx', 'MarkerSize',10);
plot(test,R1,'k');
upper=mu+1.96*sqrt(sigma2);
lower=mu-1.96*sqrt(sigma2);
jbfill(test1,upper,lower,'k','k',0,0.3);




