%Matlab codes for Figure 3.1
%run ex31.m directly
%(C) Copyright 2011, Jian Qing Shi

X=[log(10) log(0.01) log(1) log(0.01)];   % log of hyperparameters, see the meaning in GPCOV
Xprior=[0.1, 1, -3, 3, -1, 1, -3, 3]; %values of hyper-parameters
X1=[log(1) log(5) log(1) log(0.01)];
test=(0:0.05:1)';

Q=gpcov(X, test);  %covariance matrix

R = mvnrnd(test-test, Q, 10);


input1=[5,15];
input2=[5 11 15];
input3=[3 7 11 13 17];

R1=sort(R(1,:)')+sin(test*6);
%R1=R1-mean(R1);
test1=[0:0.03:1]';

%The 1st figure: use the values of hyper-parameters (1, 5, 1, 0.01) i.e.
%using X1
figure(1);
hold on;
input=input3;
[mua, sigma2a]=gp01pred(X1,test(input),R1(input),test1);
plot(test1,mua,'k--');
ylim([-3 3]);
plot(test(input),R1(input),'kx', 'MarkerSize',10);
plot(test,R1,'k');
upper=mua+1.96*sqrt(sigma2a);
lower=mua-1.96*sqrt(sigma2a);
jbfill(test1,upper,lower,'k','k',0,0.3);

%The 2nd figure: use the empirical Bayesian estimates for hyper-parameters 
figure(2);
hold on;

%[X2,fx, i] = minimize(X, 'gp1', 100, test(input), R1(input));
[M,fM, iter, nbeva1]=conjgrad(X','gp1',100, test, R1);

[Map,fMap, itermap, nbeva1map]=conjgrad(X','gp1map',100, test, R1, Xprior);

[mub, sigma2b]=gp01pred(M,test(input),R1(input),test1);
plot(test1,mub,'k--');
ylim([-3 3]);
plot(test(input),R1(input),'kx', 'MarkerSize',10);
plot(test,R1,'k');
upper=mub+1.96*sqrt(sigma2b);
lower=mub-1.96*sqrt(sigma2b);
jbfill(test1,upper,lower,'k','k',0,0.3);



