%Matlab codes for Figure 4.1 and 4.2
%run ex41.m directly
%(C) Copyright 2011, Jian Qing Shi

%The first figure: sample paths drawn from the powered exponential kernel
X=[log(10) log(0.2) log(1) log(0.0000001)];   % log of hyperparameters, see the meaning in GPCOVge
X1=[log(0.1) log(5) log(1) log(0.01)];
test=(-3:0.05:3)';

Q=gpcovge(X, test);  %covariance matrix generated from the powered exponential kernel

R = mvnrnd(test-test, Q, 10);
close('all');
figure(1); hold on; subplot(411);
hold on;
for d=1:2
plot(test,R(d,:)','k'); %random draw from gp with the covariance matrix Q
end 
title('gamma=0.2');
%print(gcf, '-depsc','fig-ch4\fig-ch4-a')


X=[log(10) log(1) log(1) log(0.0000001)];
Q=gpcovge(X, test);  %covariance matrix generated from the powered exponential kernel

R = mvnrnd(test-test, Q, 10);
subplot(412);
hold on;
for d=1:2
plot(test,R(d,:)','k'); %random draw from gp with the covariance matrix Q
end 
title('gamma=1');
%print(gcf, '-depsc','fig-ch4\fig-ch4-b')


X=[log(10) log(1.5) log(1) log(0.0000001)];
Q=gpcovge(X, test);  %covariance matrix generated from the powered exponential kernel

R = mvnrnd(test-test, Q, 10);
subplot(413);
hold on;
for d=1:2
plot(test,R(d,:)','k'); %random draw from gp with the covariance matrix Q
end 
title('gamma=1.5');
%print(gcf, '-depsc','fig-ch4\fig-ch4-c')


X=[log(10) log(2) log(1) log(0.0000001)];
Q=gpcovge(X, test);  %covariance matrix generated from the powered exponential kernel

R = mvnrnd(test-test, Q, 10);
subplot(414);
hold on;
for d=1:2
plot(test,R(d,:)','k'); %random draw from gp with the covariance matrix Q
end 
title('gamma=2');
%print(gcf, '-depsc','fig-ch4\fig-ch4-new')


%The first figure: sample paths drawn from the rational quadratic kernel

alpha=0.2; c=2*alpha*(exp(log(20)/alpha)-1);
X=[log(c) log(alpha) log(0.0000001)];
Q=gpcovrq(X, test);  %covariance matrix generated from the rational quadratic kernel

R = mvnrnd(test-test, Q, 10); 
figure(2); hold on; subplot(411);
hold on;
for d=1:2
plot(test,R(d,:)','k'); %random draw from gp with the covariance matrix Q
end 
title('alpha=0.2');
%print(gcf, '-depsc','fig-ch4\fig-ch4-rqa')

alpha=0.1; c=2*alpha*(exp(log(20)/alpha)-1);
X=[log(c) log(alpha) log(0.0000001)];
Q=gpcovrq(X, test);  %covariance matrix generated from the rational quadratic kernel

R = mvnrnd(test-test, Q, 10);
subplot(412);
hold on;
for d=1:2
plot(test,R(d,:)','k'); %random draw from gp with the covariance matrix Q
end 
title('alpha=1');
%print(gcf, '-depsc','fig-ch4\fig-ch4-rqb')

alpha=2; c=2*alpha*(exp(log(20)/alpha)-1);
X=[log(c) log(alpha) log(0.0000001)];
Q=gpcovrq(X, test);  %covariance matrix generated from the rational quadratic kernel

R = mvnrnd(test-test, Q, 10);
subplot(413);
hold on;
for d=1:2
plot(test,R(d,:)','k'); %random draw from gp with the covariance matrix Q
end 
title('alpha=2');
%print(gcf, '-depsc','fig-ch4\fig-ch4-rqc')

alpha=20; c=2*alpha*(exp(log(20)/alpha)-1);
X=[log(c) log(alpha) log(0.0000001)];
Q=gpcovrq(X, test);  %covariance matrix generated from the rational quadratic kernel

R = mvnrnd(test-test, Q, 10);
subplot(414);
hold on;
for d=1:2
plot(test,R(d,:)','k'); %random draw from gp with the covariance matrix Q
end 
title('alpha=20');
%print(gcf, '-depsc','fig-ch4\fig-ch4-rq-new')



