function Q = gpcovge(X, input);

%modified from gpcov which is for squared exponential, this one is for
%general exponential kernel
%GPCOV Compute the n by n covariance matrix 
%
%    USAGE: Q = gpcov(X, input) 
%
%    where: 
%
%    X      is a (column) vector (of size 2*D+2) of hyperparameters
%    input  is a n by D matrix of training inputs
%    Q      is a n by n matrix of covariance function
%
%    The form of the covariance function is
%
%    C(x^p,x^q) = v1 * exp( -0.5 * sum_{d=1..D} w_d * (x^p_d - x^q_d)^gamma )
%               + v0 * delta_{p,q}
%
%    where the first term is linear, the second non-linear and the final term
%    with the kronecker delta is the noise contribution. In this function, the
%    hyperparameters w_i, a_i, v1 and v0 are collected in the vector X as
%    follows:
%
%    X = [ log(w_1)
%           .
%          log(w_D)
%          log(gamma)
%          log(v1)
%          log(v0) ]
%
%
%    See also: GP1pred
%              CONJGRAD
%      
%    (C) Jian Qing Shi (08-05-2010) (modified from gp01pred by Rasmussen).

[n, D] = size(input);   % number of training cases and dimension of input space
expX = exp(X);              % exponentiate the hyperparameters once and for all


% first, we write out the covariance matrix Q for the training inputs ...

Q = zeros(n,n);                                         % create and zero space
for d = 1:D                                           % non-linear contribution
  Q = Q + abs(input(:,d)*ones(1,n)-ones(n,1)*input(:,d)').^(expX(D+1))*expX(d);
end
Q = expX(2+D)*exp(-0.5*Q);

Q = Q + expX(D+3)*eye(n);


