function Q = gpcovrq(X, input);

%modified from gpcov which is for squared exponential, this one is for
%rational quadratic kernel
%GPCOV Compute the n by n covariance matrix 
%
%    USAGE: Q = gpcov(X, input) 
%
%    where: 
%
%    X      is a (column) vector (of size 2*D+2) of hyperparameters
%    input  is a n by D matrix of training inputs
%    Q      is a n by n matrix of covariance function
%
%    The form of the covariance function is
%
%    C(x^p,x^q) = (1+ [sum_{d=1..D} w_d * (x^p_d - x^q_d)^2]/(2 \alpha
%    )^(-\alpha)+v0 delta(p,q)
%               
%
%    where the first term is linear, the second non-linear and the final term
%    with the kronecker delta is the noise contribution. In this function, the
%    hyperparameters w_i, a_i, v1 and v0 are collected in the vector X as
%    follows:
%
%    X = [ log(w_1)
%           .
%          log(w_D)
%          log(alpha) 
%          log(v0)]
%
%
%    See also: GP1pred
%              CONJGRAD
%      
%    (C) Jian Qing Shi (08-05-2010) (modified from gp01pred by Rasmussen).

[n, D] = size(input);   % number of training cases and dimension of input space
expX = exp(X);              % exponentiate the hyperparameters once and for all


% first, we write out the covariance matrix Q for the training inputs ...

Q = zeros(n,n);                                         % create and zero space
for d = 1:D                                           % non-linear contribution
  Q = Q + abs(input(:,d)*ones(1,n)-ones(n,1)*input(:,d)').^2*expX(d);
end
Q = exp(-1*expX(D+1)*log(1+0.5*Q/expX(D+1)));

Q = Q + expX(D+2)*eye(n);


