% A demo example, see 'readme.txt
%B. Wang and J.Q. Shi, 2005

addpath('../fda');

%load trainig data
load train.data -ascii


%set the parameters    
SN = train(1,1);          % number of sample curves
sn = SN/3;                % number of sample curves for each classe
ud = train(1,2);          % the dimension of U    
n = train(1,3);           % number of sample points for each curve


U = train(2:ud+1,:);                 %the matrix of known covariate
U = U';
xdata = train(ud+2:ud+2+n-1,1);      %input covariate: in this example all of these are the same
xdata = xdata';
ydata = train(ud+2+n:ud+2+2*n-1,:);  %training observations
ydata = ydata';


%--------------
% Training ....
%----------------
stepsize = n;               % training data size
tdsize = fix(stepsize/2);   % choose half data for training

[yregfd, sigv2] = fdatrain(xdata, ydata, U);             % FDA method
[yregfd, xp, iuu] = gpfrtrain(xdata, ydata, U, tdsize);  % GPFR ethod
[ymeand, xpd] = gptrain(xdata, ydata, tdsize);           % GP method



%--------------
% Predicting ....
%----------------
load test.data -ascii   %load test data

Ut = test(1:ud,1);      %known covariate for test curve
Ut = Ut';
odsize = test(ud+1,1);  %output data size
tdsize = test(ud+2,1);  %test data size
xindin = test(ud+3:ud+3+odsize-1,1); %index of output data
xindin = xindin';
xindt = test(ud+3+odsize:ud+3+odsize+tdsize-1,1); %index of test data
xindt = xindt';
x = xdata;
samyt = ydata(end,:);   %test curve belongs to the last curve of training data
xdisp = x(1,xindin);
ydisp = samyt(1,xindin);


rcc = zeros(3,4);           %rmse and correlation coeffients for three methods
ttype = 1;                  %test the first type of prediction


fdapred
figure(2);
plot(xtest, ypredfda, 'r--', xtest, [ypredfdaup;ypredfdalo], 'r:','LineWidth',1);
hold on;
plot(xdisp, ydisp,'b.');
xlabel('x'); ylabel('y');
title('Prediction by FDA');

gpfrpred
figure(3);
plot(xtest, ypred, 'r--', xtest, [ypredup;ypredlo], 'r:','LineWidth',1);
hold on;
plot(xdisp, ydisp(1,:),'b.');
xlabel('x'); ylabel('y');
title('Prediction by GPFR');

gppred
figure(4);
plot(xtestd, ypredd, 'r--', xtestd, [ypredupd;ypredlod], 'r:','LineWidth',1);
hold on;
plot(xdisp, ydisp,'b.');
xlabel('x'); ylabel('y');
title('Prediction by GP');
