%A demo example of multiple-step-ahead forecasting discussed in Shi et al (2005), see 'readme.txt
%B. Wang and J.Q. Shi, 2005

addpath('../fda');


sn = 10;                  % number of sample curves for each classe
n = 51;                   % number of sample points for each curve

U1 = [0 1]; 
U2 = [-1 1]; 
U3 = [1 1];               % three classes of samples

L = -4; H = 4;            % limits of points are "L" and "H"
x = (L:(H-L)/(n-1):H);    % sample points: 1 x n


v1 = 0.1; w1 = 1.0; v0 = 0.0025; a1 = 0.0; %parameters of covariance function
theta = [v1; w1; v0; a1];

stepnum = [1;3;6];         % K-step ahead prediction
Lag = 1;                    % L: lag length. y(t_i) = f(x(t_i), y(t_{i-K}), y(t_{i-K-1}), ..., y(t_{i-K-L+1})).


%sampling for test: generate a new curve from the third group U3
Ut = U3;
[trueyt, rnyt, samyt] = sampling(x, theta, Ut, 1);



for ii = 1:size(stepnum,1)
    K = stepnum(ii);
    figfile = ['./figs/' num2str(K) 'step'];
	%---------------------
	% Sampling .....
	%---------------------
	
	[truey1, rny1, samy1] = sampling(x, theta, U1, sn);
	[truey2, rny2, samy2] = sampling(x, theta, U2, sn);
	[truey3, rny3, samy3] = sampling(x, theta, U3, sn); 
	
	
	%------------
	% Training ...
	%------------
	
	stepsize = n;               % data size between [L,H]
	xdata = x;
	ydata = [samy1;samy2;samy3];
	
	
	U = zeros(size(ydata,1),2);
	U = [repmat(U1,sn,1); repmat(U2,sn,1); repmat(U3,sn,1)];
	
	[yregfd, sigv2] = fdatrain(xdata, ydata, U);                  % FDA method
	[yregfd, xp, iuu] = gpfrtrainkstep(xdata, ydata, U, K, Lag);  % GPFR ethod
	[ymeand, xpd] = gptrainkstep(xdata, ydata, K, Lag);           % GP method
	
	
	%--------------
	% Predicting ....
	%----------------
	
	rcc = zeros(3,2);             %rmse and correlation coeffients for three methods
	stpoint = ceil(stepsize/3);   %the point from which the prediction begins
	
    xindt = stpoint:stepsize;
	
   	ttype = 3;                    %set this parameter in order to use the common fdapred.m
	fdapred
	gpfrpredkstep
	gppredkstep
	
	
    
	datfile = ['./figs/' num2str(K) 'stepwork1.mat'];
	rccfile = ['./figs/' num2str(K) 'steprcc.txt'];	
	save(datfile);
	writercc(rcc, rccfile);
    
end

