%The first example discussed in Shi et al (2005), see 'readme.txt
%B. Wang and J.Q. Shi, 2005

addpath('../fda');


sn = 10;                  % number of sample curves for each classe
n = 101;                  % number of sample points for each curve

U1 = [0 1]; 
U2 = [-1 1]; 
U3 = [1 1];               % three classes of samples

L = -4; H = 4;            % limits of points are "L" and "H"
x = (L:(H-L)/(n-1):H);    % sample points: 1 x n


v1 = 0.1; w1 = 1.0; v0 = 0.0025; a1 = 0.0;   %parameters of covariance function
theta = [v1; w1; v0; a1];


%---------------------
% Sampling .....
%---------------------

[truey1, rny1, samy1] = sampling(x, theta, U1, sn);
[truey2, rny2, samy2] = sampling(x, theta, U2, sn);
[truey3, rny3, samy3] = sampling(x, theta, U3, sn); 


%------------
% Training ...
%------------

stepsize = n;               % data size between [-4,4]
tdsize = fix(stepsize/2);   % choose half data for training

xdata = x;
ydata = [samy1;samy2;samy3];


U = zeros(size(ydata,1),2);
U = [repmat(U1,sn,1); repmat(U2,sn,1); repmat(U3,sn,1)];
% %     U = 
% %     0   1  
% %     :   :  
% %     0   1 
% %    -1   1 
% %     :   : 
% %    -1   1 
% %     1   1 
% %     :   : 
% %     1   1 
% %     Thus, the actual model is: y_m = (a_1 a_2)(beta_1(t)  beta_2(t))' + eps(t)
% %     beta_1(t) = 1, beta_2(t) = sin(???).
% %     For the first group: (a_1 a_2) = (0 1)
% %     For the second group: (a_1 a_2) = (-1 1)
% %     For the third group: (a_1 a_2) = (1 1)

[yregfd, sigv2] = fdatrain(xdata, ydata, U);             % FDA method
[yregfd, xp, iuu] = gpfrtrain(xdata, ydata, U, tdsize);  % GPFR ethod
[ymeand, xpd] = gptrain(xdata, ydata, tdsize);           % GP method

% check estimated mean function: e.g. the third group: Um=1
figure(1)
clf
plot(yregfd(1)+yregfd(2));    
title('Regression Functions')
hold on;
plot(xdata,truey3);


%--------------
% Predicting ....
%----------------

rcc = zeros(3,4);           %rmse and correlation coeffients for three methods
odsize = fix(stepsize/2);   %output data size


%sampling for test: generate a new curve from the third group U3
Ut = U3;
[trueyt, rnyt, samyt] = sampling(x, theta, Ut, 1);


%Test of Type 1: randomly choosed half
ttype = 1;
[xindin,xindt] = srswor(stepsize,odsize);

fdapred
gpfrpred
gppred


%Test of Type 2: predict the second half
ttype = 2;
xindin = 1:odsize;
xindt = (odsize+1):stepsize;

fdapred
gpfrpred
gppred



%----------------
% Saving results ....
%----------------

save './figs/work1.mat'
writercc(rcc, './figs/rcc.txt');

