function [yregfd, sigv2] = fdatrain(xdata, ydata, zmat)

L = xdata(1,1);
H = xdata(1,end);

bsbasis = create_bspline_basis([L,H], 20);
yfd = data2fd(ydata', xdata, bsbasis);    
	

linmodstr = linmod(zmat, yfd);
yregfd = linmodstr.reg;




%--------------------------------------------------------------
% Some quantities for computing the confidence interval
%--------------------------------------------------------------
[cn,stepsize] = size(ydata);

yhatfd = linmodstr.yhat;
yresfd = yfd - yhatfd;
yresmat = eval_fd(xdata,yresfd);
sigv2 = sum((yresmat').^2)./(cn-1);
