
%Prediction: GPFR method


%shift the observed data along the mean function
yregtmp = (eval_fd(x,yregfd))'; 
ygpobs = samyt - Ut*yregtmp;

xinput = x(1,xindin);
xtest = x(1,xindt);
youtput = ygpobs(1,xindin);


%predict the means and the variances of the test outputs, given the input xdata and the output
[mu, s2] = gp01pred(xp, xinput', youtput', xtest');
ygppred = mu';
s2 = s2*(1 + Ut*iuu*Ut');


%shift back the test output along the mean function
yregtmptest = (eval_fd(xtest,yregfd))'; 
ypred = ygppred + Ut*yregtmptest;
ypredup = ypred + 1.96*sqrt(s2');    % 95% confidence interval
ypredlo = ypred - 1.96*sqrt(s2');


%display and assess the results
if ttype == 1
    gffigname = './figs/randomgf.eps';
    rccpos = 1;
else
    gffigname = './figs/firstgf.eps';
    rccpos = 3;
end
rcc(1,rccpos) = rmse(ypred, samyt(1,xindt));
a = corrcoef(ypred, samyt(1,xindt));
rcc(1,rccpos+1) = a(1,2);

figure(1);
clf
plot(xtest, ypred, 'r--', xtest, [ypredup;ypredlo], 'r:','LineWidth',1);
hold on;
plot(x, samyt(1,:),'b-');
xlabel('x'); ylabel('y');
print(gffigname, '-depsc2');
clf

