%Prediction: GPFR method


%shift the observed data along the mean function
yregtmp = (eval_fd(x,yregfd))'; 
ygpobs = samyt - Ut*yregtmp;


%-------------------------------------
% Predict the second part step by step
%-------------------------------------
samsize = stepsize;
ygppred = zeros(1,samsize-stpoint+1);
ygppreds2 = zeros(1,samsize-stpoint+1);
xinput = x';
youtput = ygpobs';

for s = stpoint:samsize
	
    xdataaug = xinput((K+Lag):s-K,1);     
    xtestaug = xinput(s,1);

	for j=Lag:1
        xdataaug = [ xdataaug, youtput(j:s-2*K-Lag+j,1) ];
        xtestaug = [ xtestaug, youtput(s-K-Lag+j,1) ];
    end
    
  	[mu, s2] = gp02pred(xp, xdataaug, youtput((K+Lag):s-K,1), xtestaug);
	ygppred(1,s-stpoint+1) = mu';
    ygppreds2(1,s-stpoint+1) = s2*(1 + Ut*iuu*Ut');	
end


%shift back the test output along the mean function
yregtmptest = (eval_fd(x(1,xindt),yregfd))'; 
ypred = ygppred + Ut*yregtmptest;
ypredup = ypred + 1.96*sqrt(ygppreds2);    % 95% confidence interval
ypredlo = ypred - 1.96*sqrt(ygppreds2);


%display and assess
rcc(1,1) = rmse(ypred, samyt(1,xindt));
a = corrcoef(ypred, samyt(1,xindt));
rcc(1,2) = a(1,2);


figure(1);
clf
plot(x(1,xindt), ypred, 'r--', x(1,xindt), [ypredup;ypredlo], 'r:','LineWidth',1);
hold on;
plot(x, samyt,'b-');
xlabel('x'); ylabel('y');
figfilen = [figfile 'gf.eps'];
print('-depsc2', figfilen);
clf

