function [yregfd, xp, iuu] = gpfrtrain(xdata, ydata, zmat, tdsize)
%
%GPFR method:
%

[cn,stepsize] = size(ydata);

yregfd = fdatrain(xdata, ydata, zmat);


%randomly select half data for training and shift the outputs along the mean function
yregtmp = (eval_fd(xdata,yregfd))'; 
meanmat = zmat*yregtmp;   %contains the means of three classes: U1, U2, U3, respectively


xgpdata = zeros(cn,tdsize);
ygpdata = xgpdata;
for i=1:cn
	[xindtrain,xresttrain] = srswor(stepsize,tdsize);
    xgpdata(i,:) = xdata(1,xindtrain);
    ygpdata(i,:) = ydata(i,xindtrain) - meanmat(i,xindtrain);
end


%estimate the hyperparameters of covariance function and noise variance
disp('Minimising the minus loglikelihood...')
%choose good starting values to avoid long-time optimising procedure
initw1 = 0;  
inita1 = -15;
initv1 = -2.5;
initv0 = -6;
[xp fxp ip] = minimize([initw1;inita1;initv1;initv0], 'repgp01lik', 200, xgpdata, ygpdata);
%the estimated hyperparameters
w1hat = exp(xp(1));    
a1hat = exp(xp(2));
v1hat = exp(xp(3));   
v0hat = exp(xp(4));  


% A variable for computing the confidence interval of GPFR
iuu = inv(zmat'*zmat); 

