function [yregfd, xp, iuu] = gpfrtrainkstep(xdata, ydata, zmat, K, Lag)
%
%GPFR method:
%

[cn,stepsize] = size(ydata);

yregfd = fdatrain(xdata, ydata, zmat);


%randomly select half data for training and shift the outputs along the mean function
yregtmp = (eval_fd(xdata,yregfd))'; 
meanmat = zmat*yregtmp;   %contains the means of three classes: U1, U2, U3, respectively
ygpdata = ydata - meanmat;
    

%estimate the hyperparameters of covariance function and noise variance
disp('Minimising the minus loglikelihood...')
%choose good starting values to avoid long-time optimising procedure
initwx = -1;
initwy = -10*ones(Lag,1); 
initv = -1; 
initgpn = -5;
[xp fxp ip] = minimize([initwx;initwy;initv;initgpn], 'repgp02likkstep', 200, xdata, ygpdata, K, Lag);


% A variable for computing the confidence interval of GPFR
iuu = inv(zmat'*zmat); 
