%
% Direct GP method: predict
%

xinputd = x(1,xindin);
xtestd = x(1,xindt);
youtputd = samyt(1,xindin);


%compute overall mean of the third group
ymeandall = sum(ymeand((2*sn+1):3*sn,1))/sn;
youtputd = youtputd - repmat(ymeandall,1,size(youtputd,2));

[mud, s2d] = gp01pred(xpd, xinputd', youtputd', xtestd');
ypredd = mud' + repmat(ymeandall,1,size(xtestd,2));
ypredupd = ypredd + 1.96*sqrt(s2d');    % 95% confidence interval
ypredlod = ypredd - 1.96*sqrt(s2d');


%display and assess
if ttype == 1
    gpfigname = './figs/randomgp.eps';
    rccpos = 1;
else
    gpfigname = './figs/firstgp.eps';
    rccpos = 3;
end

rcc(3,rccpos) = rmse(ypredd, samyt(1,xindt));
a = corrcoef(ypredd, samyt(1,xindt));
rcc(3,rccpos+1) = a(1,2);


figure(1);
clf
plot(xtestd, ypredd, 'r--', xtestd, [ypredupd;ypredlod], 'r:','LineWidth',1);
hold on;
plot(x, samyt(1,:),'b-');
xlabel('x'); ylabel('y');
print(gpfigname, '-depsc2');
clf
