%================================================================================
% Direct GP method: predict
%================================================================================


%compute overall mean of the third group
ymeandall = sum(ymeand((2*sn+1):3*sn,1))/sn;


%-------------------------------------
% Predict the second part step by step
%-------------------------------------
samsize = stepsize;
ygppredd = zeros(1,samsize-stpoint+1);
ygppreds2d = zeros(1,samsize-stpoint+1);
xinputd = x';
youtputd = samyt';
youtputd = youtputd - ymeandall;

for s = stpoint:samsize
	
    xdataaugd = xinputd((K+Lag):s-K,1);     
    xtestaugd = xinputd(s,1);

	for j=Lag:1
        xdataaugd = [ xdataaugd, youtputd(j:s-2*K-Lag+j,1) ];
        xtestaugd = [ xtestaugd, youtputd(s-K-Lag+j,1) ];
    end
    
  	[mud, s2d] = gp02pred(xpd, xdataaugd, youtputd((K+Lag):s-K,1), xtestaugd);
	ygppredd(1,s-stpoint+1) = (mud + ymeandall)';
	ygppreds2d(1,s-stpoint+1) = s2d;
	
end

ygppredupd = ygppredd + 1.96*sqrt(ygppreds2d);    % 95% confidence interval
ygppredlod = ygppredd - 1.96*sqrt(ygppreds2d);


%display and assess
rcc(3,1) = rmse(ygppredd, samyt(1,xindt));
a = corrcoef(ygppredd, samyt(1,xindt));
rcc(3,2) = a(1,2);


figure(1);
clf
plot(x(1,xindt), ygppredd, 'r--', x(1,xindt), [ygppredupd;ygppredlod], 'r:','LineWidth',1);
hold on;
plot(x,samyt,'b-');
xlabel('x'); ylabel('y');
figfilen = [figfile 'gp.eps'];
print('-depsc2', figfilen);
