function [ymeand, xpd] = gptrain(xdata, ydata, tdsize)
%
% Direct GP method: estimate the hyperparameters without using FDA
%

[cn,stepsize] = size(ydata);

xgpdatad = zeros(cn,tdsize);
ydatad = xgpdatad;
for i=1:cn
	[xindtrain,xresttrain] = srswor(stepsize,tdsize);
    xgpdatad(i,:) = xdata(1,xindtrain);
    ydatad(i,:) = ydata(i,xindtrain);
end


%compute the sample means of each curves
ymeand = sum(ydatad,2)/size(ydatad,2);

%shift the outputs along the means
ydatad = ydatad - repmat(ymeand,1,size(ydatad,2));


disp('Minimising the minus loglikelihood...')
%use good starting value to avoid long-time optimisation
initw1 = 1.5;  
inita1 = -4.5;
initv1 = -0.5;
initv0 = -6;
[xpd fxpd ipd] = minimize([initw1;inita1;initv1;initv0], 'repgp01lik', 100, xgpdatad, ydatad);
