function [ymeand, xpd] = gptrainkstep(xdata, ydata, K, Lag)
%
% Direct GP method: estimate the hyperparameters without using FDA
%

[cn,stepsize] = size(ydata);

%compute the means of each curves
ymeand = sum(ydata,2)/size(ydata,2);

%shift the outputs along the means
ydatad = ydata - repmat(ymeand,1,size(ydata,2));



disp('Minimising the minus loglikelihood...')
initwx = -1;
initwy = -10*ones(Lag,1);  %choose better starting value to avoid long-time optimisation
initv = -1; 
initgpn = -5;
[xpd fxpd ipd] = minimize([initwx;initwy;initv;initgpn], 'repgp02likkstep', 200, xdata, ydatad, K, Lag);
