function [fX, dfX] = repgp01lik(X, input, target)

%Compute minus log likelihood and its derivatives for batch data by using "gp01lik"
% X      is a (column) vector (of size D+2) of hyperparameters
% input  is a m by n matrix of training inputs
% target m by n matrix, where n is the number of data points and m is number of batches
% fX     is the returned value of minus log likelihood
% dfX    is a (column) vector (of size D+2) of partial derivatives
%        of minus the log likelihood wrt each of the hyperparameters



m = size(target,1);
target = target';    
input = input';      

fX = 0;
dfX = 0;

for i=1:m
    [fXt, dfXt] = gp01lik(X, input(:,i), target(:,i));
    fX = fX + fXt;
    dfX = dfX + dfXt;
end
