function [fX, dfX] = repgp02likstep(X, input, target, K, L)

%K-step-ahead: Compute minus log likelihood and its derivatives for repeated samples by using "gp02lik"
% X      is a (column) vector (of size D+2) of hyperparameters
% input  is a D by n matrix of training inputs
%target: m by n matrix, where n is the number of data points and m is repeated times
% fX     is the returned value of minus log likelihood
% dfX    is a (column) vector (of size D+2) of partial derivatives
%        of minus the log likelihood wrt each of the hyperparameters


tdsize = size(input,2);
m = size(target,1);
target = target';    
input = input';      

fX = 0;
dfX = 0;

for i=1:m
    
    xdataaug = input((K+L):tdsize,1); 
	for j=L:1
        xdataaug = [ xdataaug, target(j:tdsize-K-L+j,i) ];
    end
    
    [fXt, dfXt] = gp02lik(X, xdataaug, target((K+L):tdsize,i));
    fX = fX + fXt;
    dfX = dfX + dfXt;
    
end
