
sn = 10;                  % number of sample curves for each classe
n = 101;                  % number of sample points for each curve

U1 = [0 1]; 
U2 = [-1 1]; 
U3 = [1 1];               % three classes of samples

L = -4; H = 4;            % limits of points are "L" and "H"
x = (L:(H-L)/(n-1):H);    % sample points: 1 x n


v1 = 0.1; w1 = 1.0; v0 = 0.0025; a1 = 0.0;   %parameters of covariance function
theta = [v1; w1; v0; a1];

[truey1, rny1, samy1] = sampling(x, theta, U1, sn);
[truey2, rny2, samy2] = sampling(x, theta, U2, sn);
[truey3, rny3, samy3] = sampling(x, theta, U3, sn); 

%save training data file
Num = zeros(1,sn*3);
Num(1,1:3) = [30 2 n];
U = [repmat(U1',1,sn), repmat(U2',1,sn), repmat(U3',1,sn)];
X = repmat(x',1,30);
Y = [samy1',samy2',samy3'];

save train.data Num U X Y -ascii


%save test data
odsize = fix(n/3);   %output data size
Ut = U3;
[xindin,xindt] = srswor(n,odsize);
xt = x(1,xindt);
T = [U3, odsize, n-odsize, xindin,xindt]';

save test.data T -ascii