%A demo example, see 'readme.txt'
%B. Wang and J. Q. shi, 2005.

%You need to change path!!!

addpath('H:/shi/research/gp/gpfrcodes_win/gpfr');
addpath('H:/shi/research/gp/gpfrcodes_win/fda');

close('all'); clear('all');

%load trainig data
load train_data.mat


%--------------
% Training ....
%----------------
stepsize = size(traindata{1},1);               % training data size
tdsize = fix(stepsize/2);   % choose half data for training

[yregfd, sigv2fd] = fdatrain(traindata, U);             % FDA method
[yregfd, xp, iuu] = gpfrtrain(traindata, U, tdsize);  % GPFR ethod
[ymeand, xpd] = gptrain(traindata, tdsize);           % GP method


%--------------
% Predicting ....
%----------------

load test_data   %load test data
ttest = testdata(:,1);

[ypred, rcc] = fdapred(yregfd, sigv2fd, iuu, inputdata, testdata, Ut);
figure(1)
plot(ttest, ypred, 'r:','LineWidth',1);
hold on;
plot(inputdata(:,1), inputdata(:,end),'b');
xlabel('x'); ylabel('y');
title('Prediction by FDA');


[ypred, rcc] = gpfrpred(yregfd, sigv2fd, xp, iuu, inputdata, testdata, Ut);
figure(2)
plot(ttest, ypred, 'r:','LineWidth',1);
hold on;
plot(inputdata(:,1), inputdata(:,end),'b');
xlabel('x'); ylabel('y');
title('Prediction by GPFR');


[ypred, rcc] = gppred(ymeand, xpd, inputdata, testdata);
figure(3)
plot(ttest, ypred, 'r:','LineWidth',1);
hold on;
plot(inputdata(:,1), inputdata(:,end),'b');
xlabel('x'); ylabel('y');
title('Prediction by GP');