%A demo example of multiple-step-ahead forecasting, see 'readme.txt'
%B. Wang and J. Q. shi, 2005.


%You need to change path!!!

addpath('H:/shi/research/gp/gpfrcodes_win/gpfr');
addpath('H:/shi/research/gp/gpfrcodes_win/fda');

close('all'); clear('all');

sn = 10;                  % number of sample curves for each classe
n = 51;                  % number of sample points for each curve

U1 = [0 1]; 
U2 = [-1 1]; 
U3 = [1 1];               % three classes of samples

L = -4; H = 4;            % limits of points are "L" and "H"

v1 = 0.1; w1 = 1.0; v0 = 0.0025; a1 = 0.0;   %parameters of covariance function
theta = [v1; w1; v0; a1];

stepnum = [1;3;6];         % K-step ahead prediction
Lag = 1;                   % L: lag length. y(t_i) = f(x(t_i), y(t_{i-K}), y(t_{i-K-1}), ..., y(t_{i-K-L+1})).
tdata = (linspace(L,H,n))';
x = tdata;


%sampling for test: generate a new curve from the third group U3
Ut = U3;
[trueyt, rnyt, samyt] = sampling(x, theta, Ut, 1);


for ii = 1:size(stepnum,1)
    
    K = stepnum(ii);  
    titletext = [num2str(K) '-step-ahead-forcasting'];
    disp(['Press any key to run ' titletext '...']);
    pause;

    %---------------------
	% Sampling .....
	%---------------------
    traindata = cell(sn*3,1);
    truey = cell(sn*3,1);
    rny = cell(sn*3,1);
    U = [repmat(U1,sn,1); repmat(U2,sn,1); repmat(U3,sn,1)];

    for i=1:3*sn
        [truey1, rny1, samy1] = sampling(x, theta, U(i,:), 1);
        tempmat = zeros(n,4);
        tempmat = [tdata, x, samy1];
        
        traindata{i} = tempmat;
        truey{i} = truey1;
        rny{i} = rny1;
    end
	
	%------------
	% Training ...
	%------------
	stepsize = size(traindata{1},1);               % training data size
    tdsize = fix(stepsize/2);                      % choose half data for training

    [yregfd, sigv2fd] = fdatrain(traindata, U);             % FDA method
    [yregfd, xp, iuu] = gpfrtrainkstep(traindata, U, K, Lag);    % GPFR ethod
    [ymeand, xpd] = gptrainkstep(traindata, K, Lag);             % GP method

	
	%--------------
	% Predicting ....
	%----------------
	
	stpoint = ceil(stepsize/3);   %the point from which the prediction begins
    rcc = zeros(3,2);
    
    inputdata = [tdata, x, samyt];
    testdata = [tdata, x, samyt];

    [ygfpred, rcc1] = gpfrpredkstep(yregfd, sigv2fd, xp, iuu, inputdata, testdata, Ut, K, Lag, stpoint);
    [yfdapred, rcc2] = fdapredkstep(yregfd, sigv2fd, iuu, inputdata, testdata, Ut, stpoint);
    [ygppred, rcc3] = gppredkstep(ymeand, xpd, inputdata, testdata, K, Lag, stpoint);
        
    %Plot the results
    
    close all;
    ttest = tdata(stpoint:stepsize);
	figure(1)
    plot(ttest, yfdapred, 'r:','LineWidth',1);
    hold on;
    plot(tdata, samyt,'b');
    xlabel('x'); ylabel('y');
    title([titletext ': Prediction by FDA']);

    figure(2)
    plot(ttest, ygfpred, 'r:','LineWidth',1);
    hold on;
    plot(tdata, samyt,'b');
    xlabel('x'); ylabel('y');
    title([titletext ': Prediction by GPFR']);

    figure(3)
    plot(ttest, ygppred, 'r:','LineWidth',1);
    hold on;
    plot(tdata, samyt,'b');
    xlabel('x'); ylabel('y');
    title([titletext ': Prediction by GP']);
        
    rcc = [rcc1; rcc2; rcc3];
	datfile = ['.\figs\' num2str(K) 'stepwork1.mat'];
	rccfile = ['.\figs\' num2str(K) 'steprcc.txt'];	
	save(datfile);
	writercc(rcc, rccfile);
end
