%The first example discussed in Shi et al (2005), see 'readme.txt'
%B. Wang and J. Q. shi, 2005.

%You need to change path!!!

addpath('H:/shi/research/gp/gpfrcodes_win/gpfr');
addpath('H:/shi/research/gp/gpfrcodes_win/fda');

close('all'); clear('all');


sn = 10;                  % number of sample curves for each classe
n = 101;                  % number of sample points for each curve

U1 = [0 1]; 
U2 = [-1 1]; 
U3 = [1 1];               % three classes of samples

L = -4; H = 4;            % limits of points are "L" and "H"

v1 = 0.1; w1 = 1.0; v0 = 0.0025; a1 = 0.0;   %parameters of covariance function
theta = [v1; w1; v0; a1];


%---------------------
% Sampling .....
%---------------------

traindata = cell(sn*3,1);
truey = cell(sn*3,1);
rny = cell(sn*3,1);
U = [repmat(U1,sn,1); repmat(U2,sn,1); repmat(U3,sn,1)];
% %     U = 
% %     0   1  
% %     :   :  
% %     0   1 
% %    -1   1 
% %     :   : 
% %    -1   1 
% %     1   1 
% %     :   : 
% %     1   1 
% %     Thus, the actual model is: y_m = (a_1 a_2)(beta_1(t)  beta_2(t))' + eps(t)
% %     beta_1(t) = 1, beta_2(t) = sin(???).
% %     For the first group: (a_1 a_2) = (0 1)
% %     For the second group: (a_1 a_2) = (-1 1)
% %     For the third group: (a_1 a_2) = (1 1)
tdata = (linspace(L,H,n))';
x = tdata;
for i=1:3*sn
    [truey1, rny1, samy1] = sampling(x, theta, U(i,:), 1);
    
    tempmat = zeros(n,4);
    
    tempmat = [tdata, x, samy1];
    traindata{i} = tempmat;
    
    truey{i} = truey1;
    rny{i} = rny1;
end


%------------
% Training ...
%------------

stepsize = size(traindata{1},1);               % training data size
tdsize = fix(stepsize/2);                      % choose half data for training

[yregfd, sigv2fd] = fdatrain(traindata, U);             % FDA method
[yregfd, xp, iuu] = gpfrtrain(traindata, U, tdsize);    % GPFR ethod
[ymeand, xpd] = gptrain(traindata, tdsize);             % GP method


% % check estimated mean function: e.g. the third group: Um=1
% figure(1)
% clf
% plot(yregfd(1)+yregfd(2));    
% title('Regression Functions')
% hold on;
% plot(x,truey{30},'r');



%--------------
% Predicting ....
%----------------

rcc = zeros(3,4);           %rmse and correlation coeffients for three methods
odsize = fix(stepsize/2);   %output data size

%sampling for test: generate a new curve from the third group U3
Ut = U3;
[trueyt, rnyt, samyt] = sampling(x, theta, Ut, 1);
tempmat = [tdata, x, samyt];


%Test of Type 1: randomly choosed half
[xindin,xindt] = srswor(stepsize,odsize);
inputdata = tempmat(xindin,:);
testdata = tempmat(xindt,:);
ttest = testdata(:,1);

[ypred1, rcc1] = fdapred(yregfd, sigv2fd, iuu, inputdata, testdata, Ut);
figure
plot(ttest, ypred1, 'r:','LineWidth',1);
hold on;
plot(tdata, samyt,'b');
xlabel('x'); ylabel('y');
title('Interpolation: Prediction by FDA');


[ypred2, rcc2] = gpfrpred(yregfd, sigv2fd, xp, iuu, inputdata, testdata, Ut);
figure
plot(ttest, ypred2, 'r:','LineWidth',1);
hold on;
plot(tdata, samyt,'b');
xlabel('x'); ylabel('y');
title('Interpolation: Prediction by GPFR');


[ypred3, rcc3] = gppred(ymeand, xpd, inputdata, testdata);
figure
plot(ttest, ypred3, 'r:','LineWidth',1);
hold on;
plot(tdata, samyt,'b');
xlabel('x'); ylabel('y');
title('Interpolation: Prediction by GP');

rcc(:,1:2) = [rcc1; rcc2; rcc3];
disp('Press any key to continue...');
pause;


%Test of Type 2: predict the second half

xindin = 1:odsize;
xindt = (odsize+1):stepsize;

inputdata = tempmat(xindin,:);
testdata = tempmat(xindt,:);
ttest = testdata(:,1);

[ypred1, rcc1] = fdapred(yregfd, sigv2fd, iuu, inputdata, testdata, Ut);
figure
plot(ttest, ypred1, 'r:','LineWidth',1);
hold on;
plot(tdata, samyt,'b');
xlabel('x'); ylabel('y');
title('Extrapolation: Prediction by FDA');


[ypred2, rcc2] = gpfrpred(yregfd, sigv2fd, xp, iuu, inputdata, testdata, Ut);
figure
plot(ttest, ypred2, 'r:','LineWidth',1);
hold on;
plot(tdata, samyt,'b');
xlabel('x'); ylabel('y');
title('Extrapolation: Prediction by GPFR');


[ypred3, rcc3] = gppred(ymeand, xpd, inputdata, testdata);
figure
plot(ttest, ypred3, 'r:','LineWidth',1);
hold on;
plot(tdata, samyt,'b');
xlabel('x'); ylabel('y');
title('Extrapolation: Prediction by GP');

rcc(:,3:4) = [rcc2; rcc1; rcc3];

%----------------
% Saving results ....
%----------------

save '.\figs\work1.mat'
writercc(rcc, '.\figs\rcc.txt');

