function [ypred, rcc] = fdapred(yregfd, sigv2fd, iuu, inputdata, testdata, Ut, stpoint)
%Prediction: FDA method


ttest = testdata(stpoint:end,1);

yregtmp = eval_fd(ttest,yregfd); 
ypredfda = yregtmp*Ut';

sigv2 = eval_fd(ttest,sigv2fd);
s2 = sigv2*(1 + Ut*iuu*Ut');
ypredfdaup = ypredfda + 1.96*sqrt(s2);
ypredfdalo = ypredfda - 1.96*sqrt(s2);

ypred = [ypredfda, ypredfdaup, ypredfdalo];

if size(ttest,1) > 1
    rcc = zeros(1,2);
    samyt = testdata(stpoint:end,end);
    rcc(1,1) = rmse(ypredfda, samyt);
    a = corrcoef(ypredfda, samyt);
    rcc(1,2) = a(1,2);
else
    rcc = NaN;
end



