function [yregfd, sigv2fd] = fdatrain(traindata, zmat)

cnum = size(traindata,1);

tmin = 0; tmax = 0; tlengmax = 0;
for j=1:cnum
    tdata = traindata{j}(:,1);
    tmin0 = min(tdata);
    tmax0 = max(tdata);
    if tmin0 < tmin, tmin = tmin0; end
    if tmax0 > tmax, tmax = tmax0; end
    if tlengmax < size(tdata,1), tlengmax = size(tdata,1); end
end        


tdata = zeros(tlengmax, cnum);
cy = zeros(tlengmax, cnum);  
for i=1:cnum
    ttemp = traindata{i}(:,1);
    ytemp = traindata{i}(:,end);
    tleng = length(ytemp);
    if tleng < tlengmax
        tdata(:,i) = [ttemp; NaN*ones(tlengmax-tleng, 1)]
        cy(:,i) = [ytemp; NaN*ones(tlengmax-tleng, 1)];
    else
        tdata(:,i) = ttemp;
        cy(:,i) = ytemp;
    end
end


bsbasis = create_bspline_basis([tmin,tmax], 20);
yfd = data2fd(cy, tdata, bsbasis);    
	

linmodstr = linmod(zmat, yfd);
yregfd = linmodstr.reg;


%--------------------------------------------------------------
% Some quantities for computing the confidence interval
%--------------------------------------------------------------
[stepsize,cn] = size(cy);

yhatfd = linmodstr.yhat;
yresfd = yfd - yhatfd;
tdata = (linspace(tmin,tmax,tlengmax))';
yresmat = eval_fd(tdata,yresfd);
sigv2 = sum((yresmat).^2, 2)./(cn-1);
sigv2fd = data2fd(sigv2, tdata, bsbasis);  

