function [yresult, rcc] = gpfrpred(yregfd, sigv2fd, xp, iuu, inputdata, testdata, Ut)
%Prediction: GPFR method

tinput = inputdata(:,1);
xinput = inputdata(:,2:end-1);
yinput = inputdata(:,end);
ttest = testdata(:,1);
xtest = testdata(:,2:end-1);

%shift the observed data along the mean function
yregtmp = eval_fd(tinput,yregfd); 
ygpobs = yinput - yregtmp*Ut';

%predict the means and the variances of the test outputs, given the input xdata and the output
[mu, s2] = gp01pred(xp, xinput, ygpobs, xtest);
ygppred = mu;
s2 = s2*(1 + Ut*iuu*Ut');


%shift back the test output along the mean function
yregtmp = eval_fd(ttest,yregfd); 
ypred = ygppred + yregtmp*Ut';
ypredup = ypred + 1.96*sqrt(s2);    % 95% confidence interval
ypredlo = ypred - 1.96*sqrt(s2);

yresult = [ypred, ypredup, ypredlo];

if size(ttest,1) > 1
    samyt = testdata(:,end);
    rcc = zeros(1,2);
    rcc(1,1) = rmse(ypred, samyt);
    a = corrcoef(ypred, samyt);
    rcc(1,2) = a(1,2);
else
    rcc = NaN;
end
