function [ygfpred, rcc] = gpfrpred(yregfd, sigv2fd, xp, iuu, inputdata, testdata, Ut, K, Lag, stpoint)
%Prediction: GPFR method

tdata = inputdata(:,1);
x = inputdata(:,2:end-1);
samyt = inputdata(:,end);
%shift the observed data along the mean function
yregtmp = eval_fd(tdata,yregfd); 
newsamyt = samyt - yregtmp*Ut';
stepsize = length(tdata);

ygppred = zeros(stepsize-stpoint+1,1);
ygppreds2 = zeros(stepsize-stpoint+1,1);

for s = stpoint:stepsize
    %Reconstruct the input data and test data       
    newinputtdata = tdata((K+Lag):s-K,1);
    newtesttdata = tdata(s,1);
    newinputxdata = x((K+Lag):s-K,1);     
    newtestxdata = x(s,1);
    for j=Lag:-1:1
        newinputxdata = [ newinputxdata, newsamyt(j:s-2*K-Lag+j,1) ];
        newtestxdata = [ newtestxdata, newsamyt(s-K-Lag+j,1) ];
    end
    newinputydata = newsamyt((K+Lag):s-K,1);
    newtestydata = newsamyt(s,1);

    %predict the means and the variances of the test outputs, given the input xdata and the output
    [mu, s2] = gp01pred(xp, newinputxdata, newinputydata, newtestxdata);
    ygppred(s-stpoint+1,1) = mu;
    ygppreds2(s-stpoint+1,1) = s2*(1 + Ut*iuu*Ut');
end

%shift back the test output along the mean function
indtest = stpoint:stepsize;
yregtmp = eval_fd(tdata(indtest), yregfd); 
ygfpred = zeros(stepsize-stpoint+1,1);
ygfpred(:,1) = ygppred + yregtmp*Ut';
ygfpred(:,2) = ygfpred(:,1) + 1.96*sqrt(ygppreds2);    % 95% confidence interval
ygfpred(:,3) = ygfpred(:,1) - 1.96*sqrt(ygppreds2);

%Compute rmse and r

rcc = zeros(1,2);             %rmse and correlation coeffients for three methods    
rcc(1,1) = rmse(ygfpred(:,1), samyt(stpoint:stepsize));
a = corrcoef(ygfpred(:,1), samyt(stpoint:stepsize));
rcc(1,2) = a(1,2);
