function [yregfd, xp, iuu] = gpfrtrain(traindata, zmat, tdsize)
%
%GPFR method:
%

yregfd = fdatrain(traindata, zmat);

cn = size(traindata,1);

%randomly select a part of data for training and shift the outputs along the mean function
%and save in gptraindata

gptraindata = cell(cn,1);
for i=1:cn
    tdata = traindata{i}(:,1);
    yregtmp = eval_fd(tdata,yregfd);
    meanvec = yregtmp*(zmat(i,:))';
    
    tempmat = traindata{i};
    tempmat(:,end) = tempmat(:,end) - meanvec;
    
    stepsize = length(tdata);
	[xindtrain,xresttrain] = srswor(stepsize,tdsize);
    
    gptraindata{i} = tempmat(xindtrain,:);    
end


%estimate the hyperparameters of covariance function and noise variance

disp('Minimising the minus loglikelihood...')
numinput = size(gptraindata{1},2)-2;
init0 = unifrnd(-5,0,numinput*2+2,1);
[xp fxp ip] = minimize(init0, 'repgp01lik', 200, gptraindata);


% A variable for computing the confidence interval of GPFR
iuu = inv(zmat'*zmat); 

