function [yresult, rcc] = gppred(ymeand, xpd, inputdata, testdata)
%
% Direct GP method: predict
%

tinput = inputdata(:,1);
xinput = inputdata(:,2:end-1);
yinput = inputdata(:,end);
ttest = testdata(:,1);
xtest = testdata(:,2:end-1);

%compute overall mean of the third group
ymeant = sum(ymeand(21:30))/10;
%ymeant = sum(yinput,1)/size(yinput,1);
ygpinput = yinput - ymeant;

[mud, s2d] = gp01pred(xpd, xinput, ygpinput, xtest);
ypredd = mud + ymeant;
ypredupd = ypredd + 1.96*sqrt(s2d);    % 95% confidence interval
ypredlod = ypredd - 1.96*sqrt(s2d);

yresult = [ypredd, ypredupd, ypredlod];

if size(ttest,1) > 1
    samyt = testdata(:,end);
    rcc = zeros(1,2);
    rcc(1,1) = rmse(ypredd, samyt);
    a = corrcoef(ypredd, samyt);
    rcc(1,2) = a(1,2);
else
    rcc = NaN;
end