function [ymeand, xpd] = gptrain(traindata, tdsize)
%
% Direct GP method: estimate the hyperparameters without using FDA
%

cn = size(traindata,1);
gptraindata = cell(cn,1);
ymeand = zeros(cn,1);
for i=1:cn
    tempmat = traindata{i};
    ymeand(i) = sum(tempmat(:,end),1) / size(tempmat,1);
    tempmat(:,end) = tempmat(:,end) - ymeand(i);
    stepsize = size(tempmat,1);
	[xindtrain,xresttrain] = srswor(stepsize,tdsize);
    
    gptraindata{i} = tempmat(xindtrain,:);    
end


%estimate the hyperparameters of covariance function and noise variance

disp('Minimising the minus loglikelihood...')
numinput = size(gptraindata{1},2)-2;
init0 = unifrnd(-5,0,numinput*2+2,1);
[xpd fxpd ipd] = minimize(init0, 'repgp01lik', 100, gptraindata);
