function [ymeand, xpd] = gptrainkstep(traindata, K, L)
%
% Direct GP method: estimate the hyperparameters without using FDA
%

cn = size(traindata,1);
gptraindata = cell(cn,1);
ymeand = zeros(cn,1);
for i=1:cn
    tdata = traindata{i}(:,1);
    input  = traindata{i}(:,2:end-1);
    target = traindata{i}(:,end);
    
    ymeand(i) = sum(target,1) / size(target,1);
    target = target - ymeand(i);

    tdsize = size(input,1);
    newtdata = tdata((K+L):tdsize);
    newinput = input((K+L):tdsize); 
	for j=L:-1:1
        newinput = [ newinput, target(j:tdsize-K-L+j) ];
    end
    newtarget = target((K+L):tdsize);
        
    tempmat = [newtdata, newinput, newtarget];
    gptraindata{i} = tempmat;    
end


%estimate the hyperparameters of covariance function and noise variance

disp('Minimising the minus loglikelihood...')
numinput = size(gptraindata{1},2)-2;
init0 = unifrnd(-5,0,numinput*2+2,1);
[xpd fxpd ipd] = minimize(init0, 'repgp01lik', 200, gptraindata);