function [fX, dfX] = repgp01lik(X, gptraindata)

%Compute minus log likelihood and its derivatives for batch data by using "gp01lik"
% fX     is the returned value of minus log likelihood
% dfX    is a (column) vector (of size D+2) of partial derivatives
%        of minus the log likelihood wrt each of the hyperparameters


m = size(gptraindata,1);

fX = 0;
dfX = 0;

for i=1:m
    input = gptraindata{i}(:,2:end-1);
    target = gptraindata{i}(:,end);
    [fXt, dfXt] = gp01lik(X, input, target);
    fX = fX + fXt;
    dfX = dfX + dfXt;
end
