function [truey, rny, sampy] = sampling(x, theta, um, sn)
%x: input
%theta: parameters in covariance function
%Um: class value
%sn: number of GP curves of each class

x = x';

n = size(x,2);  %number of sample points for each curve
noise = 0.0081; % variance of noise


%parameters for nonstationary covariance function
v1 = theta(1); w1 = theta(2); v0 = theta(3); a1 = theta(4);  

%Covariance matrix
Q = v1*exp(-0.5*w1*(ones(n,1)*x-x'*ones(1,n)).^2)...
    + a1*((ones(n,1)*x).*(x'*ones(1,n))) + v0*eye(n);     

%dependent variables
y0 = examfun(um, x);                       %1 x n: true curve
y1 = y0 + sqrt(noise)*randn(1,n);           %1 x n: with random noise
y2 = ones(sn,1)*y0 + randn(sn,n)*chol(Q);   %sn x n : with GP noise

truey = y0';
rny = y1';
sampy = y2';


%figure
%plot(x,[y0;y1;y2]);
%figure
%plot(x,[y0;y2]);