function [truey, rny, sampy] = sampling(x, theta, um, sn)
%x: input
%theta: parameters in covariance function
%Um: class value
%sn: number of GP curves of each class

noise = 0.0081;          % variance of noise
[n, D] = size(x);        % number of examples and dimension of input space
expX = theta;            % exponentiate the hyperparameters once and for all


% first, we write out the covariance matrix Q

Z = zeros(n,n); Q = zeros(n,n);                         % create and zero space
for d = 1:D                                           % non-linear contribution
  Z = Z + (x(:,d)*ones(1,n)-ones(n,1)*x(:,d)').^2*expX(d);
end
Z = expX(2*D+1)*exp(-0.5*Z);
for d = 1:D                                               % linear contribution
  Q = Q + expX(D+d)*x(:,d)*x(:,d)';
end
Q = Q + Z + expX(2*D+2)*eye(n);        % linear term, non-linear term and noise


%dependent variables
y0 = examfun_2d(um, x);                       %1 x n: true curve
y1 = y0 + sqrt(noise)*randn(n,1);           %1 x n: with random noise
y2 = y0*ones(1,sn) + chol(Q)*randn(n,sn);   %sn x n : with GP noise


truey = y0;
rny = y1;
sampy = y2;

%figure
%plot(x,[y0;y1;y2]);
%figure
%plot(x,[y0;y2]);

