
sn = 10;                  % number of sample curves for each classe
n = 101;                  % number of sample points for each curve

U1 = [0 1]; 
U2 = [-1 1]; 
U3 = [1 1];               % three classes of samples

L = -4; H = 4;            % limits of points are "L" and "H"

v1 = 0.1; w1 = 1.0; v0 = 0.0025; a1 = 0.0;   %parameters of covariance function
theta = [v1; w1; v0; a1];


traindata = cell(sn*3,1);
truey = cell(sn*3,1);
rny = cell(sn*3,1);
U = [repmat(U1,sn,1); repmat(U2,sn,1); repmat(U3,sn,1)];
tdata = (linspace(L,H,n))';
x = tdata;
for i=1:3*sn
    [truey1, rny1, samy1] = sampling(x, theta, U(i,:), 1);
    
    tempmat = zeros(n,4);
    
    tempmat = [tdata, x, samy1];
    traindata{i} = tempmat;
    
    truey{i} = truey1;
    rny{i} = rny1;
end
    

%save training data file

save train_data U traindata truey rny



%save test data
Ut = U3;
[truey1, rny1, samy1] = sampling(x, theta, Ut, 1);
tempmat = [tdata, x, samy1];

odsize = fix(n/2);   %output data size
[xindin,xindt] = srswor(n,odsize);
inputdata = zeros(odsize,4);
testdata = zeros(n-odsize,4);

inputdata = tempmat(xindin,:);
testdata = tempmat(xindt,:);

save test_data Ut inputdata testdata


