function r = writercc (rcc, filename)

[m,n] = size(rcc);

if m ~= 3
    error('rcc must have 3 rows!');
elseif mod(n, 2) ~= 0
    error('rcc must have even cols!');
else
    fid = fopen(filename, 'w');
    
    
    fprintf(fid, '       ');
    for i=1:2:n
        fprintf(fid, 'rmse         r      ');
    end
    fprintf(fid, '\\n');
    
    
    fprintf(fid, 'GPFDA  ');
    for j=1:n/2
        fprintf(fid, '%3.4f    %3.4f    ', rcc(1,j*2-1), rcc(1,j*2)); 
    end
    fprintf(fid, '\\n');
    
    
    fprintf(fid, 'FDA    ');
    for j=1:n/2
        fprintf(fid, '%3.4f    %3.4f    ', rcc(2,j*2-1), rcc(2,j*2)); 
    end
    fprintf(fid, '\\n');

    
    fprintf(fid, 'GP     ');
    for j=1:n/2
        fprintf(fid, '%3.4f    %3.4f    ', rcc(3,j*2-1), rcc(3,j*2)); 
    end
    
    fclose(fid);
end