/************************************************************************
 * CASSI, version 1.01
 * Copyright 2012,
 * Richard Howey
 * Institute of Genetic Medicine, Newcastle University
 *
 * richard.howey@ncl.ac.uk
 * http://www.staff.ncl.ac.uk/richard.howey/
 *
 * This file is part of CASSI, the SNP interaction analysis program.
 *
 * CASSI is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * CASSI is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CASSI.  If not, see <http://www.gnu.org/licenses/>.
 ************************************************************************/


/*! \file Analysis.h
    \brief This file organises the analysis.
    
*/

#ifndef __ANALYSIS
#define __ANALYSIS

#include <string>

using namespace std; // initiates the "std" or "standard" namespace

#include "Data.h"
#include "main.h"
#include "Statistics.h"

//! Returns a string of the run time
string getTime(const double & t);

//! Organises the correect analysis to perform.
class Analysis
{
private:

	//parameters for the options of the analysis to perform
	string filename;
	string filename2;
	string outputFileName;
	
	unsigned int snp1StartSNP;
	unsigned int snp1EndSNP;
	unsigned int snp2StartSNP;
	unsigned int snp2EndSNP;
	double thresholdCC;
	double thresholdCO;
	unsigned int maxNoResults;
	unsigned int totalResults;

public:

	Analysis(string & fn, string & fn2, string & ofn, unsigned int & a1, unsigned int & a2, unsigned int & b1, unsigned int & b2, double & thcc, double & thco, unsigned int & mx) :  filename(fn), filename2(fn2), outputFileName(ofn), snp1StartSNP(a1), snp1EndSNP(a2), snp2StartSNP(b1), snp2EndSNP(b2), thresholdCC(calculateChiSqFromPvalue(thcc)), thresholdCO(calculateChiSqFromPvalue(thco)), maxNoResults(mx), totalResults(0)
	{ 
			
	};

	//! Delete analysis things
	~Analysis()
	{
		
	};

	void runAnalysis();

};


#endif
