//////////////////////////////////////////////////////////////////////////
//                                 Word.c                               //
// Purpose                                                              //
// =======                                                              //
// This file provides the implementation for class Word.                //
//                                                                      //
// Author            Creation Date                                      //
// ======            =============                                      //
// P.A.Lee           12 December 1995                                   //
//////////////////////////////////////////////////////////////////////////

#include <iostream>
#include <cctype>

using namespace std;

#include "Text.h"
#include "Word.h"

//////////////////////////////////////////////////////////////////////////
//                        Constructor Definitions                       //
//////////////////////////////////////////////////////////////////////////

Word::Word()
{
  return;                    // No initalization required.
}

Word::Word(Text word)
{
  wordRep = "";              // Initialize representation to null string
  for (int count = 0; count < word.length(); count += 1)
  {
    if (!(isalpha(word(count)) || isdigit(word(count))))
    {                       // Break out of repetition when a
      break;                //   non-alphabetic/digit character is found
    }
    if (isupper(word(count)))
    {
      wordRep += Text(tolower(word(count))); // Convert to lower case
    }
    else
    {
      wordRep += Text(word(count));
    }
  } // end for
  return;
} // end Word(...)

//////////////////////////////////////////////////////////////////////////
//                       Member Function Definitions                    //
//////////////////////////////////////////////////////////////////////////

ostream& Word::print(ostream& outStream)
{
  outStream << wordRep;
  return outStream;
} //end print()

istream& Word::input(istream& inStream)
{
  char nextChar;
  
  wordRep = "";    // Initialize to an empty Text string
  do               // Skip non-alphabetic characters
  {
    inStream.get(nextChar);
    if (!inStream.good())
    {
      return inStream;        // Error has occurred. Return
    }
  } while (!(isalpha(nextChar) || isdigit(nextChar)));
  
  // First alphabetic character is in nextChar
  do
  {
    if (isupper(nextChar))
    {
      nextChar = tolower(nextChar);
    }
    wordRep += Text(nextChar);
    inStream.get(nextChar);
    if (!inStream.good())
    {
      return inStream;        // Error has occurred. Return
    }
  } while (isalpha(nextChar) || isdigit(nextChar));
  
  inStream.putback(nextChar);  // Put the terminating char back
  return inStream;
} // end input()

//////////////////////////////////////////////////////////////////////////
//                        Member Operator Definition                    //
//////////////////////////////////////////////////////////////////////////

bool Word::operator==(Word rhs)
{
  return (wordRep == rhs.wordRep);
} // end operator==(...)

//////////////////////////////////////////////////////////////////////////
//                        I/O Operator Definitions                      //
//////////////////////////////////////////////////////////////////////////

ostream& operator<<(ostream& outStream, Word word)
{
  return word.print(outStream);
} // end operator<<()

istream& operator>>(istream& inStream, Word& word)
{
  return word.input(inStream);
} // end operator>>()
 