//////////////////////////////////////////////////////////////////////////
//                               v4playcd.c                             //
//                                                                      //
// Purpose                                                              //
// =======                                                              //
// Version 4 of the CD-playing program.                                 //
//                                                                      //
// Author            Creation Date                                      //
// ======            =============                                      //
// P.A.Lee           12 December 1995                                   //
//                                                                      //
// Input/Output                                                         //
// ============                                                         //
// No input required. No output produced (unless an error ocurs).       //
//                                                                      //
//////////////////////////////////////////////////////////////////////////

#include "CDPlayer.h"
#include "CDisc.h"

int main()
{
  CDPlayer  myPlayer;     // Declare the objects
  CDisc     aDisc;

  myPlayer.on();          // Power on player
                          // Play the disc
                               // Put disc into player
  myPlayer.open();                   // Open drawer
  myPlayer.load(aDisc);              // Load disc
  myPlayer.close();                  // Close drawer
                               // Instruct player to play
  myPlayer.play();                   // Press "Play" button
                               // Remove disc from player
  myPlayer.open();                   // Open drawer
  aDisc = myPlayer.unload();         // Unload disc
  myPlayer.close();                  // Close drawer

  myPlayer.off();         // Power off player
  
  return 0;
} // end main()
